/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import ucar.nc2.constants.CDM;
import ucar.unidata.util.StringUtil2;

public class NcepHtmlScraper {
    private static final String dirOut = "C:/tmp/ncep/";
    private static final boolean debugParam = false;
    private static final boolean debug = false;
    private static final boolean show = false;

    void parseTopDoc() throws IOException {
        String source = "http://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc.shtml";
        Document doc = Jsoup.parse((URL)new URL(source), (int)5000);
        Elements links = doc.select("a[href]");
        for (org.jsoup.nodes.Element link : links) {
            Node sib = link.nextSibling();
            String title = null;
            if (sib != null) {
                String sibt = sib.toString();
                title = StringUtil2.remove((String)sibt, (String)"-").trim();
            }
            if (link.text().equals("Table 4.2")) {
                this.parseTable42(link.attr("abs:href"), link.text(), title);
                continue;
            }
            if (!link.text().startsWith("Table 4")) continue;
            this.parseCodeTable(link.attr("abs:href"), link.text(), title);
        }
    }

    void parseCodeTable(String url, String tableName, String title) throws IOException {
        System.out.printf("parseCodeTable url=%s tableName=%s title=%s%n", url, tableName, title);
        Document doc = Jsoup.parse((URL)new URL(url), (int)5000);
        if (title == null) {
            title = "NCEP GRIB-2 Code Table";
        }
        org.jsoup.nodes.Element table = doc.select("table").first();
        ArrayList<Code> stuff = new ArrayList<Code>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            Elements cols = row.select("td");
            if (cols.size() < 2) continue;
            String snum = StringUtil2.cleanup((String)cols.get(0).text()).trim();
            String desc = StringUtil2.cleanup((String)cols.get(1).text()).trim();
            if (snum.contains("Reserved") || desc.contains("Reserved")) continue;
            try {
                int pnum = Integer.parseInt(snum);
                stuff.add(new Code(pnum, desc));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        String filename = StringUtil2.removeWhitespace((String)tableName);
        this.writeCodeTableXml(filename, title, url, tableName, stuff);
    }

    private void writeCodeTableXml(String filename, String title, String source, String tableName, List<Code> stuff) throws IOException {
        Element rootElem = new Element("codeTable");
        org.jdom2.Document doc = new org.jdom2.Document(rootElem);
        rootElem.addContent((Content)new Element("table").setText(tableName));
        rootElem.addContent((Content)new Element("title").setText(title));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (Code p : stuff) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.no));
            paramElem.addContent((Content)new Element("description").setText(p.desc));
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(dirOut + filename + ".xml");){
            fout.write(x.getBytes(CDM.utf8Charset));
        }
    }

    void parseTable42(String url, String tableName, String title) throws IOException {
        System.out.printf("parseTable42 url=%s tableName=%s title=%s%n", url, tableName, title);
        Document doc = Jsoup.parse((URL)new URL(url), (int)5000);
        Elements links = doc.select("a[href]");
        for (org.jsoup.nodes.Element link : links) {
            this.parseParamTable(link.attr("abs:href"), link.text());
        }
    }

    void parseParamTable(String url, String title) throws IOException {
        String match = "grib2_table4";
        if (!url.contains(match)) {
            return;
        }
        System.out.printf("parseParamTable url=%s title=%s%n", url, title);
        Document doc = Jsoup.parse((URL)new URL(url), (int)5000);
        if (title == null) {
            title = "NCEP GRIB-2 Param Table";
        }
        org.jsoup.nodes.Element table = doc.select("table").first();
        assert (table != null);
        ArrayList<Param> stuff = new ArrayList<Param>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            String units;
            String desc;
            String snum;
            Elements cols = row.select("td");
            if (cols.size() == 4) {
                snum = StringUtil2.cleanup((String)cols.get(0).text()).trim();
                desc = StringUtil2.cleanup((String)cols.get(1).text()).trim();
                if (snum.contains("Reserved") || desc.contains("Reserved") || desc.contains("Missing")) continue;
                try {
                    int pnum = Integer.parseInt(snum);
                    units = cols.get(2).text();
                    String abbrev = cols.get(3).text();
                    stuff.add(new Param(pnum, desc, units, abbrev));
                }
                catch (NumberFormatException e) {
                    System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
                }
                continue;
            }
            if (cols.size() != 3) continue;
            snum = StringUtil2.cleanup((String)cols.get(0).text()).trim();
            desc = StringUtil2.cleanup((String)cols.get(1).text()).trim();
            if (snum.contains("Reserved") || desc.contains("Reserved") || desc.contains("Missing")) continue;
            try {
                int pnum = Integer.parseInt(snum);
                units = cols.get(2).text();
                stuff.add(new Param(pnum, desc, units, null));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        int pos = url.indexOf(match) + match.length();
        int lastPos = url.lastIndexOf(46);
        String filename = "Table4" + url.substring(pos, lastPos);
        filename = StringUtil2.removeWhitespace((String)filename);
        filename = StringUtil2.substitute((String)filename, (String)"-", (String)".");
        this.writeParamTableXml(filename, title, url, filename, stuff);
    }

    private void writeParamTableXml(String filename, String title, String source, String tableName, List<Param> stuff) throws IOException {
        Element rootElem = new Element("parameterMap");
        org.jdom2.Document doc = new org.jdom2.Document(rootElem);
        rootElem.addContent((Content)new Element("table").setText(tableName));
        rootElem.addContent((Content)new Element("title").setText(title));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (Param p : stuff) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.pnum));
            paramElem.addContent((Content)new Element("shortName").setText(p.name));
            paramElem.addContent((Content)new Element("description").setText(p.desc));
            paramElem.addContent((Content)new Element("units").setText(p.unit));
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(dirOut + filename + ".xml");){
            fout.write(x.getBytes(CDM.utf8Charset));
        }
    }

    private void writeTable2Wgrib(String name, String source, String filename, List<Param> params) throws IOException {
        Formatter f = new Formatter();
        f.format("# %s%n", name);
        f.format("# %s%n", source);
        for (Param p : params) {
            f.format("%3d:%s:%s [%s]%n", p.pnum, p.name, p.desc, p.unit);
        }
        FileOutputStream fout = new FileOutputStream(dirOut + filename);
        fout.write(f.toString().getBytes(CDM.utf8Charset));
        fout.close();
    }

    public static void main(String[] args) throws IOException {
        File dir = new File(dirOut);
        dir.mkdirs();
        NcepHtmlScraper scraper = new NcepHtmlScraper();
        scraper.parseTopDoc();
    }

    private static class Param {
        int pnum;
        String desc;
        String unit;
        String name;

        private Param(int pnum, String desc, String unit, String name) {
            this.pnum = pnum;
            this.desc = desc;
            this.unit = StringUtil2.cleanup((String)unit);
            this.name = StringUtil2.cleanup((String)name);
        }
    }

    private static class Code {
        int no;
        String desc;

        private Code(int no, String desc) {
            this.no = no;
            this.desc = desc;
        }
    }
}

