/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.iosp.IOServiceProvider;

public class Grib1Collection
extends GribCollection {
    public Grib1Collection(String name, File directory, FeatureCollectionConfig config) {
        super(name, directory, config, true);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getIndexFilepathInCache(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollection gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib1Iosp iosp = new Grib1Iosp(gc);
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getIndexFilepathInCache(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        return null;
    }

    @Override
    public GridDataset getGridDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getIndexFilepathInCache() + "#" + group.getId(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollection gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib1Iosp iosp = new Grib1Iosp(gc);
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getIndexFilepathInCache(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        return null;
    }

    @Override
    public String makeVariableName(GribCollection.VariableIndex vindex) {
        Grib1Customizer cust1 = (Grib1Customizer)this.cust;
        Grib1SectionProductDefinition pdss = new Grib1SectionProductDefinition(vindex.rawPds);
        return Grib1Iosp.makeVariableName(cust1, pdss);
    }
}

