/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionBinaryData {
    private final int length;
    private final long startingPosition;

    public Grib1SectionBinaryData(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        this.length = GribNumbers.uint3(raf);
        raf.seek(this.startingPosition + (long)this.length);
    }

    public Grib1SectionBinaryData(long startingPosition, int length) {
        this.startingPosition = startingPosition;
        this.length = length;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    public int getLength() {
        return this.length;
    }

    public int getNBits(RandomAccessFile raf) throws IOException {
        raf.seek(this.startingPosition + 10L);
        return raf.read();
    }

    public float getRefValue(RandomAccessFile raf) throws IOException {
        raf.seek(this.startingPosition + 6L);
        return GribNumbers.float4(raf);
    }

    public void show(RandomAccessFile raf, Formatter f) {
    }
}

