/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.wmo.Util;
import ucar.unidata.util.StringUtil2;

@Immutable
public class Grib2Parameter
implements GribTables.Parameter,
Comparable<Grib2Parameter> {
    public int discipline;
    public int category;
    public int number;
    public String name;
    public String unit;
    public String abbrev;
    public String desc;

    public Grib2Parameter(int discipline, int category, int number, String name, String unit, String abbrev, String desc) {
        this.discipline = discipline;
        this.category = category;
        this.number = number;
        this.name = name.trim();
        this.abbrev = abbrev;
        this.unit = Util.cleanUnit((String)unit);
        this.desc = desc;
    }

    @Override
    public String getId() {
        return this.discipline + "." + this.category + "." + this.number;
    }

    @Override
    public int compareTo(Grib2Parameter o) {
        int c = this.discipline - o.discipline;
        if (c != 0) {
            return c;
        }
        c = this.category - o.category;
        if (c != 0) {
            return c;
        }
        return this.number - o.number;
    }

    @Override
    public int getDiscipline() {
        return this.discipline;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getAbbrev() {
        return this.abbrev;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return "Grib2Parameter{discipline=" + this.discipline + ", category=" + this.category + ", number=" + this.number + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", abbrev='" + this.abbrev + '\'' + ", desc='" + this.desc + '\'' + '}';
    }

    public static void compareTables(String name1, String name2, List<Grib2Parameter> test, Grib2Customizer reference, Formatter f) {
        int extra = 0;
        int udunits = 0;
        int conflict = 0;
        f.format("Table 1 : %s%n", name1);
        f.format("Table 2 : %s%n", name2);
        for (Grib2Parameter p1 : test) {
            boolean isUnitless2;
            String p2n;
            GribTables.Parameter p2 = reference.getParameter(p1.getDiscipline(), p1.getCategory(), p1.getNumber());
            if (p2 == null) {
                if (p1.getCategory() >= 192 || p1.getNumber() >= 192) continue;
                ++extra;
                f.format("  WMO missing %s%n", p1);
                continue;
            }
            String p1n = Util.cleanName((String)p1.getName());
            if (!p1n.equalsIgnoreCase(p2n = Util.cleanName((String)p2.getName()))) {
                f.format("  p1=%10s %40s %15s %15s %s%n", p1.getId(), p1.getName(), p1.getUnit(), p1.getAbbrev(), p1.getDescription());
                f.format("  p2=%10s %40s %15s %15s %s%n%n", p2.getId(), p2.getName(), p2.getUnit(), p2.getAbbrev(), p2.getDescription());
                ++conflict;
            }
            if (p1.getUnit().equalsIgnoreCase(p2.getUnit())) continue;
            String cu1 = Util.cleanUnit((String)p1.getUnit());
            String cu2 = Util.cleanUnit((String)p2.getUnit());
            boolean isUnitless1 = Grib2Parameter.isUnitless(cu1);
            if (isUnitless1 != (isUnitless2 = Grib2Parameter.isUnitless(cu2))) {
                f.format("  ud=%10s %s != %s for %s (%s)%n%n", p1.getId(), cu1, cu2, p1.getId(), p1.getName());
                ++udunits;
                continue;
            }
            if (isUnitless1) continue;
            try {
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)cu1);
                if (su1.isCompatible(cu2)) continue;
                f.format("  ud=%10s %s (%s) != %s for %s (%s)%n%n", p1.getId(), cu1, su1, cu2, p1.getId(), p1.getName());
                ++udunits;
            }
            catch (Exception e) {
                f.format("  udunits cant parse=%10s %15s %15s%n", p1.getId(), cu1, cu2);
            }
        }
        f.format("Conflicts=%d extra=%d udunits=%d%n%n", conflict, extra, udunits);
        f.format("Parameters in %s not in %s%n", name1, name2);
        int local = 0;
        for (Grib2Parameter p1 : test) {
            GribTables.Parameter p2 = reference.getParameter(p1.getDiscipline(), p1.getCategory(), p1.getNumber());
            if (p2 != null) continue;
            ++local;
            f.format("  %s%n", p1);
        }
        f.format(" missing=%d%n%n", local);
    }

    static boolean isUnitless(String unit) {
        if (unit == null) {
            return true;
        }
        String munge = unit.toLowerCase().trim();
        return (munge = StringUtil2.remove((String)munge, (int)40)).length() == 0 || munge.startsWith("numeric") || munge.startsWith("non-dim") || munge.startsWith("see") || munge.startsWith("proportion") || munge.startsWith("code") || munge.startsWith("0=") || munge.equals("1");
    }
}

