/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class EcmwfLocalConcepts {
    private static String SHORTNAME_ID = "shortName";
    private static String DESCRIPTION_ID = "description";
    private static String UNIT_ID = "units";
    private static String TABLE_VERSION_ID = "table2Version";
    private static String PARAM_NUM_ID = "indicatorOfParameter";
    private InputStream descriptionsIs = null;
    private InputStream shortNamesIs = null;
    private InputStream unitsIs = null;
    private HashMap<String, HashMap<String, HashMap<String, String>>> localConcepts = new HashMap();
    private String ecmwfLocalConceptsLoc;

    public EcmwfLocalConcepts() {
        String sep = File.separator;
        String classPath = EcmwfLocalConcepts.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String split = "thredds" + sep + "grib";
        String sourcesPath = classPath.split(split)[0];
        this.ecmwfLocalConceptsLoc = sourcesPath + "thredds" + sep + "grib" + sep + "src" + sep + "main" + sep + "sources" + sep + "ecmwfGribApi" + sep;
        try {
            this.descriptionsIs = new FileInputStream(this.ecmwfLocalConceptsLoc + "name.def");
            this.shortNamesIs = new FileInputStream(this.ecmwfLocalConceptsLoc + "shortName.def");
            this.unitsIs = new FileInputStream(this.ecmwfLocalConceptsLoc + "units.def");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void parseLocalConcepts() throws IOException {
        this.addLocalConcept(this.shortNamesIs, SHORTNAME_ID);
        this.addLocalConcept(this.descriptionsIs, DESCRIPTION_ID);
        this.addLocalConcept(this.unitsIs, UNIT_ID);
    }

    private void addLocalConcept(InputStream is, String conceptName) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (!line.startsWith("#")) {
            line = br.readLine();
        }
        while (true) {
            HashMap<String, String> items = new HashMap<String, String>();
            line = br.readLine();
            if (line == null) break;
            if (line.length() == 0 || line.startsWith("#") || !(line = this.cleanLine(line)).contains("{")) continue;
            String paramName = line.split("=")[0].trim();
            line = this.cleanLine(br.readLine());
            while (line.contains("=")) {
                String[] kvp = line.split("=");
                items.put(kvp[0].trim(), kvp[1].trim());
                line = this.cleanLine(br.readLine());
            }
            String tableVersion = (String)items.get(TABLE_VERSION_ID);
            String parameterNumber = (String)items.get(PARAM_NUM_ID);
            this.storeConcept(tableVersion, parameterNumber, conceptName, paramName);
        }
    }

    private String cleanLine(String lineIn) {
        String lineOut = "";
        lineOut = lineIn.replaceAll("'", "");
        lineOut = lineOut.replaceAll("\t", "");
        lineOut = lineOut.replaceAll(";", "");
        lineOut = lineOut.trim();
        return lineOut;
    }

    private void storeConcept(String tableVersion, String parameterNumber, String key, String value) {
        HashMap<Object, Object> tmpTable = null;
        if (this.localConcepts.containsKey(tableVersion)) {
            tmpTable = this.localConcepts.get(tableVersion);
            if (tmpTable.containsKey(parameterNumber)) {
                HashMap tmpParam = (HashMap)tmpTable.get(parameterNumber);
                if (!tmpParam.containsKey(key)) {
                    tmpParam.put(key, value);
                } else {
                    System.out.println("already has key value pair: " + key + ":" + value);
                }
            } else {
                HashMap<String, String> tmpParam = new HashMap<String, String>(4);
                tmpParam.put(key, value);
                tmpTable.put(parameterNumber, tmpParam);
            }
        } else {
            tmpTable = new HashMap();
            HashMap<String, String> tmpParam = new HashMap<String, String>(4);
            tmpParam.put(key, value);
            tmpTable.put(parameterNumber, tmpParam);
        }
        this.localConcepts.put(tableVersion, tmpTable);
    }

    private void writeGrib1Tables() throws IOException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        Calendar cal = Calendar.getInstance();
        String writeDate = dateFormat.format(cal.getTime());
        ArrayList<String> tableNums = new ArrayList<String>();
        Path dir = Paths.get(this.ecmwfLocalConceptsLoc.replace("sources/", "resources/resources/grib1/"), new String[0]);
        for (String tableNum : this.localConcepts.keySet()) {
            tableNums.add(tableNum);
            String fileName = "2.98." + tableNum + ".table";
            System.out.println("Writing: " + fileName);
            Path newFile = dir.resolve(fileName);
            Files.deleteIfExists(newFile);
            Files.createFile(newFile, new FileAttribute[0]);
            FileWriter writer = new FileWriter(newFile.toFile());
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println("# Generated by " + this.getClass().getCanonicalName() + " on " + writeDate);
            for (String paramNum : this.localConcepts.get(tableNum).keySet()) {
                HashMap<String, String> paramInfo = this.localConcepts.get(tableNum).get(paramNum);
                String shortName = paramInfo.get(SHORTNAME_ID);
                String description = paramInfo.get(DESCRIPTION_ID);
                String units = paramInfo.get(UNIT_ID);
                String grib1Info = paramNum + " " + shortName + " [" + description + "] (" + units + ")";
                printWriter.println(grib1Info);
            }
            printWriter.close();
        }
        this.writeLookupTableFile(tableNums, dir, writeDate);
    }

    private void writeLookupTableFile(List<String> tableNums, Path dir, String writeDate) throws IOException {
        Collections.sort(tableNums);
        Path lookupTableReg = dir.resolve("lookupTables.txt");
        Files.deleteIfExists(lookupTableReg);
        Files.createFile(lookupTableReg, new FileAttribute[0]);
        FileWriter writer = new FileWriter(lookupTableReg.toFile());
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("# Generated by " + this.getClass().getCanonicalName() + " on " + writeDate);
        for (String tn : tableNums) {
            String tableName = "2.98." + tn + ".table";
            String reg = "98:\t-1:\t" + tn + ":\t" + tableName;
            printWriter.println(reg);
        }
        printWriter.close();
    }

    private void showLocalConcepts() {
        for (String tableNum : this.localConcepts.keySet()) {
            for (String paramNum : this.localConcepts.get(tableNum).keySet()) {
                for (String key : this.localConcepts.get(tableNum).get(paramNum).keySet()) {
                    System.out.println(key + ":" + this.localConcepts.get(tableNum).get(paramNum).get(key));
                }
            }
        }
    }

    public static void main(String[] args) {
        EcmwfLocalConcepts ec = new EcmwfLocalConcepts();
        try {
            ec.parseLocalConcepts();
            ec.writeGrib1Tables();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

