/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Utils;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

public class Grib1Rectilyser {
    private Grib1Customizer cust;
    private final List<Grib1Record> records;
    private final int gdsHash;
    private final boolean intvMerge;
    private final boolean useTableVersion;
    private List<VariableBag> gribvars;
    private final List<TimeCoord> timeCoords = new ArrayList<TimeCoord>();
    private final List<VertCoord> vertCoords = new ArrayList<VertCoord>();
    private final List<EnsCoord> ensCoords = new ArrayList<EnsCoord>();

    public Grib1Rectilyser(Grib1Customizer cust, List<Grib1Record> records, int gdsHash, Map<String, Boolean> pdsHash) {
        this.cust = cust;
        this.records = records;
        this.gdsHash = gdsHash;
        this.intvMerge = this.assignValue(pdsHash, "intvMerge", true);
        this.useTableVersion = this.assignValue(pdsHash, "useTableVersion", true);
    }

    private boolean assignValue(Map<String, Boolean> pdsHash, String key, boolean value) {
        Boolean b;
        if (pdsHash != null && (b = pdsHash.get(key)) != null) {
            value = b;
        }
        return value;
    }

    public List<Grib1Record> getRecords() {
        return this.records;
    }

    public List<VariableBag> getGribvars() {
        return this.gribvars;
    }

    public List<TimeCoord> getTimeCoords() {
        return this.timeCoords;
    }

    public List<VertCoord> getVertCoords() {
        return this.vertCoords;
    }

    public List<EnsCoord> getEnsCoords() {
        return this.ensCoords;
    }

    public void make(Counter counter) throws IOException {
        HashMap<Integer, VariableBag> vbHash = new HashMap<Integer, VariableBag>(100);
        for (Grib1Record gr : this.records) {
            int cdmHash = this.cdmVariableHash(gr, this.gdsHash, this.intvMerge, this.useTableVersion);
            VariableBag bag = (VariableBag)vbHash.get(cdmHash);
            if (bag == null) {
                bag = new VariableBag(gr, cdmHash);
                vbHash.put(cdmHash, bag);
            }
            bag.atomList.add(new Record(gr));
        }
        this.gribvars = new ArrayList(vbHash.values());
        Collections.sort(this.gribvars);
        for (VariableBag vb : this.gribvars) {
            boolean isUniform = this.checkTimeCoordsUniform(vb);
            Grib1SectionProductDefinition pds = vb.first.getPDSsection();
            Grib1ParamTime ptime = pds.getParamTime(this.cust);
            TimeCoord use = ptime.isInterval() ? this.makeTimeCoordsIntv(vb, isUniform) : this.makeTimeCoords(vb, isUniform);
            vb.timeCoordIndex = TimeCoord.findCoord(this.timeCoords, use);
        }
        for (VariableBag vb : this.gribvars) {
            VertCoord vc = this.makeVertCoord(vb);
            if (!vc.isVertDimensionUsed()) continue;
            vb.vertCoordIndex = VertCoord.findCoord(this.vertCoords, vc);
        }
        for (VariableBag vb : this.gribvars) {
            EnsCoord ec = this.makeEnsCoord(vb);
            if (ec == null) continue;
            vb.ensCoordIndex = EnsCoord.findCoord(this.ensCoords, ec);
        }
        int tot_used = 0;
        int tot_dups = 0;
        for (VariableBag vb : this.gribvars) {
            TimeCoord tc = this.timeCoords.get(vb.timeCoordIndex);
            VertCoord vc = vb.vertCoordIndex < 0 ? null : this.vertCoords.get(vb.vertCoordIndex);
            EnsCoord ec = vb.ensCoordIndex < 0 ? null : this.ensCoords.get(vb.ensCoordIndex);
            int ntimes = tc.getSize();
            int nverts = vc == null ? 1 : vc.getSize();
            int nens = ec == null ? 1 : ec.getSize();
            vb.recordMap = new Record[ntimes * nverts * nens];
            for (Record r : vb.atomList) {
                int ensIdx;
                int vertIdx;
                int timeIdx;
                int n = timeIdx = r.tcIntvCoord != null ? tc.findInterval(r.tcIntvCoord) : tc.findIdx(r.tcCoord);
                if (timeIdx < 0) {
                    timeIdx = r.tcIntvCoord != null ? tc.findInterval(r.tcIntvCoord) : tc.findIdx(r.tcCoord);
                    throw new IllegalStateException("Cant find time coord " + r.tcCoord);
                }
                int n2 = vertIdx = vb.vertCoordIndex < 0 ? 0 : vc.findIdx(r.vcCoord);
                if (vertIdx < 0) {
                    vertIdx = vc.findIdx(r.vcCoord);
                    throw new IllegalStateException("Cant find vert coord " + r.vcCoord);
                }
                int n3 = ensIdx = vb.ensCoordIndex < 0 ? 0 : ec.findIdx(r.ecCoord);
                if (ensIdx < 0) {
                    ensIdx = ec.findIdx(r.ecCoord);
                    throw new IllegalStateException("Cant find ens coord " + r.ecCoord);
                }
                int index = GribCollection.calcIndex(timeIdx, ensIdx, vertIdx, nens, nverts);
                if (vb.recordMap[index] != null) {
                    ++tot_dups;
                } else {
                    ++tot_used;
                }
                vb.recordMap[index] = r;
            }
        }
        counter.recordsUnique += tot_used;
        counter.dups += tot_dups;
        counter.vars += this.gribvars.size();
    }

    public int cdmVariableHash(Grib1Record gr, int gdsHash) {
        return this.cdmVariableHash(gr, gdsHash, false, false);
    }

    private int cdmVariableHash(Grib1Record gr, int gdsHash, boolean intvMerge, boolean useTableVersion) {
        Grib1ParamTime ptime;
        int result = 17;
        Grib1SectionGridDefinition gdss = gr.getGDSsection();
        result = gdsHash == 0 ? (result += result * 37 + gdss.getGDS().hashCode()) : (result += result * 37 + gdsHash);
        Grib1SectionProductDefinition pdss = gr.getPDSsection();
        result += result * 37 + pdss.getLevelType();
        if (this.cust.isLayer(pdss.getLevelType())) {
            result += result * 37 + 1;
        }
        result += result * 37 + pdss.getParameterNumber();
        if (useTableVersion) {
            result += result * 37 + pdss.getTableVersion();
        }
        if ((ptime = pdss.getParamTime(this.cust)).isInterval()) {
            if (!intvMerge) {
                result += result * 37 + ptime.getIntervalSize();
            }
            if (ptime.getStatType() != null) {
                result += result * 37 + ptime.getStatType().ordinal();
            }
        }
        if (pdss.getParameterNumber() > 127) {
            result += result * 37 + pdss.getCenter();
            if (pdss.getSubCenter() > 0) {
                result += result * 37 + pdss.getSubCenter();
            }
        }
        return result;
    }

    public String getTimeIntervalName(int timeIdx) {
        TimeCoord tc = this.timeCoords.get(timeIdx);
        return tc.getTimeIntervalName();
    }

    private VertCoord makeVertCoord(VariableBag vb) {
        Grib1SectionProductDefinition pdsFirst = vb.first.getPDSsection();
        VertCoord.VertUnit vertUnit = this.cust.getVertUnit(pdsFirst.getLevelType());
        boolean isLayer = this.cust.isLayer(pdsFirst.getLevelType());
        HashSet<VertCoord.Level> coords = new HashSet<VertCoord.Level>();
        for (Record r : vb.atomList) {
            Grib1SectionProductDefinition pds = r.gr.getPDSsection();
            Grib1ParamLevel plevel = this.cust.getParamLevel(pds);
            r.vcCoord = new VertCoord.Level(plevel.getValue1(), plevel.getValue2());
            coords.add(r.vcCoord);
        }
        ArrayList<VertCoord.Level> vlist = new ArrayList<VertCoord.Level>(coords);
        Collections.sort(vlist);
        if (!vertUnit.isPositiveUp()) {
            Collections.reverse(vlist);
        }
        return new VertCoord(vlist, vertUnit, isLayer);
    }

    private EnsCoord makeEnsCoord(VariableBag vb) {
        if (!vb.first.getPDSsection().isEnsemble()) {
            return null;
        }
        HashSet<EnsCoord.Coord> coords = new HashSet<EnsCoord.Coord>();
        for (Record r : vb.atomList) {
            Grib1SectionProductDefinition pds = r.gr.getPDSsection();
            r.ecCoord = new EnsCoord.Coord(pds.getPerturbationType(), pds.getPerturbationNumber());
            coords.add(r.ecCoord);
        }
        ArrayList<EnsCoord.Coord> elist = new ArrayList<EnsCoord.Coord>(coords);
        Collections.sort(elist);
        return new EnsCoord(elist);
    }

    private CalendarPeriod convertTimeDuration(int timeUnit) {
        return GribUtils.getCalendarPeriod(this.cust.convertTimeUnit(timeUnit));
    }

    private boolean checkTimeCoordsUniform(VariableBag vb) {
        boolean isUniform = true;
        CalendarDate refDate = null;
        int timeUnit = -1;
        boolean timeUnitOk = true;
        for (Record r : vb.atomList) {
            int offset;
            CalendarDate date2;
            Grib1SectionProductDefinition pds = r.gr.getPDSsection();
            int unit = this.cust.convertTimeUnit(pds.getTimeUnit());
            if (timeUnit < 0) {
                timeUnit = unit;
                vb.timeUnit = GribUtils.getCalendarPeriod(timeUnit);
            } else if (unit != timeUnit) {
                isUniform = false;
            }
            CalendarDate cd = r.gr.getReferenceDate();
            if (refDate == null) {
                refDate = cd;
            } else if (!cd.equals((Object)refDate)) {
                isUniform = false;
                if (cd.compareTo(refDate) < 0) {
                    refDate = cd;
                }
            }
            Grib1ParamTime ptime = pds.getParamTime(this.cust);
            int time = ptime.getForecastTime();
            CalendarDate date1 = cd.add(GribUtils.getCalendarPeriod(unit).multiply(time));
            if (date1.equals((Object)(date2 = refDate.add(vb.timeUnit.multiply(offset = TimeCoord.getOffset(refDate, date1, vb.timeUnit)))))) continue;
            timeUnitOk = false;
        }
        if (!timeUnitOk) {
            timeUnit = 0;
        }
        vb.timeUnit = GribUtils.getCalendarPeriod(timeUnit);
        vb.refDate = refDate;
        return isUniform;
    }

    private TimeCoord makeTimeCoords(VariableBag vb, boolean uniform) {
        int timeType = -1;
        HashSet<Integer> times = new HashSet<Integer>();
        for (Record r : vb.atomList) {
            Grib1SectionProductDefinition pds = r.gr.getPDSsection();
            if (timeType < 0) {
                timeType = pds.getTimeRangeIndicator();
            }
            Grib1ParamTime ptime = pds.getParamTime(this.cust);
            int time = ptime.getForecastTime();
            CalendarPeriod duration = this.convertTimeDuration(pds.getTimeUnit());
            if (uniform) {
                r.tcCoord = time;
            } else {
                CalendarDate refDate = r.gr.getReferenceDate();
                CalendarDate date = refDate.add(duration.multiply(time));
                r.tcCoord = TimeCoord.getOffset(vb.refDate, date, vb.timeUnit);
            }
            times.add(r.tcCoord);
        }
        ArrayList tlist = new ArrayList(times);
        Collections.sort(tlist);
        return new TimeCoord(timeType, vb.refDate, vb.timeUnit, tlist);
    }

    private TimeCoord makeTimeCoordsIntv(VariableBag vb, boolean uniform) {
        int timeType = -1;
        HashSet<TimeCoord.Tinv> times = new HashSet<TimeCoord.Tinv>();
        for (Record r : vb.atomList) {
            Grib1SectionProductDefinition pds = r.gr.getPDSsection();
            if (timeType < 0) {
                timeType = pds.getTimeRangeIndicator();
            }
            Grib1ParamTime ptime = pds.getParamTime(this.cust);
            int[] timeb = ptime.getInterval();
            if (uniform) {
                r.tcIntvCoord = new TimeCoord.Tinv(timeb[0], timeb[1]);
                times.add(r.tcIntvCoord);
                continue;
            }
            TimeCoord.Tinv org = new TimeCoord.Tinv(timeb[0], timeb[1]);
            CalendarPeriod fromUnit = this.convertTimeDuration(pds.getTimeUnit());
            r.tcIntvCoord = org.convertReferenceDate(r.gr.getReferenceDate(), fromUnit, vb.refDate, vb.timeUnit);
            times.add(r.tcIntvCoord);
        }
        ArrayList tlist = new ArrayList(times);
        Collections.sort(tlist);
        return new TimeCoord(timeType, vb.refDate, vb.timeUnit, tlist);
    }

    public void dump(Formatter f) {
        Object coord;
        int i;
        f.format("%nTime Coordinates%n", new Object[0]);
        for (i = 0; i < this.timeCoords.size(); ++i) {
            TimeCoord time = this.timeCoords.get(i);
            f.format("  %d: (%d) %s%n", i, time.getSize(), time);
        }
        f.format("%nVert Coordinates%n", new Object[0]);
        for (i = 0; i < this.vertCoords.size(); ++i) {
            coord = this.vertCoords.get(i);
            f.format("  %d: (%d) %s%n", i, ((VertCoord)coord).getSize(), coord);
        }
        f.format("%nEns Coordinates%n", new Object[0]);
        for (i = 0; i < this.ensCoords.size(); ++i) {
            coord = this.ensCoords.get(i);
            f.format("  %d: (%d) %s%n", i, ((EnsCoord)coord).getSize(), coord);
        }
        f.format("%nVariables%n", new Object[0]);
        f.format("%n  %3s %3s %3s%n", "time", "vert", "ens");
        for (VariableBag vb : this.gribvars) {
            String vname = Grib1Utils.extractParameterCode(vb.first);
            f.format("  %3d %3d %3d %s records = %d density = %d/%d", vb.timeCoordIndex, vb.vertCoordIndex, vb.ensCoordIndex, vname, vb.atomList.size(), vb.countDensity(), vb.recordMap.length);
            if (vb.countDensity() != vb.recordMap.length) {
                f.format(" HEY!!", new Object[0]);
            }
            f.format("%n", new Object[0]);
        }
    }

    public class VariableBag
    implements Comparable<VariableBag> {
        Grib1Record first;
        int cdmHash;
        List<Record> atomList = new ArrayList<Record>(100);
        int timeCoordIndex = -1;
        int vertCoordIndex = -1;
        int ensCoordIndex = -1;
        CalendarDate refDate;
        CalendarPeriod timeUnit;
        Record[] recordMap;
        long pos;
        int length;

        private VariableBag(Grib1Record first, int cdmHash) {
            this.first = first;
            this.cdmHash = cdmHash;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib1Utils.extractParameterCode(this.first).compareTo(Grib1Utils.extractParameterCode(o.first));
        }

        int countDensity() {
            int count = 0;
            for (Record r : this.recordMap) {
                if (r == null) continue;
                ++count;
            }
            return count;
        }
    }

    public class Record {
        Grib1Record gr;
        int tcCoord;
        TimeCoord.Tinv tcIntvCoord;
        VertCoord.Level vcCoord;
        EnsCoord.Coord ecCoord;

        private Record(Grib1Record gr) {
            this.gr = gr;
        }
    }

    public static class Counter {
        int recordsUnique;
        int recordsTotal;
        int filter;
        int dups;
        int vars;

        public String show() {
            Formatter f = new Formatter();
            float dupPercent = (float)this.dups / (float)(this.recordsTotal - this.filter);
            f.format(" Rectilyser2: nvars=%d records total=%d filtered=%d unique=%d dups=%d (%f)%n", this.vars, this.recordsTotal, this.filter, this.recordsUnique, this.dups, Float.valueOf(dupPercent));
            return f.toString();
        }
    }
}

