/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.wavelet.analysis;

import ucar.jpeg.jj2000.j2k.wavelet.analysis.AnWTFilterFloat;

public class AnWTFilterFloatLift9x7
extends AnWTFilterFloat {
    private static final float[] LPSynthesisFilter = new float[]{-0.091272f, -0.057544f, 0.591272f, 1.115087f, 0.591272f, -0.057544f, -0.091272f};
    private static final float[] HPSynthesisFilter = new float[]{0.026749f, 0.016864f, -0.078223f, -0.266864f, 0.602949f, -0.266864f, -0.078223f, 0.016864f, 0.026749f};
    public static final float ALPHA = -1.5861343f;
    public static final float BETA = -0.052980117f;
    public static final float GAMMA = 0.8829111f;
    public static final float DELTA = 0.44350687f;
    public static final float KL = 0.8128931f;
    public static final float KH = 1.2301741f;

    @Override
    public void analyze_lpf(float[] inSig, int inOff, int inLen, int inStep, float[] lowSig, int lowOff, int lowStep, float[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff + inStep;
        int lk = lowOff;
        int hk = highOff;
        int maxi = inLen - 1;
        for (i = 1; i < maxi; i += 2) {
            highSig[hk] = inSig[ik] + -1.5861343f * (inSig[ik - inStep] + inSig[ik + inStep]);
            ik += iStep;
            hk += highStep;
        }
        if (inLen % 2 == 0) {
            highSig[hk] = inSig[ik] + -3.1722686f * inSig[ik - inStep];
        }
        ik = inOff;
        lk = lowOff;
        hk = highOff;
        lowSig[lk] = inLen > 1 ? inSig[ik] + -0.105960235f * highSig[hk] : inSig[ik];
        ik += iStep;
        lk += lowStep;
        hk += highStep;
        maxi = inLen - 1;
        for (i = 2; i < maxi; i += 2) {
            lowSig[lk] = inSig[ik] + -0.052980117f * (highSig[hk - highStep] + highSig[hk]);
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen > 2) {
            lowSig[lk] = inSig[ik] + -0.105960235f * highSig[hk - highStep];
        }
        lk = lowOff;
        hk = highOff;
        maxi = inLen - 1;
        for (i = 1; i < maxi; i += 2) {
            int n = hk;
            highSig[n] = highSig[n] + 0.8829111f * (lowSig[lk] + lowSig[lk + lowStep]);
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 0) {
            int n = hk;
            highSig[n] = highSig[n] + 1.7658222f * lowSig[lk];
        }
        lk = lowOff;
        hk = highOff;
        if (inLen > 1) {
            int n = lk;
            lowSig[n] = lowSig[n] + 0.88701373f * highSig[hk];
        }
        lk += lowStep;
        hk += highStep;
        maxi = inLen - 1;
        for (i = 2; i < maxi; i += 2) {
            int n = lk;
            lowSig[n] = lowSig[n] + 0.44350687f * (highSig[hk - highStep] + highSig[hk]);
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen > 2) {
            int n = lk;
            lowSig[n] = lowSig[n] + 0.88701373f * highSig[hk - highStep];
        }
        lk = lowOff;
        hk = highOff;
        for (i = 0; i < inLen >> 1; ++i) {
            int n = lk;
            lowSig[n] = lowSig[n] * 0.8128931f;
            int n2 = hk;
            highSig[n2] = highSig[n2] * 1.2301741f;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen != 1) {
            int n = lk;
            lowSig[n] = lowSig[n] * 0.8128931f;
        }
    }

    @Override
    public void analyze_hpf(float[] inSig, int inOff, int inLen, int inStep, float[] lowSig, int lowOff, int lowStep, float[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff;
        int lk = lowOff;
        int hk = highOff;
        highSig[hk] = inLen > 1 ? inSig[ik] + -3.1722686f * inSig[ik + inStep] : inSig[ik] * 2.0f;
        ik += iStep;
        hk += highStep;
        for (i = 2; i < inLen - 1; i += 2) {
            highSig[hk] = inSig[ik] + -1.5861343f * (inSig[ik - inStep] + inSig[ik + inStep]);
            ik += iStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen > 1) {
            highSig[hk] = inSig[ik] + -3.1722686f * inSig[ik - inStep];
        }
        ik = inOff + inStep;
        lk = lowOff;
        hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            lowSig[lk] = inSig[ik] + -0.052980117f * (highSig[hk] + highSig[hk + highStep]);
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen > 1 && inLen % 2 == 0) {
            lowSig[lk] = inSig[ik] + -0.105960235f * highSig[hk];
        }
        lk = lowOff;
        hk = highOff;
        if (inLen > 1) {
            int n = hk;
            highSig[n] = highSig[n] + 1.7658222f * lowSig[lk];
        }
        hk += highStep;
        for (i = 2; i < inLen - 1; i += 2) {
            int n = hk;
            highSig[n] = highSig[n] + 0.8829111f * (lowSig[lk] + lowSig[lk + lowStep]);
            lk += lowStep;
            hk += highStep;
        }
        if (inLen > 1 && inLen % 2 == 1) {
            int n = hk;
            highSig[n] = highSig[n] + 1.7658222f * lowSig[lk];
        }
        lk = lowOff;
        hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            int n = lk;
            lowSig[n] = lowSig[n] + 0.44350687f * (highSig[hk] + highSig[hk + highStep]);
            lk += lowStep;
            hk += highStep;
        }
        if (inLen > 1 && inLen % 2 == 0) {
            int n = lk;
            lowSig[n] = lowSig[n] + 0.88701373f * highSig[hk];
        }
        lk = lowOff;
        hk = highOff;
        for (i = 0; i < inLen >> 1; ++i) {
            int n = lk;
            lowSig[n] = lowSig[n] * 0.8128931f;
            int n2 = hk;
            highSig[n2] = highSig[n2] * 1.2301741f;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen != 1) {
            int n = hk;
            highSig[n] = highSig[n] * 1.2301741f;
        }
    }

    @Override
    public int getAnLowNegSupport() {
        return 4;
    }

    @Override
    public int getAnLowPosSupport() {
        return 4;
    }

    @Override
    public int getAnHighNegSupport() {
        return 3;
    }

    @Override
    public int getAnHighPosSupport() {
        return 3;
    }

    @Override
    public int getSynLowNegSupport() {
        return 3;
    }

    @Override
    public int getSynLowPosSupport() {
        return 3;
    }

    @Override
    public int getSynHighNegSupport() {
        return 4;
    }

    @Override
    public int getSynHighPosSupport() {
        return 4;
    }

    @Override
    public float[] getLPSynthesisFilter() {
        return LPSynthesisFilter;
    }

    @Override
    public float[] getHPSynthesisFilter() {
        return HPSynthesisFilter;
    }

    @Override
    public int getImplType() {
        return 1;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public boolean isSameAsFullWT(int tailOvrlp, int headOvrlp, int inLen) {
        if (inLen % 2 == 0) {
            return tailOvrlp >= 4 && headOvrlp >= 3;
        }
        return tailOvrlp >= 4 && headOvrlp >= 4;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AnWTFilterFloatLift9x7;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    public String toString() {
        return "w9x7";
    }
}

