/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.decoder;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import ucar.jpeg.jj2000.j2k.decoder.Decoder;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;
import ucar.jpeg.jj2000.j2k.util.ParameterList;
import ucar.jpeg.jj2000.j2k.util.StringFormatException;

public class CmdLnDecoder {
    private ParameterList pl;
    private ParameterList defpl = new ParameterList();
    private Decoder dec;

    public static void main(String[] argv) {
        if (argv.length == 0) {
            FacilityManager.getMsgLogger().println("CmdLnDecoder: JJ2000's JPEG 2000 Decoder\n    use jj2000.j2k.decoder.CmdLnDecoder -u to get help\n", 0, 0);
            System.exit(1);
        }
        new CmdLnDecoder(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmdLnDecoder(String[] argv) {
        String[][] param = Decoder.getAllParameters();
        for (int i = param.length - 1; i >= 0; --i) {
            if (param[i][3] == null) continue;
            this.defpl.put(param[i][0], param[i][3]);
        }
        this.pl = new ParameterList(this.defpl);
        if (argv.length == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        try {
            this.pl.parseArgs(argv);
        }
        catch (StringFormatException e) {
            System.err.println("An error occured while parsing the arguments:\n" + e.getMessage());
            return;
        }
        if (this.pl.getParameter("pfile") != null) {
            InputStream is;
            try {
                is = new FileInputStream(this.pl.getParameter("pfile"));
                is = new BufferedInputStream(is);
                this.pl.load(is);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not load the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            catch (IOException e) {
                System.err.println("An error ocurred while reading from the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                System.out.println("[WARNING]: Could not close the argument file after reading");
            }
            try {
                this.pl.parseArgs(argv);
            }
            catch (StringFormatException e) {
                System.err.println("An error occured while re-parsing the arguments:\n" + e.getMessage());
                return;
            }
        }
        this.dec = new Decoder(this.pl);
        if (this.dec.getExitCode() != 0) {
            System.exit(this.dec.getExitCode());
        }
        try {
            this.dec.run(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (this.dec.getExitCode() != 0) {
                System.exit(this.dec.getExitCode());
            }
        }
    }
}

