/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribNumbers;

public class Grib2GDSVariables
implements GribGDSVariablesIF {
    private static Logger log = LoggerFactory.getLogger(Grib2GDSVariables.class);
    private final byte[] input;
    private final int gdtn;
    private final int gdsKey;

    public Grib2GDSVariables(byte[] input) throws IOException {
        this.input = input;
        this.gdtn = GribNumbers.int2(this.getInt(12), this.getInt(13));
        double checkSum = this.gdtn;
        checkSum = 7.0 * checkSum + (double)this.get80La1();
        checkSum = 7.0 * checkSum + (double)this.get80Lo1();
        this.gdsKey = Double.toString(checkSum).hashCode();
    }

    @Override
    public byte[] getGDSBytes() {
        return this.input;
    }

    public long calcCRC() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.input);
        return crc32.getValue();
    }

    @Override
    public final int getLength() {
        return GribNumbers.int4(this.getInt(0), this.getInt(1), this.getInt(2), this.getInt(3));
    }

    @Override
    public final int getSection() {
        return this.getInt(4);
    }

    @Override
    public final int getSource() {
        return this.getInt(5);
    }

    @Override
    public final int getNumberPoints() {
        return GribNumbers.int4(this.getInt(6), this.getInt(7), this.getInt(8), this.getInt(9));
    }

    @Override
    public final int getOlon() {
        return this.getInt(10);
    }

    @Override
    public final int getIolon() {
        return this.getInt(11);
    }

    @Override
    public final int getGdtn() {
        return this.gdtn;
    }

    @Override
    public final int getShape() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return this.getInt(14);
            }
        }
        return -9999;
    }

    public final int getScaleFactorRadius() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return this.getInt(15);
            }
        }
        return -9999;
    }

    public final int getScaleValueRadius() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return GribNumbers.int4(this.getInt(16), this.getInt(17), this.getInt(18), this.getInt(19));
            }
        }
        return -9999;
    }

    public final int getScaleFactorMajor() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return this.getInt(20);
            }
        }
        return -9999;
    }

    public final int getScaleValueMajor() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return GribNumbers.int4(this.getInt(21), this.getInt(22), this.getInt(23), this.getInt(24));
            }
        }
        return -9999;
    }

    public final int getScaleFactorMinor() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return this.getInt(25);
            }
        }
        return -9999;
    }

    public final int getScaleValueMinor() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                return GribNumbers.int4(this.getInt(26), this.getInt(27), this.getInt(28), this.getInt(29));
            }
        }
        return -9999;
    }

    @Override
    public final int getNx() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 32768: {
                int nx = GribNumbers.int4(this.getInt(30), this.getInt(31), this.getInt(32), this.getInt(33));
                if (nx == -1 || nx == -9999) {
                    return this.calculateNx();
                }
                return nx;
            }
        }
        return -9999;
    }

    @Override
    public final int getNy() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 32768: {
                return GribNumbers.int4(this.getInt(34), this.getInt(35), this.getInt(36), this.getInt(37));
            }
        }
        return -9999;
    }

    @Override
    public final float getLap() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41));
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getLop() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45));
            }
        }
        return -9999.0f;
    }

    public final int getBasicAngle() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 204: 
            case 32768: {
                return GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41));
            }
            case 1000: 
            case 1100: {
                return GribNumbers.int4(this.getInt(34), this.getInt(35), this.getInt(36), this.getInt(37));
            }
        }
        return -9999;
    }

    @Override
    public final int getSubDivisions() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 204: 
            case 32768: {
                return GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45));
            }
            case 1000: 
            case 1100: {
                return GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41));
            }
        }
        return -9999;
    }

    @Override
    public final float getLa1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(46), this.getInt(47), this.getInt(48), this.getInt(49)) / this.getRatio();
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 110: {
                return (float)GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41)) / 1000000.0f;
            }
            case 120: {
                return (float)GribNumbers.int4(this.getInt(22), this.getInt(23), this.getInt(24), this.getInt(25)) / 1000000.0f;
            }
            case 1000: 
            case 1100: {
                return (float)GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45)) / this.getRatio();
            }
        }
        return -9999.0f;
    }

    public final int getUnscaledLa1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return GribNumbers.int4(this.getInt(46), this.getInt(47), this.getInt(48), this.getInt(49));
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 110: {
                return GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41));
            }
            case 120: {
                return GribNumbers.int4(this.getInt(22), this.getInt(23), this.getInt(24), this.getInt(25));
            }
            case 1000: 
            case 1100: {
                return GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45));
            }
        }
        return -9999;
    }

    public final float get80La1() {
        float ratio = this.getBasicAngle() == 0 || this.getBasicAngle() == -9999 ? 1.0E-6f : (float)(this.getBasicAngle() / this.getSubDivisions());
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(46), this.getInt(47), this.getInt(48), this.getInt(49)) * ratio;
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 110: {
                return (float)GribNumbers.int4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41)) * 1.0E-6f;
            }
            case 120: {
                return (float)GribNumbers.int4(this.getInt(22), this.getInt(23), this.getInt(24), this.getInt(25)) * 1.0E-6f;
            }
            case 1000: 
            case 1100: {
                return (float)GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45)) * ratio;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getLo1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(50), this.getInt(51), this.getInt(52), this.getInt(53)) / this.getRatio();
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 110: {
                return (float)GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45)) / 1000000.0f;
            }
            case 120: {
                return (float)GribNumbers.int4(this.getInt(26), this.getInt(27), this.getInt(28), this.getInt(29)) / 1000000.0f;
            }
            case 1000: 
            case 1100: {
                return (float)GribNumbers.int4(this.getInt(46), this.getInt(47), this.getInt(48), this.getInt(49)) / this.getRatio();
            }
        }
        return -9999.0f;
    }

    public final int getUnscaledLo1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return GribNumbers.int4(this.getInt(50), this.getInt(51), this.getInt(52), this.getInt(53));
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 110: {
                return GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45));
            }
            case 120: {
                return GribNumbers.int4(this.getInt(26), this.getInt(27), this.getInt(28), this.getInt(29));
            }
            case 1000: 
            case 1100: {
                return GribNumbers.int4(this.getInt(46), this.getInt(47), this.getInt(48), this.getInt(49));
            }
        }
        return -9999;
    }

    public final float get80Lo1() {
        float ratio = this.getBasicAngle() == 0 || this.getBasicAngle() == -9999 ? 1.0E-6f : (float)(this.getBasicAngle() / this.getSubDivisions());
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(50), this.getInt(51), this.getInt(52), this.getInt(53)) * ratio;
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 110: {
                return (float)GribNumbers.int4(this.getInt(42), this.getInt(43), this.getInt(44), this.getInt(45)) * 1.0E-6f;
            }
            case 120: {
                return (float)GribNumbers.int4(this.getInt(26), this.getInt(27), this.getInt(28), this.getInt(29)) * 1.0E-6f;
            }
            case 1000: 
            case 1100: {
                return (float)GribNumbers.int4(this.getInt(46), this.getInt(47), this.getInt(48), this.getInt(49)) * ratio;
            }
        }
        return -9999.0f;
    }

    @Override
    public final int getResolution() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 204: 
            case 32768: {
                return this.getInt(54);
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 90: 
            case 110: {
                return this.getInt(46);
            }
        }
        return -9999;
    }

    @Override
    public final float getLaD() {
        switch (this.gdtn) {
            case 10: 
            case 20: 
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(47), this.getInt(48), this.getInt(49), this.getInt(50)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getLoV() {
        switch (this.gdtn) {
            case 20: 
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(51), this.getInt(52), this.getInt(53), this.getInt(54)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getLa2() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(55), this.getInt(56), this.getInt(57), this.getInt(58)) / this.getRatio();
            }
            case 10: {
                return (float)GribNumbers.int4(this.getInt(51), this.getInt(52), this.getInt(53), this.getInt(54)) / 1000000.0f;
            }
            case 1000: 
            case 1100: {
                return (float)GribNumbers.int4(this.getInt(51), this.getInt(52), this.getInt(53), this.getInt(54)) / this.getRatio();
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getLo2() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(59), this.getInt(60), this.getInt(61), this.getInt(62)) / this.getRatio();
            }
            case 10: {
                return (float)GribNumbers.int4(this.getInt(55), this.getInt(56), this.getInt(57), this.getInt(58)) / 1000000.0f;
            }
            case 1000: 
            case 1100: {
                return (float)GribNumbers.int4(this.getInt(55), this.getInt(56), this.getInt(57), this.getInt(58)) / this.getRatio();
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getDx() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(63), this.getInt(64), this.getInt(65), this.getInt(66)) / this.getRatio();
            }
            case 10: {
                return (float)GribNumbers.int4(this.getInt(64), this.getInt(65), this.getInt(66), this.getInt(67)) / 1000.0f;
            }
            case 20: 
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(55), this.getInt(56), this.getInt(57), this.getInt(58)) / 1000.0f;
            }
            case 90: {
                return GribNumbers.int4(this.getInt(47), this.getInt(48), this.getInt(49), this.getInt(50));
            }
            case 110: {
                return (float)GribNumbers.int4(this.getInt(47), this.getInt(48), this.getInt(49), this.getInt(50)) / 1000.0f;
            }
            case 120: {
                return GribNumbers.int4(this.getInt(47), this.getInt(48), this.getInt(49), this.getInt(50));
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getDy() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 32768: {
                return (float)GribNumbers.int4(this.getInt(67), this.getInt(68), this.getInt(69), this.getInt(70)) / this.getRatio();
            }
            case 10: {
                return (float)GribNumbers.int4(this.getInt(68), this.getInt(69), this.getInt(70), this.getInt(71)) / 1000.0f;
            }
            case 20: 
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(59), this.getInt(60), this.getInt(61), this.getInt(62)) / 1000.0f;
            }
            case 90: {
                return GribNumbers.int4(this.getInt(51), this.getInt(52), this.getInt(53), this.getInt(54));
            }
            case 110: {
                return (float)GribNumbers.int4(this.getInt(51), this.getInt(52), this.getInt(53), this.getInt(54)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getXp() {
        switch (this.gdtn) {
            case 90: {
                return (float)GribNumbers.int4(this.getInt(55), this.getInt(56), this.getInt(57), this.getInt(58)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getYp() {
        switch (this.gdtn) {
            case 90: {
                return (float)GribNumbers.int4(this.getInt(59), this.getInt(60), this.getInt(61), this.getInt(62)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final int getNp() {
        switch (this.gdtn) {
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return GribNumbers.int4(this.getInt(67), this.getInt(68), this.getInt(69), this.getInt(70));
            }
        }
        return -9999;
    }

    public final int getN() {
        switch (this.gdtn) {
            case 1000: {
                return GribNumbers.int2(this.getInt(60), this.getInt(61));
            }
            case 1100: {
                return GribNumbers.int4(this.getInt(60), this.getInt(61), this.getInt(62), this.getInt(63));
            }
        }
        return -9999;
    }

    @Override
    public final int getProjectionFlag() {
        switch (this.gdtn) {
            case 20: 
            case 30: 
            case 31: {
                return this.getInt(63);
            }
            case 110: {
                return this.getInt(55);
            }
        }
        return -9999;
    }

    @Override
    public final int getScanMode() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 204: 
            case 32768: {
                return this.getInt(71);
            }
            case 10: {
                return this.getInt(59);
            }
            case 20: 
            case 30: 
            case 31: {
                return this.getInt(64);
            }
            case 90: {
                return this.getInt(63);
            }
            case 100: {
                return this.getInt(33);
            }
            case 110: {
                return this.getInt(56);
            }
            case 120: {
                return this.getInt(38);
            }
            case 1000: 
            case 1100: {
                return this.getInt(50);
            }
        }
        return -9999;
    }

    @Override
    public final float getLatin1() {
        switch (this.gdtn) {
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(65), this.getInt(66), this.getInt(67), this.getInt(68)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getLatin2() {
        switch (this.gdtn) {
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(69), this.getInt(70), this.getInt(71), this.getInt(72)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final int getAngle() {
        switch (this.gdtn) {
            case 10: {
                return GribNumbers.int4(this.getInt(60), this.getInt(61), this.getInt(62), this.getInt(63));
            }
            case 90: {
                return GribNumbers.int4(this.getInt(64), this.getInt(65), this.getInt(66), this.getInt(67));
            }
        }
        return -9999;
    }

    @Override
    public final float getNr() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int4(this.getInt(68), this.getInt(69), this.getInt(70), this.getInt(71));
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getXo() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int4(this.getInt(72), this.getInt(73), this.getInt(74), this.getInt(75));
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getYo() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int4(this.getInt(76), this.getInt(77), this.getInt(78), this.getInt(79));
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getSpLat() {
        switch (this.gdtn) {
            case 1: 
            case 2: 
            case 3: 
            case 41: 
            case 43: {
                return (float)GribNumbers.int4(this.getInt(72), this.getInt(73), this.getInt(74), this.getInt(75)) / this.getRatio();
            }
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(73), this.getInt(74), this.getInt(75), this.getInt(76)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getSpLon() {
        switch (this.gdtn) {
            case 1: 
            case 2: 
            case 3: 
            case 41: 
            case 43: {
                return (float)GribNumbers.int4(this.getInt(76), this.getInt(77), this.getInt(78), this.getInt(79)) / this.getRatio();
            }
            case 30: 
            case 31: {
                return (float)GribNumbers.int4(this.getInt(77), this.getInt(78), this.getInt(79), this.getInt(80)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getRotationAngle() {
        switch (this.gdtn) {
            case 1: 
            case 2: 
            case 3: 
            case 41: 
            case 43: {
                return GribNumbers.float4(this.getInt(80), this.getInt(81), this.getInt(82), this.getInt(83));
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getPoleLat() {
        switch (this.gdtn) {
            case 3: 
            case 43: {
                return (float)GribNumbers.int4(this.getInt(84), this.getInt(85), this.getInt(86), this.getInt(87)) / this.getRatio();
            }
            case 42: {
                return (float)GribNumbers.int4(this.getInt(72), this.getInt(73), this.getInt(74), this.getInt(75)) / this.getRatio();
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getPoleLon() {
        switch (this.gdtn) {
            case 3: 
            case 43: {
                return (float)GribNumbers.int4(this.getInt(88), this.getInt(89), this.getInt(90), this.getInt(91)) / this.getRatio();
            }
            case 42: {
                return (float)GribNumbers.int4(this.getInt(76), this.getInt(77), this.getInt(78), this.getInt(79)) / this.getRatio();
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getStretchingFactor() {
        switch (this.gdtn) {
            case 3: 
            case 43: {
                return (float)GribNumbers.int4(this.getInt(92), this.getInt(93), this.getInt(94), this.getInt(95)) / 1000000.0f;
            }
            case 42: {
                return (float)GribNumbers.int4(this.getInt(80), this.getInt(81), this.getInt(82), this.getInt(83)) / 1000000.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getMajorAxis() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                if (this.getShape() == 2) {
                    return 6378160.0f;
                }
                if (this.getShape() == 3) {
                    float majorAxis = this.getScaleValueMajor();
                    majorAxis = (float)((double)majorAxis / Math.pow(10.0, this.getScaleFactorMajor()));
                    return majorAxis * 1000.0f;
                }
                if (this.getShape() == 4) {
                    return 6378137.0f;
                }
                if (this.getShape() == 5) {
                    return 6378137.0f;
                }
                if (this.getShape() == 7) {
                    float majorAxis = this.getScaleValueMajor();
                    majorAxis = (float)((double)majorAxis / Math.pow(10.0, this.getScaleFactorMajor()));
                    return majorAxis;
                }
                return -9999.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getMinorAxis() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                if (this.getShape() == 2) {
                    return 6356775.0f;
                }
                if (this.getShape() == 3) {
                    float minorAxis = this.getScaleValueMinor();
                    minorAxis = (float)((double)minorAxis / Math.pow(10.0, this.getScaleFactorMinor()));
                    return minorAxis * 1000.0f;
                }
                if (this.getShape() == 4) {
                    return 6356752.5f;
                }
                if (this.getShape() == 5) {
                    return 6356752.5f;
                }
                if (this.getShape() == 7) {
                    float minorAxis = this.getScaleValueMinor();
                    minorAxis = (float)((double)minorAxis / Math.pow(10.0, this.getScaleFactorMinor()));
                    return minorAxis;
                }
                return -9999.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final float getEarthRadius() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 90: 
            case 110: 
            case 204: 
            case 1000: 
            case 1100: 
            case 32768: {
                if (this.getShape() == 0) {
                    return 6367470.0f;
                }
                if (this.getShape() == 1) {
                    float earthRadius = this.getScaleValueRadius();
                    if (this.getScaleFactorRadius() != 0) {
                        earthRadius = (float)((double)earthRadius / Math.pow(10.0, this.getScaleFactorRadius()));
                    }
                    return earthRadius;
                }
                if (this.getShape() == 6) {
                    return 6371229.0f;
                }
                if (this.getShape() == 8) {
                    return 6371200.0f;
                }
                return -9999.0f;
            }
        }
        return -9999.0f;
    }

    @Override
    public final String getGridUnits() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return "degrees";
            }
            case 10: 
            case 20: 
            case 30: 
            case 31: {
                return "m";
            }
        }
        return "";
    }

    public final int calculateNx() {
        int maxPts;
        block10: {
            int olon;
            int[] parallels;
            int offset;
            int numPts;
            block9: {
                numPts = (this.getScanMode() & 0x20) == 0 ? this.getNy() : this.getNx();
                log.debug("GDS  numPts = " + numPts);
                switch (this.gdtn) {
                    case 0: 
                    case 10: 
                    case 40: {
                        offset = 72;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 41: 
                    case 42: {
                        offset = 84;
                        break;
                    }
                    case 3: 
                    case 43: {
                        offset = 96;
                        break;
                    }
                    default: {
                        offset = -1;
                    }
                }
                maxPts = 0;
                parallels = new int[numPts];
                olon = this.getOlon();
                if (olon != 1) break block9;
                for (int i = 0; i < numPts; ++i) {
                    parallels[i] = this.getInt(offset++);
                    if (maxPts < parallels[i]) {
                        maxPts = parallels[i];
                    }
                    log.debug("parallel =" + i + " number pts =" + parallels[i]);
                }
                break block10;
            }
            if (olon != 2) break block10;
            for (int i = 0; i < numPts; ++i) {
                parallels[i] = GribNumbers.int2(this.getInt(offset++), this.getInt(offset++));
                if (maxPts < parallels[i]) {
                    maxPts = parallels[i];
                }
                log.debug("parallel =" + i + " number pts =" + parallels[i]);
            }
        }
        return maxPts;
    }

    public final int[] getParallels() {
        int[] parallels;
        block8: {
            int olon;
            int offset;
            int numPts;
            block7: {
                numPts = (this.getScanMode() & 0x20) == 0 ? this.getNy() : this.getNx();
                log.debug("GDS  numPts = " + numPts);
                switch (this.gdtn) {
                    case 0: 
                    case 10: 
                    case 40: {
                        offset = 72;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 41: 
                    case 42: {
                        offset = 84;
                        break;
                    }
                    case 3: 
                    case 43: {
                        offset = 96;
                        break;
                    }
                    default: {
                        offset = -1;
                    }
                }
                parallels = new int[numPts];
                olon = this.getOlon();
                if (olon != 1) break block7;
                for (int i = 0; i < numPts; ++i) {
                    parallels[i] = this.getInt(offset++);
                    log.debug("parallel =" + i + " number pts =" + parallels[i]);
                }
                break block8;
            }
            if (olon != 2) break block8;
            for (int i = 0; i < numPts; ++i) {
                parallels[i] = GribNumbers.int2(this.getInt(offset++), this.getInt(offset++));
                log.debug("parallel =" + i + " number pts =" + parallels[i]);
            }
        }
        return parallels;
    }

    private float getRatio() {
        float ba = this.getBasicAngle();
        if (ba == 0.0f || ba == -9999.0f) {
            return 1000000.0f;
        }
        return ba / (float)this.getSubDivisions();
    }

    @Override
    public final int getGdsKey() {
        return this.gdsKey;
    }

    public final int get80TypeGdsKey() {
        double checkSum = this.gdtn;
        checkSum = 7.0 * checkSum + (double)this.get80La1();
        checkSum = 7.0 * checkSum + (double)this.get80Lo1();
        return Double.toString(checkSum).hashCode();
    }

    public final int getInt(int index) {
        return this.input[index] & 0xFF;
    }
}

