/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Tables;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.grib.GribEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.unidata.io.RandomAccessFile;

public class GribVariable
extends GridVariable {
    private static Logger log = LoggerFactory.getLogger(GribVariable.class);
    private static boolean compareData = false;
    private static boolean warnOk = true;
    private static boolean sendAll = false;

    GribVariable(String filename, String name, GridHorizCoordSys hcs, GridTableLookup lookup) {
        super(filename, name, hcs, lookup);
    }

    protected boolean isEnsemble() {
        if (this.firstRecord instanceof GribGridRecord) {
            GribGridRecord ggr = (GribGridRecord)this.firstRecord;
            return ggr.getPds().isEnsemble();
        }
        return false;
    }

    protected boolean trackRecords(int time, int level, GridRecord p, RandomAccessFile raf, boolean oneSent) {
        boolean sentMessage = false;
        int recno = this.calcRecno(time, level, p, raf.getLocation());
        GribGridRecord ggp = (GribGridRecord)p;
        if (ggp.getBelongs() != null) {
            log.warn("GribGridRecord " + ggp.cdmVariableName(this.lookup, true, true) + " recno = " + recno + " already belongs to = " + ggp.getBelongs());
        }
        ggp.setBelongs(new Belongs(recno, this));
        if (this.recordTracker[recno] != null) {
            GribGridRecord ggq = (GribGridRecord)this.recordTracker[recno];
            if (compareData && !this.compareData(ggq, ggp, raf)) {
                log.warn("GridVariable " + this.vname + " recno = " + recno + " already has in slot = " + ggq.toString() + " with different data for " + raf.getLocation());
                sentMessage = true;
            }
        }
        if (this.recordTracker[recno] == null) {
            this.recordTracker[recno] = p;
            if (log.isDebugEnabled()) {
                log.debug(" " + this.vc.getVariableName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2());
            }
        } else {
            if (!sentMessage && warnOk && !oneSent) {
                GribGridRecord qp = (GribGridRecord)this.recordTracker[recno];
                log.warn("Duplicate record for " + raf.getLocation() + "\n " + ggp.toString() + "\n " + qp.toString());
            }
            if (!sendAll) {
                oneSent = true;
            }
            this.recordTracker[recno] = p;
        }
        return oneSent;
    }

    private int calcRecno(int time, int level, GridRecord p, String filename) {
        int recno = time * this.nlevels + level;
        if (this.ecs != null) {
            GribEnsembleCoord ecsb = (GribEnsembleCoord)this.ecs;
            GribGridRecord ggr = (GribGridRecord)p;
            int ens = ecsb.getIndex(ggr);
            if (ens < 0) {
                int ensNumber = ggr.getPds().getPerturbationNumber();
                int ensType = ggr.getPds().getPerturbationType();
                log.warn("ENS NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + filename + "\n ensNumber= " + ensNumber + " ensType= " + ensType + "\n");
                ecsb.getIndex(ggr);
                return recno;
            }
            recno = ens * (this.ntimes * this.nlevels) + time * this.nlevels + level;
            if (recno < 0) {
                System.out.println("HEY bad recno");
                ecsb.getIndex(ggr);
            }
        }
        return recno;
    }

    private boolean compareData(GribGridRecord ggr1, GribGridRecord ggr2, RandomAccessFile raf) {
        if (raf == null) {
            return false;
        }
        float[] data1 = null;
        float[] data2 = null;
        try {
            if (ggr1.getEdition() == 2) {
                Grib2Data g2read = new Grib2Data(raf);
                data1 = g2read.getData(ggr1.getGdsOffset(), ggr1.getPdsOffset(), ggr1.getReferenceTimeInMsecs());
                data2 = g2read.getData(ggr2.getGdsOffset(), ggr2.getPdsOffset(), ggr2.getReferenceTimeInMsecs());
            } else {
                Grib1Data g1read = new Grib1Data(raf);
                data1 = g1read.getData(ggr1.getGdsOffset(), ggr1.getPdsOffset(), ggr1.getDecimalScale(), ggr1.isBmsExists());
                data2 = g1read.getData(ggr2.getGdsOffset(), ggr2.getPdsOffset(), ggr2.getDecimalScale(), ggr2.isBmsExists());
            }
        }
        catch (IOException e) {
            log.error("Failed to read data", (Throwable)e);
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i] || Double.isNaN(data1[i]) || Double.isNaN(data2[i])) continue;
            return false;
        }
        return true;
    }

    protected void addExtraAttributes(GridParameter param, Variable v) {
        CF.CellMethods cm;
        GribGridRecord ggr;
        super.addExtraAttributes(param, v);
        if (this.firstRecord instanceof GribGridRecord && (ggr = (GribGridRecord)this.firstRecord).isInterval() && (cm = CF.CellMethods.convertGribCodeTable4_10((int)ggr.getStatisticalProcessType())) != null) {
            v.addAttribute(new Attribute("cell_methods", this.tcs.getName() + ": " + cm.toString()));
        }
        if (this.lookup instanceof Grib2GridTableLookup) {
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)this.lookup;
            GribGridRecord ggr2 = (GribGridRecord)this.firstRecord;
            Grib2Pds pds2 = (Grib2Pds)ggr2.getPds();
            int[] paramId = g2lookup.getParameterId(this.firstRecord);
            v.addAttribute(new Attribute("GRIB_param_discipline", this.lookup.getDisciplineName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_category", this.lookup.getCategoryName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_name", param.getName()));
            v.addAttribute(new Attribute("GRIB_generating_process_type", g2lookup.getGenProcessTypeName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_id", Array.factory(Integer.TYPE, (int[])new int[]{paramId.length}, (Object)paramId)));
            v.addAttribute(new Attribute("GRIB_product_definition_template", (Number)pds2.getProductDefinitionTemplate()));
            v.addAttribute(new Attribute("GRIB_product_definition_template_desc", Grib2Tables.codeTable4_0(pds2.getProductDefinitionTemplate())));
            v.addAttribute(new Attribute("GRIB_level_type", (Number)new Integer(pds2.getLevelType1())));
            v.addAttribute(new Attribute("GRIB_level_type_name", this.lookup.getLevelName(this.firstRecord)));
            if (pds2.isInterval()) {
                v.addAttribute(new Attribute("GRIB_interval_stat_type", ggr2.getStatisticalProcessTypeName()));
            }
            if (pds2.isEnsembleDerived()) {
                Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
                v.addAttribute(new Attribute("GRIB_ensemble_derived_type", (Number)new Integer(pdsDerived.getDerivedForecastType())));
            }
            if (pds2.isEnsemble()) {
                v.addAttribute(new Attribute("GRIB_ensemble", "true"));
            }
            if (pds2.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
                v.addAttribute(new Attribute("GRIB_probability_type", (Number)new Integer(pdsProb.getProbabilityType())));
                v.addAttribute(new Attribute("GRIB_probability_lower_limit", (Number)new Double(pdsProb.getProbabilityLowerLimit())));
                v.addAttribute(new Attribute("GRIB_probability_upper_limit", (Number)new Double(pdsProb.getProbabilityUpperLimit())));
            }
        } else if (this.lookup instanceof Grib1GridTableLookup) {
            ggr = (GribGridRecord)this.firstRecord;
            v.addAttribute(new Attribute("GRIB_param_name", param.getDescription()));
            if (param.getName() != null) {
                v.addAttribute(new Attribute("GRIB_param_short_name", param.getName()));
            }
            v.addAttribute(new Attribute("GRIB_center_id", (Number)ggr.getCenter()));
            v.addAttribute(new Attribute("GRIB_table_version", (Number)ggr.getTableVersion()));
            v.addAttribute(new Attribute("GRIB_param_number", (Number)ggr.getParameterNumber()));
            v.addAttribute(new Attribute("GRIB_level_type", (Number)this.firstRecord.getLevelType1()));
            v.addAttribute(new Attribute("GRIB_time_range_indicator", Grib1Tables.getTimeRangeIndicatorName(ggr.getTimeUnit())));
        }
    }

    protected String makeLongName() {
        String levelName;
        Formatter f = new Formatter();
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        f.format("%s", param.getDescription());
        if (this.firstRecord instanceof GribGridRecord) {
            String intervalName;
            String suffixName;
            Grib2Pds pds2;
            String useGenType;
            GribGridRecord ggr = (GribGridRecord)this.firstRecord;
            if (ggr.getEdition() == 2 && (useGenType = (pds2 = (Grib2Pds)ggr.getPds()).getUseGenProcessType()) != null) {
                f.format("_%s", useGenType);
            }
            if ((suffixName = ggr.makeSuffix()) != null && suffixName.length() != 0) {
                f.format("%s", suffixName);
            }
            if (ggr.isInterval() && (intervalName = this.makeIntervalName()).length() != 0) {
                String stat = ggr.getStatisticalProcessTypeNameShort();
                if (stat != null) {
                    f.format(" (%s for %s)", ggr.getStatisticalProcessTypeName(), intervalName);
                } else {
                    f.format(" (%s)", intervalName);
                }
            }
        }
        if ((levelName = this.makeLevelName(this.firstRecord, this.lookup)).length() != 0) {
            f.format(" @ %s", levelName);
        }
        return f.toString();
    }

    public String makeLevelName(GridRecord gr, GridTableLookup lookup) {
        if (lookup instanceof Grib2GridTableLookup) {
            String vname = lookup.getLevelName(gr);
            return lookup.isLayer(gr) ? vname + "_layer" : vname;
        }
        return super.makeLevelName(gr, lookup);
    }

    public class Belongs {
        public int recnum;
        public GridVariable gv;

        private Belongs(int recnum, GridVariable gv) {
            this.recnum = recnum;
            this.gv = gv;
        }

        public String toString() {
            return "Belongs{recnum=" + this.recnum + ", gv=" + this.gv.vname + '}';
        }
    }
}

