/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.grib2.Grib2EndSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2LocalUseSection;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2ExtractRawData {
    private RandomAccessFile raf = null;
    private String header = "GRIB";
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");

    public Grib2ExtractRawData(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final boolean scan(int discipline, int category, int number, int forecast, long gOffset, long pOffset) throws IOException {
        Grib2IndicatorSection is = null;
        Grib2IdentificationSection id = null;
        Grib2LocalUseSection lus = null;
        Grib2GridDefinitionSection gds = null;
        if (this.raf.getFilePointer() > 4L) {
            this.raf.seek(this.raf.getFilePointer() - 4L);
            Grib2EndSection es = new Grib2EndSection(this.raf);
            if (!es.getEndFound()) {
                return false;
            }
        }
        long EOR = 0L;
        long SOR = 0L;
        long gdsOffset = 0L;
        long pdsOffset = 0L;
        boolean startAtHeader = true;
        boolean processGDS = true;
        Grib2ProductDefinitionSection pds = null;
        int count = -1;
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.raf.getLocation() + ".extract"));
        while (this.raf.getFilePointer() < this.raf.length()) {
            if (startAtHeader) {
                ++count;
                if (!this.seekHeader(this.raf, this.raf.length())) {
                    return false;
                }
                is = new Grib2IndicatorSection(this.raf);
                EOR = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
                SOR = this.raf.getFilePointer() - (long)is.getLength();
                if (is.getGribEdition() == 1) {
                    this.raf.seek(EOR);
                    continue;
                }
                if (discipline == -1 && forecast == -1) {
                    this.raf.seek(SOR);
                    byte[] oneRecord = new byte[(int)is.getGribLength()];
                    this.raf.read(oneRecord);
                    dos.write(oneRecord, 0, oneRecord.length);
                    dos.flush();
                    break;
                }
                id = new Grib2IdentificationSection(this.raf);
            }
            try {
                if (processGDS) {
                    lus = new Grib2LocalUseSection(this.raf);
                    gdsOffset = this.raf.getFilePointer();
                    gds = new Grib2GridDefinitionSection(this.raf, true);
                }
                long refTime = id == null ? 0L : id.getRefTime();
                pdsOffset = this.raf.getFilePointer();
                if (gdsOffset == gOffset && pdsOffset == pOffset) {
                    this.raf.seek(SOR);
                    byte[] oneRecord = new byte[(int)is.getGribLength()];
                    this.raf.read(oneRecord);
                    dos.write(oneRecord, 0, oneRecord.length);
                    dos.flush();
                    break;
                }
                pds = new Grib2ProductDefinitionSection(this.raf, refTime);
                Grib2Pds pdsv = pds.getPdsVars();
                if (pdsv._getForecastTime() == forecast && discipline == is.getDiscipline() && category == pdsv.getParameterCategory() && number == pdsv.getParameterNumber()) {
                    this.raf.seek(SOR);
                    byte[] oneRecord = new byte[(int)is.getGribLength()];
                    this.raf.read(oneRecord);
                    dos.write(oneRecord, 0, oneRecord.length);
                    dos.flush();
                }
                this.raf.seek(EOR);
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        dos.close();
        return true;
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            byte c = raf.readByte();
            hdr.append((char)c);
            if (c == 71) {
                match = 1;
                continue;
            }
            if (c == 82 && match == 1) {
                match = 2;
                continue;
            }
            if (c == 73 && match == 2) {
                match = 3;
                continue;
            }
            if (c == 66 && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB2";
                return true;
            }
            match = 0;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        String fileName;
        int discipline = -1;
        int category = -1;
        int number = -1;
        int forecast = -1;
        long gOffset = -1L;
        long pOffset = -1L;
        if (args.length == 1) {
            fileName = args[0];
        } else if (args.length == 2) {
            fileName = args[0];
            forecast = Integer.parseInt(args[1]);
        } else if (args.length == 3) {
            fileName = args[0];
            discipline = 1000;
            gOffset = Integer.parseInt(args[1]);
            pOffset = Integer.parseInt(args[2]);
        } else if (args.length == 4) {
            fileName = args[0];
            discipline = Integer.parseInt(args[1]);
            category = Integer.parseInt(args[2]);
            number = Integer.parseInt(args[3]);
        } else if (args.length == 5) {
            fileName = args[0];
            discipline = Integer.parseInt(args[1]);
            category = Integer.parseInt(args[2]);
            number = Integer.parseInt(args[3]);
            forecast = Integer.parseInt(args[4]);
        } else {
            System.out.println("Not correct number of parms, either 1 or 4");
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        Grib2ExtractRawData erd = new Grib2ExtractRawData(raf);
        erd.scan(discipline, category, number, forecast, gOffset, pOffset);
    }
}

