/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Drs {
    public static Grib2Drs factory(int template, RandomAccessFile raf) throws IOException {
        switch (template) {
            case 0: {
                return new Type0(raf);
            }
            case 2: {
                return new Type2(raf);
            }
            case 3: {
                return new Type3(raf);
            }
            case 40: {
                return new Type40(raf);
            }
        }
        throw new UnsupportedOperationException("Unsupported DRS type = " + template);
    }

    public int getNBits() {
        return -1;
    }

    public int getNGroups() {
        return 1;
    }

    public static class Type40
    extends Type0 {
        public int compressionMethod;
        public int compressionRatio;
        boolean hasSignedProblem = false;

        Type40(RandomAccessFile raf) throws IOException {
            super(raf);
            this.compressionMethod = raf.read();
            this.compressionRatio = raf.read();
        }

        public boolean hasSignedProblem() {
            return this.hasSignedProblem;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nType40");
            sb.append("{compressionMethod=").append(this.compressionMethod);
            sb.append(", compressionRatio=").append(this.compressionRatio);
            sb.append(", hasSignedProblem=").append(this.hasSignedProblem);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type40 type40 = (Type40)o;
            if (this.compressionMethod != type40.compressionMethod) {
                return false;
            }
            return this.compressionRatio == type40.compressionRatio;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.compressionMethod;
            result = 31 * result + this.compressionRatio;
            return result;
        }
    }

    public static class Type3
    extends Type2 {
        public int orderSpatial;
        public int descriptorSpatial;

        Type3(RandomAccessFile raf) throws IOException {
            super(raf);
            this.orderSpatial = raf.read();
            this.descriptorSpatial = raf.read();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nType3");
            sb.append("{orderSpatial=").append(this.orderSpatial);
            sb.append(", descriptorSpatial=").append(this.descriptorSpatial);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type3 type3 = (Type3)o;
            if (this.descriptorSpatial != type3.descriptorSpatial) {
                return false;
            }
            return this.orderSpatial == type3.orderSpatial;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.orderSpatial;
            result = 31 * result + this.descriptorSpatial;
            return result;
        }
    }

    public static class Type2
    extends Type0 {
        public float secondaryMissingValue;
        public float primaryMissingValue;
        public int missingValueManagement;
        public int splittingMethod;
        public int numberOfGroups;
        public int referenceGroupWidths;
        public int bitsGroupWidths;
        public int referenceGroupLength;
        public int lengthIncrement;
        public int lengthLastGroup;
        public int bitsScaledGroupLength;

        Type2(RandomAccessFile raf) throws IOException {
            super(raf);
            this.splittingMethod = raf.read();
            this.missingValueManagement = raf.read();
            this.primaryMissingValue = raf.readFloat();
            this.secondaryMissingValue = raf.readFloat();
            this.numberOfGroups = GribNumbers.int4(raf);
            this.referenceGroupWidths = raf.read();
            this.bitsGroupWidths = raf.read();
            this.referenceGroupLength = GribNumbers.int4(raf);
            this.lengthIncrement = raf.read();
            this.lengthLastGroup = GribNumbers.int4(raf);
            this.bitsScaledGroupLength = raf.read();
        }

        @Override
        public int getNGroups() {
            return this.numberOfGroups;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nType2");
            sb.append("{secondaryMissingValue=").append(this.secondaryMissingValue);
            sb.append(", primaryMissingValue=").append(this.primaryMissingValue);
            sb.append(", missingValueManagement=").append(this.missingValueManagement);
            sb.append(", splittingMethod=").append(this.splittingMethod);
            sb.append(", numberOfGroups=").append(this.numberOfGroups);
            sb.append(", referenceGroupWidths=").append(this.referenceGroupWidths);
            sb.append(", bitsGroupWidths=").append(this.bitsGroupWidths);
            sb.append(", referenceGroupLength=").append(this.referenceGroupLength);
            sb.append(", lengthIncrement=").append(this.lengthIncrement);
            sb.append(", lengthLastGroup=").append(this.lengthLastGroup);
            sb.append(", bitsScaledGroupLength=").append(this.bitsScaledGroupLength);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type2 type2 = (Type2)o;
            if (this.bitsGroupWidths != type2.bitsGroupWidths) {
                return false;
            }
            if (this.bitsScaledGroupLength != type2.bitsScaledGroupLength) {
                return false;
            }
            if (this.lengthIncrement != type2.lengthIncrement) {
                return false;
            }
            if (this.lengthLastGroup != type2.lengthLastGroup) {
                return false;
            }
            if (this.missingValueManagement != type2.missingValueManagement) {
                return false;
            }
            if (this.numberOfGroups != type2.numberOfGroups) {
                return false;
            }
            if (Float.compare(type2.primaryMissingValue, this.primaryMissingValue) != 0) {
                return false;
            }
            if (this.referenceGroupLength != type2.referenceGroupLength) {
                return false;
            }
            if (this.referenceGroupWidths != type2.referenceGroupWidths) {
                return false;
            }
            if (Float.compare(type2.secondaryMissingValue, this.secondaryMissingValue) != 0) {
                return false;
            }
            return this.splittingMethod == type2.splittingMethod;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.secondaryMissingValue != 0.0f ? Float.floatToIntBits(this.secondaryMissingValue) : 0);
            result = 31 * result + (this.primaryMissingValue != 0.0f ? Float.floatToIntBits(this.primaryMissingValue) : 0);
            result = 31 * result + this.missingValueManagement;
            result = 31 * result + this.splittingMethod;
            result = 31 * result + this.numberOfGroups;
            result = 31 * result + this.referenceGroupWidths;
            result = 31 * result + this.bitsGroupWidths;
            result = 31 * result + this.referenceGroupLength;
            result = 31 * result + this.lengthIncrement;
            result = 31 * result + this.lengthLastGroup;
            result = 31 * result + this.bitsScaledGroupLength;
            return result;
        }
    }

    public static class Type0
    extends Grib2Drs {
        public float referenceValue;
        public int binaryScaleFactor;
        public int decimalScaleFactor;
        public int numberOfBits;
        public int originalType;

        Type0(RandomAccessFile raf) throws IOException {
            this.referenceValue = raf.readFloat();
            this.binaryScaleFactor = GribNumbers.int2(raf);
            this.decimalScaleFactor = GribNumbers.int2(raf);
            this.numberOfBits = raf.read();
            this.originalType = raf.read();
        }

        @Override
        public int getNBits() {
            return this.numberOfBits;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Type0");
            sb.append("{referenceValue=").append(this.referenceValue);
            sb.append(", binaryScaleFactor=").append(this.binaryScaleFactor);
            sb.append(", decimalScaleFactor=").append(this.decimalScaleFactor);
            sb.append(", numberOfBits=").append(this.numberOfBits);
            sb.append(", originalType=").append(this.originalType);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type0 type0 = (Type0)o;
            if (this.binaryScaleFactor != type0.binaryScaleFactor) {
                return false;
            }
            if (this.decimalScaleFactor != type0.decimalScaleFactor) {
                return false;
            }
            if (this.numberOfBits != type0.numberOfBits) {
                return false;
            }
            if (this.originalType != type0.originalType) {
                return false;
            }
            return Float.compare(type0.referenceValue, this.referenceValue) == 0;
        }

        public int hashCode() {
            int result = this.referenceValue != 0.0f ? Float.floatToIntBits(this.referenceValue) : 0;
            result = 31 * result + this.binaryScaleFactor;
            result = 31 * result + this.decimalScaleFactor;
            result = 31 * result + this.numberOfBits;
            result = 31 * result + this.originalType;
            return result;
        }
    }
}

