/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionBitMap {
    private final long startingPosition;

    public Grib1SectionBitMap(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        int length = GribNumbers.int3(raf);
        raf.seek(this.startingPosition + (long)length);
    }

    public Grib1SectionBitMap(long startingPosition) {
        this.startingPosition = startingPosition;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    byte[] getBitmap(RandomAccessFile raf) throws IOException {
        if (this.startingPosition <= 0L) {
            return null;
        }
        raf.seek(this.startingPosition);
        int length = GribNumbers.uint3(raf);
        int unused = raf.read();
        short bm = raf.readShort();
        if (bm != 0) {
            throw new UnsupportedOperationException("Grib1 Bit map section pre-defined (provided by center)");
        }
        int n = length - 6;
        byte[] data = new byte[n];
        raf.read(data);
        return data;
    }
}

