/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.grib.GribResourceReader;
import ucar.grib.grib2.Category;
import ucar.grib.grib2.Discipline;
import ucar.nc2.iosp.grid.GridParameter;

public final class ParameterTable {
    private static Logger logger = LoggerFactory.getLogger(ParameterTable.class);
    private static final Pattern valid = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_@:\\.\\-\\+]*$");
    private static final Pattern numberFirst = Pattern.compile("^[0-9]");
    private static final boolean debug = false;
    private static final ArrayList<Discipline> discipline = new ArrayList();

    private static String makeValidDesc(String description) {
        if (valid.matcher(description = description.replaceAll("\\s+", "_")).find()) {
            return description;
        }
        if (numberFirst.matcher(description).find()) {
            description = "N" + description;
        }
        return description.replaceAll("\\)|\\(|=|,|;|\\[|\\]", "");
    }

    public static String getDisciplineName(int aDis) {
        Discipline dis = ParameterTable.getDiscipline(aDis);
        if (dis != null) {
            return dis.getName();
        }
        logger.debug("ParameterTable: UnknownDiscipline " + Integer.toString(aDis));
        return "UnknownDiscipline_" + Integer.toString(aDis);
    }

    private static Discipline getDiscipline(int aDis) {
        for (Discipline dis : discipline) {
            if (dis.getNumber() != aDis) continue;
            return dis;
        }
        logger.debug("ParameterTable: UnknownDiscipline " + Integer.toString(aDis));
        return null;
    }

    public static String getCategoryName(int d, int c) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return "UnknownDiscipline_" + Integer.toString(d) + "_Category_" + Integer.toString(c);
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            logger.debug("ParameterTable: UnknownCategory " + Integer.toString(c));
            return "UnknownCategory_" + Integer.toString(c);
        }
        return category.getName();
    }

    public static String getParameterName(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return unknown;
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return unknown;
        }
        GridParameter parameter = category.getParameter(p);
        if (parameter == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return unknown;
        }
        return parameter.getName();
    }

    public static String getParameterUnit(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            return "Unknown";
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            return "Unknown";
        }
        GridParameter parameter = category.getParameter(p);
        if (parameter == null) {
            return "Unknown";
        }
        return parameter.getUnit();
    }

    public static String getParameterDescription(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return unknown;
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return unknown;
        }
        GridParameter parameter = category.getParameter(p);
        if (parameter == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return unknown;
        }
        return parameter.getDescription();
    }

    public static GridParameter getParameter(int d, int c, int p) {
        Discipline discipline = ParameterTable.getDiscipline(d);
        if (discipline == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return new GridParameter(p, unknown, unknown, "Unknown");
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return new GridParameter(p, unknown, unknown, "Unknown");
        }
        GridParameter parameter = category.getParameter(p);
        if (parameter == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return new GridParameter(p, unknown, unknown, "Unknown");
        }
        return parameter;
    }

    public static GridParameter getParameter(int d, int c, int p, int center) {
        Discipline discipline = ParameterTable.getDiscipline(center * 255 + d);
        if (discipline == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return new GridParameter(p, unknown, unknown, "Unknown");
        }
        Category category = discipline.getCategory(c);
        if (category == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return new GridParameter(p, unknown, unknown, "Unknown");
        }
        GridParameter parameter = category.getParameter(p);
        if (parameter == null) {
            String unknown = "UnknownParameter_D" + Integer.toString(d) + "_C" + Integer.toString(c) + "_" + Integer.toString(p);
            return new GridParameter(p, unknown, unknown, "Unknown");
        }
        return parameter;
    }

    public static void addParametersUser(String UserGribTable) throws IOException {
        ParameterTable.addParametersUser(ParameterTable.getInputStream(UserGribTable));
    }

    public static void addParametersUser(InputStream is) throws IOException {
        String line;
        if (is == null) {
            return;
        }
        Pattern p_comment = Pattern.compile("^#");
        Pattern p_parameter = Pattern.compile("(.*)\t(.*)\t(.*)\t(.*)\t(.*)\t(.*)");
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            Matcher m;
            if (p_comment.matcher(line).find() || !(m = p_parameter.matcher(line)).find() || m.groupCount() != 6) continue;
            GridParameter p = new GridParameter(Integer.parseInt(m.group(3)), m.group(4), m.group(6), m.group(5));
            ParameterTable.getDiscipline(Integer.parseInt(m.group(1))).getCategory(Integer.parseInt(m.group(2))).setParameter(p);
        }
        is.close();
    }

    public static void addLocalParameters(String LocalParameters) throws IOException {
        String line;
        InputStream is = ParameterTable.getInputStream(LocalParameters);
        if (is == null) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        int center = 0;
        String centerStr = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            line.trim();
            String[] field = line.split("\\s[\\s]+");
            if (field.length == 1) {
                centerStr = "center_" + field[0];
                center = Integer.parseInt(field[0]);
                continue;
            }
            if (field.length == 6) {
                int c;
                Category cat;
                if (field[4].compareToIgnoreCase("non-dim") == 0) {
                    field[4] = "";
                }
                GridParameter p = new GridParameter(Integer.parseInt(field[2]), field[3], field[5], field[4]);
                int d = center * 255 + Integer.parseInt(field[0]);
                Discipline dis = ParameterTable.getDiscipline(d);
                if (dis == null) {
                    dis = new Discipline();
                    dis.setNumber(d);
                    dis.setName(centerStr);
                    discipline.add(dis);
                }
                if ((cat = dis.getCategory(c = Integer.parseInt(field[1]))) == null) {
                    cat = new Category();
                    cat.setNumber(c);
                    cat.setName(field[1]);
                    dis.setCategory(cat);
                }
                cat.setParameter(p);
                continue;
            }
            logger.error("Grib2 local table reading failed");
        }
        is.close();
    }

    private static InputStream getInputStream(String filename) {
        return ParameterTable.getInputStream(filename, null);
    }

    private static InputStream getInputStream(String filename, Class origin) {
        return GribResourceReader.getInputStream(filename, origin);
    }

    public static void main(String[] args) {
        System.out.println("Parameter = " + ParameterTable.getParameter(0, 2, 22, 8));
        System.out.println("Parameter = " + ParameterTable.getParameter(0, 2, 22, 0));
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            ClassLoader cl = ParameterTable.class.getClassLoader();
            InputStream is = cl.getResourceAsStream("resources/grib2/tablesOld/grib2StdQuantities.xml");
            Document doc = parser.parse(is);
            NodeList d = doc.getElementsByTagName("discipline");
            for (int i = 0; i < d.getLength(); ++i) {
                Discipline dis = new Discipline();
                NamedNodeMap da = d.item(i).getAttributes();
                for (int j = 0; j < da.getLength(); ++j) {
                    if (da.item(j).getNodeName().equals("id")) {
                        dis.setName(da.item(j).getNodeValue());
                        continue;
                    }
                    if (!da.item(j).getNodeName().equals("number")) continue;
                    dis.setNumber(Integer.parseInt(da.item(j).getNodeValue()));
                }
                NodeList c = d.item(i).getChildNodes();
                for (int j = 0; j < c.getLength(); ++j) {
                    if (!c.item(j).getNodeName().equals("category")) continue;
                    Category cat = new Category();
                    NamedNodeMap ca = c.item(j).getAttributes();
                    for (int k = 0; k < ca.getLength(); ++k) {
                        if (ca.item(k).getNodeName().equals("id")) {
                            cat.setName(ca.item(k).getNodeValue());
                            continue;
                        }
                        if (!ca.item(k).getNodeName().equals("number")) continue;
                        cat.setNumber(Integer.parseInt(ca.item(k).getNodeValue()));
                    }
                    NodeList p = c.item(j).getChildNodes();
                    for (int m = 0; m < p.getLength(); ++m) {
                        if (!p.item(m).getNodeName().equals("quantity")) continue;
                        GridParameter par = null;
                        String pName = "";
                        int pNumber = -1;
                        String pUnit = "";
                        String pDesc = "";
                        NamedNodeMap pa = p.item(m).getAttributes();
                        for (int n = 0; n < pa.getLength(); ++n) {
                            Node attr = pa.item(n);
                            if (attr.getNodeName().equals("id")) {
                                pName = attr.getNodeValue();
                                continue;
                            }
                            if (attr.getNodeName().equals("number")) {
                                pNumber = Integer.parseInt(attr.getNodeValue());
                                continue;
                            }
                            if (attr.getNodeName().equals("unit")) {
                                pUnit = attr.getNodeValue();
                                continue;
                            }
                            if (!attr.getNodeName().equals("description")) continue;
                            pDesc = ParameterTable.makeValidDesc(attr.getNodeValue());
                        }
                        if (pName.startsWith("Reserved") || pName.startsWith("Missing")) continue;
                        par = new GridParameter();
                        par.setName(pName);
                        par.setNumber(pNumber);
                        par.setUnit(pUnit);
                        par.setDescription(pDesc);
                        cat.setParameter(par);
                    }
                    dis.setCategory(cat);
                }
                discipline.add(dis);
            }
            is.close();
            ParameterTable.addLocalParameters("resources/grib2/tablesOld/grib2local.tab");
        }
        catch (Throwable e) {
            logger.error("grib2 table reading failed", e);
        }
    }
}

