/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2IdentificationSection {
    private final int length;
    private final int section;
    private final int center_id;
    private final int subcenter_id;
    private final int master_table_version;
    private final int local_table_version;
    private final int significanceOfRT;
    private final Date baseTime;
    private final long refTime;
    private final int productStatus;
    private final int productType;

    public Grib2IdentificationSection(RandomAccessFile raf) throws IOException {
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.int4(raf);
        sectionEnd += (long)this.length;
        this.section = raf.read();
        this.center_id = GribNumbers.int2(raf);
        this.subcenter_id = GribNumbers.int2(raf);
        this.master_table_version = raf.read();
        this.local_table_version = raf.read();
        this.significanceOfRT = raf.read();
        int year = GribNumbers.int2(raf);
        int month = raf.read() - 1;
        int day = raf.read();
        int hour = raf.read();
        int minute = raf.read();
        int second = raf.read();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(16, 0);
        calendar.set(year, month, day, hour, minute, second);
        this.baseTime = calendar.getTime();
        this.refTime = calendar.getTimeInMillis();
        this.productStatus = raf.read();
        this.productType = raf.read();
        raf.seek(sectionEnd);
    }

    public final int getCenter_id() {
        return this.center_id;
    }

    public final int getSubcenter_id() {
        return this.subcenter_id;
    }

    public final int getMaster_table_version() {
        return this.master_table_version;
    }

    public final int getLocal_table_version() {
        return this.local_table_version;
    }

    public final int getSignificanceOfRT() {
        return this.significanceOfRT;
    }

    public final String getSignificanceOfRTName() {
        switch (this.significanceOfRT) {
            case 0: {
                return "Analysis";
            }
            case 1: {
                return "Start of forecast";
            }
            case 2: {
                return "Verifying time of forecast";
            }
            case 3: {
                return "Observation time";
            }
        }
        return "Unknown";
    }

    public final long getRefTime() {
        return this.refTime;
    }

    public final Date getBaseTime() {
        return this.baseTime;
    }

    public final int getProductStatus() {
        return this.productStatus;
    }

    public final String getProductStatusName() {
        switch (this.productStatus) {
            case 0: {
                return "Operational products";
            }
            case 1: {
                return "Operational test products";
            }
            case 2: {
                return "Research products";
            }
            case 3: {
                return "Re-analysis products";
            }
            case 4: {
                return "THORPEX Interactive Grand Global Ensemble (TIGGE)";
            }
            case 5: {
                return "THORPEX Interactive Grand Global Ensemble (TIGGE) test";
            }
        }
        return "Unknown";
    }

    public final int getProductType() {
        return this.productType;
    }

    public final String getProductTypeName() {
        switch (this.productType) {
            case 0: {
                return "Analysis products";
            }
            case 1: {
                return "Forecast products";
            }
            case 2: {
                return "Analysis and Forecast products";
            }
            case 3: {
                return "Control Forecast products";
            }
            case 4: {
                return "Perturbed Forecast products";
            }
            case 5: {
                return "Control and Perturbed Forecast products";
            }
            case 6: {
                return "Processed Satellite observations";
            }
            case 7: {
                return "Processed Radar observations";
            }
            case 8: {
                return "Event Probability";
            }
        }
        return "GRID data";
    }

    public int getLength() {
        return this.length;
    }
}

