/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

public class GribUtils {
    public static final String CENTER = "Originating_or_generating_Center";
    public static final String SUBCENTER = "Originating_or_generating_Subcenter";
    public static final String GEN_PROCESS = "Generating_process_or_model";
    public static final String TABLE_VERSION = "GRIB_table_version";

    public static CalendarPeriod getCalendarPeriod(int timeUnit) {
        switch (timeUnit) {
            case 0: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
            case 1: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 2: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
            }
            case 3: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Month);
            }
            case 4: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 5: {
                return CalendarPeriod.of((int)10, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 6: {
                return CalendarPeriod.of((int)30, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 7: {
                return CalendarPeriod.of((int)100, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 10: {
                return CalendarPeriod.of((int)3, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 11: {
                return CalendarPeriod.of((int)6, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 12: {
                return CalendarPeriod.of((int)12, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 13: {
                return CalendarPeriod.of((int)15, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
            case 14: {
                return CalendarPeriod.of((int)30, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
        }
        throw new UnsupportedOperationException("Unknown time unit = " + timeUnit);
    }

    public static String cleanupUnits(String unit) {
        if (unit == null) {
            return null;
        }
        if (unit.equalsIgnoreCase("-")) {
            unit = "";
        } else {
            if (unit.startsWith("/")) {
                unit = "1" + unit;
            }
            unit = unit.trim();
            unit = StringUtil2.remove((String)unit, (String)"**");
            StringBuilder sb = new StringBuilder(unit);
            StringUtil2.remove((StringBuilder)sb, (String)"^[]");
            StringUtil2.substitute((StringBuilder)sb, (String)" / ", (String)"/");
            StringUtil2.replace((StringBuilder)sb, (char)' ', (String)".");
            StringUtil2.replace((StringBuilder)sb, (char)'*', (String)".");
            unit = sb.toString();
        }
        return unit;
    }

    public static String cleanupDescription(String desc) {
        if (desc == null) {
            return null;
        }
        int pos = desc.indexOf("(see");
        if (pos < 0) {
            pos = desc.indexOf("(See");
        }
        if (pos > 0) {
            desc = desc.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder(desc.trim());
        StringUtil2.remove((StringBuilder)sb, (String)".;,=[]()/");
        return sb.toString().trim();
    }

    public static String makeNameFromDescription(String desc) {
        if (desc == null) {
            return null;
        }
        int pos = desc.indexOf("(see");
        if (pos < 0) {
            pos = desc.indexOf("(See");
        }
        if (pos > 0) {
            desc = desc.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder(desc.trim());
        StringUtil2.replace((StringBuilder)sb, (String)"/. ", (String)"-p_");
        StringUtil2.remove((StringBuilder)sb, (String)";,=[]()");
        return sb.toString();
    }
}

