/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.TimeUnitConverter;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.FslLocalTables;
import ucar.nc2.grib.grib2.table.KmaLocalTables;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.grib.grib2.table.NdfdLocalTables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.wmo.CommonCodeTable;

@Immutable
public class Grib2Customizer
implements GribTables,
TimeUnitConverter {
    private static final Logger log = LoggerFactory.getLogger(Grib2Pds.class);
    private static Grib2Customizer wmoTables;
    private static Grib2Customizer ncepTables;
    private static Grib2Customizer ndfdTables;
    private static Grib2Customizer kmaTables;
    private static Grib2Customizer fslTables;
    private static Grib2Customizer fslTables2;
    protected final int center;
    protected final int subCenter;
    protected final int masterVersion;
    protected final int localVersion;
    private TimeUnitConverter timeUnitConverter;

    public static Grib2Customizer factory(Grib2Record gr) {
        Grib2SectionIdentification ids = gr.getId();
        return Grib2Customizer.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version());
    }

    public static Grib2Customizer factory(int center, int subCenter, int masterVersion, int localVersion) {
        if (center == 7 || center == 9 || center == 54) {
            if (ncepTables == null) {
                ncepTables = new NcepLocalTables(center, subCenter, masterVersion, localVersion);
            }
            return ncepTables;
        }
        if (center == 59 && localVersion == 0) {
            return FslLocalTables.localFactory(center, subCenter, masterVersion, localVersion);
        }
        if (center == 59) {
            if (fslTables == null) {
                fslTables = FslLocalTables.localFactory(center, subCenter, masterVersion, localVersion);
            }
            return fslTables;
        }
        if (center == 8 && (subCenter == 0 || subCenter == -9999)) {
            if (ndfdTables == null) {
                ndfdTables = new NdfdLocalTables(center, subCenter, masterVersion, localVersion);
            }
            return ndfdTables;
        }
        if (center == 40) {
            if (kmaTables == null) {
                kmaTables = new KmaLocalTables(center, subCenter, masterVersion, localVersion);
            }
            return kmaTables;
        }
        if (wmoTables == null) {
            wmoTables = new Grib2Customizer(center, subCenter, masterVersion, localVersion);
        }
        return wmoTables;
    }

    public static List<GribTableId> getTableIds() {
        ArrayList<GribTableId> result = new ArrayList<GribTableId>();
        result.add(new GribTableId("WMO", 0, -1, -1, -1));
        result.add(new GribTableId("NCEP", 7, -1, -1, -1));
        result.add(new GribTableId("NDFD", 8, 0, -1, -1));
        result.add(new GribTableId("KMA", 40, -1, -1, -1));
        result.add(new GribTableId("FSL", 59, -1, -1, -1));
        return result;
    }

    public static int makeHash(int discipline, int category, int number) {
        return (discipline << 16) + (category << 8) + number;
    }

    public static boolean isLocal(GribTables.Parameter p) {
        return p.getCategory() > 191 || p.getNumber() > 191;
    }

    protected Grib2Customizer(int center, int subCenter, int masterVersion, int localVersion) {
        this.center = center;
        this.subCenter = subCenter;
        this.masterVersion = masterVersion;
        this.localVersion = localVersion;
    }

    public String getVariableName(Grib2Record gr) {
        return this.getVariableName(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
    }

    public String getVariableName(int discipline, int category, int parameter) {
        String s = WmoCodeTable.getParameterName(discipline, category, parameter);
        if (s == null) {
            s = "U" + discipline + "-" + category + "-" + parameter;
        }
        return s;
    }

    public String getTableValue(String tableName, int code) {
        return WmoCodeTable.getTableValue(tableName, code);
    }

    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        return WmoCodeTable.getParameterEntry(discipline, category, number);
    }

    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return WmoCodeTable.getParameterEntry(discipline, category, number);
    }

    public String getTablePath(int discipline, int category, int number) {
        return WmoCodeTable.standard.getResourceName();
    }

    public List getParameters() {
        ArrayList<WmoCodeTable.TableEntry> allParams = new ArrayList<WmoCodeTable.TableEntry>(3000);
        try {
            WmoCodeTable.WmoTables wmo = WmoCodeTable.getWmoStandard();
            for (String key : wmo.map.keySet()) {
                if (!key.startsWith("4.2.")) continue;
                WmoCodeTable params = wmo.map.get(key);
                allParams.addAll(params.entries);
            }
        }
        catch (IOException e) {
            System.out.printf("Error reading wmo tables = %s%n", e.getMessage());
        }
        return allParams;
    }

    public void lookForProblems(Formatter f) {
    }

    public CalendarDate getForecastDate(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (pds.isTimeInterval()) {
            TimeCoord.TinvDate intv = this.getForecastTimeInterval(gr);
            return intv.getEnd();
        }
        int val = pds.getForecastTime();
        CalendarPeriod period = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(pds.getTimeUnit()));
        return gr.getReferenceDate().add(period.multiply(val));
    }

    public TimeCoord.TinvDate getForecastTimeInterval(Grib2Record gr) {
        if (!gr.getPDS().isTimeInterval()) {
            return null;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        int timeUnitOrg = gr.getPDS().getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit != timeUnitOrg || ti.timeIncrementUnit != timeUnitOrg && ti.timeIncrementUnit != 255 && ti.timeIncrement != 0) {
                log.warn("TimeInterval has different units timeUnit= " + timeUnitOrg + " TimeInterval=" + ti);
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        CalendarPeriod unitPeriod = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(timeUnitOrg));
        CalendarPeriod period = unitPeriod.multiply(range);
        CalendarDate EI = pdsIntv.getIntervalTimeEnd();
        if (EI == null) {
            return new TimeCoord.TinvDate(gr.getReferenceDate(), period);
        }
        return new TimeCoord.TinvDate(period, EI);
    }

    public double getForecastTimeIntervalSizeInHours(Grib2Record gr) {
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        int timeUnitOrg = gr.getPDS().getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit != timeUnitOrg || ti.timeIncrementUnit != timeUnitOrg && ti.timeIncrementUnit != 255 && ti.timeIncrement != 0) {
                log.warn("TimeInterval has different units timeUnit= " + timeUnitOrg + " TimeInterval=" + ti);
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        CalendarPeriod timeUnitPeriod = Grib2Utils.getCalendarPeriod(this.convertTimeUnit(timeUnitOrg));
        if (timeUnitPeriod.equals((Object)CalendarPeriod.Hour)) {
            return range;
        }
        double fac = timeUnitPeriod.getField() == CalendarPeriod.Field.Month ? 720.0 : (timeUnitPeriod.getField() == CalendarPeriod.Field.Year ? 8760.0 : CalendarPeriod.Hour.getConvertFactor(timeUnitPeriod));
        return fac * (double)range;
    }

    public int[] getForecastTimeIntervalOffset(Grib2Record gr) {
        TimeCoord.TinvDate tinvd = this.getForecastTimeInterval(gr);
        if (tinvd == null) {
            return null;
        }
        Grib2Pds pds = gr.getPDS();
        int unit = this.convertTimeUnit(pds.getTimeUnit());
        TimeCoord.Tinv tinv = tinvd.convertReferenceDate(gr.getReferenceDate(), Grib2Utils.getCalendarPeriod(unit));
        int[] result = new int[]{tinv.getBounds1(), tinv.getBounds2()};
        return result;
    }

    public String getLevelName(int id) {
        return this.getTableValue("4.5", id);
    }

    @Override
    public String getLevelNameShort(int id) {
        switch (id) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 10: {
                return "entire_atmosphere";
            }
            case 11: {
                return "cumulonimbus_base";
            }
            case 12: {
                return "cumulonimbus_top";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "pressure";
            }
            case 101: {
                return "msl";
            }
            case 102: {
                return "altitude_above_msl";
            }
            case 103: {
                return "height_above_ground";
            }
            case 104: {
                return "sigma";
            }
            case 105: {
                return "hybrid";
            }
            case 106: {
                return "depth_below_surface";
            }
            case 107: {
                return "isentrope";
            }
            case 108: {
                return "pressure_difference";
            }
            case 109: {
                return "potential_vorticity_surface";
            }
            case 111: {
                return "eta";
            }
            case 113: {
                return "log_hybrid";
            }
            case 117: {
                return "mixed_layer_depth";
            }
            case 118: {
                return "hybrid_height";
            }
            case 119: {
                return "hybrid_pressure";
            }
            case 120: {
                return "pressure_thickness";
            }
            case 160: {
                return "depth_below_sea";
            }
            case -9999: {
                return "none";
            }
        }
        return "UnknownLevelType-" + id;
    }

    public String getProbabilityNameShort(int id) {
        switch (id) {
            case 0: {
                return "unweightedMean";
            }
            case 1: {
                return "weightedMean";
            }
            case 2: {
                return "stdDev";
            }
            case 3: {
                return "stdDevNormalized";
            }
            case 4: {
                return "spread";
            }
            case 5: {
                return "largeAnomalyIndex";
            }
            case 6: {
                return "unweightedMeanCluster";
            }
            case 7: {
                return "interquartileRange";
            }
            case 8: {
                return "minimumEnsemble";
            }
            case 9: {
                return "maximumEnsemble";
            }
        }
        return "UnknownProbType" + id;
    }

    public String getIntervalName(int id) {
        return this.getTableValue("4.10", id);
    }

    public String getIntervalNameShort(int id) {
        GribStatType stat = GribStatType.getStatTypeFromGrib2(id);
        return stat == null ? "UnknownStatType-" + id : stat.toString();
    }

    public GribStatType getStatType(int grib2StatCode) {
        return GribStatType.getStatTypeFromGrib2(grib2StatCode);
    }

    public void setTimeUnitConverter(TimeUnitConverter timeUnitConverter) {
        this.timeUnitConverter = timeUnitConverter;
    }

    public int convertTimeUnit(int timeUnit) {
        if (this.timeUnitConverter == null) {
            return timeUnit;
        }
        return this.timeUnitConverter.convertTimeUnit(timeUnit);
    }

    public String getSubCenterName(int center_id, int subcenter_id) {
        return CommonCodeTable.getSubCenterName((int)center_id, (int)subcenter_id);
    }

    public String getGeneratingProcessName(int genProcess) {
        return null;
    }

    public String getGeneratingProcessTypeName(int genProcess) {
        return this.getTableValue("4.3", genProcess);
    }

    public String getCategory(int discipline, int category) {
        return this.getTableValue("4.1." + discipline, category);
    }

    public static void main(String[] args) {
        Grib2Customizer cust = Grib2Customizer.factory(0, 0, 0, 0);
        String c = cust.getCategory(0, 14);
        System.out.printf("%s%n", c);
    }

    public static class GribTableId {
        public final String name;
        public final int center;
        public final int subCenter;
        public final int masterVersion;
        public final int localVersion;

        GribTableId(String name, int center, int subCenter, int masterVersion, int localVersion) {
            this.name = name;
            this.center = center;
            this.subCenter = subCenter;
            this.masterVersion = masterVersion;
            this.localVersion = localVersion;
        }
    }
}

