/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.encoder;

import ucar.jpeg.jj2000.j2k.IntegerSpec;
import ucar.jpeg.jj2000.j2k.StringSpec;
import ucar.jpeg.jj2000.j2k.entropy.CBlkSizeSpec;
import ucar.jpeg.jj2000.j2k.entropy.PrecinctSizeSpec;
import ucar.jpeg.jj2000.j2k.entropy.ProgressionSpec;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.CompTransfSpec;
import ucar.jpeg.jj2000.j2k.image.forwcomptransf.ForwCompTransfSpec;
import ucar.jpeg.jj2000.j2k.quantization.GuardBitsSpec;
import ucar.jpeg.jj2000.j2k.quantization.QuantStepSizeSpec;
import ucar.jpeg.jj2000.j2k.quantization.QuantTypeSpec;
import ucar.jpeg.jj2000.j2k.quantization.quantizer.Quantizer;
import ucar.jpeg.jj2000.j2k.roi.MaxShiftSpec;
import ucar.jpeg.jj2000.j2k.util.ParameterList;
import ucar.jpeg.jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class EncoderSpecs {
    public MaxShiftSpec rois;
    public QuantTypeSpec qts;
    public QuantStepSizeSpec qsss;
    public GuardBitsSpec gbs;
    public AnWTFilterSpec wfs;
    public CompTransfSpec cts;
    public IntegerSpec dls;
    public StringSpec lcs;
    public StringSpec tts;
    public StringSpec sss;
    public StringSpec css;
    public StringSpec rts;
    public StringSpec mqrs;
    public StringSpec bms;
    public PrecinctSizeSpec pss;
    public StringSpec sops;
    public StringSpec ephs;
    public CBlkSizeSpec cblks;
    public ProgressionSpec pocs;
    public int nTiles;
    public int nComp;

    public EncoderSpecs(int nt, int nc, BlkImgDataSrc imgsrc, ParameterList pl) {
        this.nTiles = nt;
        this.nComp = nc;
        this.rois = new MaxShiftSpec(nt, nc, 2);
        pl.checkList('Q', ParameterList.toNameArray(Quantizer.getParameterInfo()));
        this.qts = new QuantTypeSpec(nt, nc, 2, pl);
        this.qsss = new QuantStepSizeSpec(nt, nc, 2, pl);
        this.gbs = new GuardBitsSpec(nt, nc, 2, pl);
        this.wfs = new AnWTFilterSpec(nt, nc, 2, this.qts, pl);
        this.dls = new IntegerSpec(nt, nc, 2, pl, "Wlev");
        this.cts = new ForwCompTransfSpec(nt, nc, 1, this.wfs, pl);
        String[] strLcs = new String[]{"near_opt", "lazy_good", "lazy"};
        this.lcs = new StringSpec(nt, nc, 2, "Clen_calc", strLcs, pl);
        String[] strTerm = new String[]{"near_opt", "easy", "predict", "full"};
        this.tts = new StringSpec(nt, nc, 2, "Cterm_type", strTerm, pl);
        String[] strBoolean = new String[]{"on", "off"};
        this.sss = new StringSpec(nt, nc, 2, "Cseg_symbol", strBoolean, pl);
        this.css = new StringSpec(nt, nc, 2, "Ccausal", strBoolean, pl);
        this.rts = new StringSpec(nt, nc, 2, "Cterminate", strBoolean, pl);
        this.mqrs = new StringSpec(nt, nc, 2, "CresetMQ", strBoolean, pl);
        this.bms = new StringSpec(nt, nc, 2, "Cbypass", strBoolean, pl);
        this.cblks = new CBlkSizeSpec(nt, nc, 2, pl);
        this.pss = new PrecinctSizeSpec(nt, nc, 2, imgsrc, this.dls, pl);
        this.sops = new StringSpec(nt, nc, 1, "Psop", strBoolean, pl);
        this.ephs = new StringSpec(nt, nc, 1, "Peph", strBoolean, pl);
    }
}

