/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.colorspace.boxes;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.colorspace.boxes.JP2Box;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;

public final class ChannelDefinitionBox
extends JP2Box {
    private int ndefs;
    private Hashtable definitions = new Hashtable();

    public ChannelDefinitionBox(RandomAccessIO in, int boxStart) throws IOException, ColorSpaceException {
        super(in, boxStart);
        this.readBox();
    }

    private void readBox() throws IOException {
        byte[] bfr = new byte[8];
        this.in.seek(this.dataStart);
        this.in.readFully(bfr, 0, 2);
        this.ndefs = ICCProfile.getShort(bfr, 0) & 0xFFFF;
        int offset = this.dataStart + 2;
        this.in.seek(offset);
        for (int i = 0; i < this.ndefs; ++i) {
            this.in.readFully(bfr, 0, 6);
            short channel = ICCProfile.getShort(bfr, 0);
            int[] channel_def = new int[]{this.getCn(bfr), this.getTyp(bfr), this.getAsoc(bfr)};
            this.definitions.put(new Integer(channel_def[0]), channel_def);
        }
    }

    public int getNDefs() {
        return this.ndefs;
    }

    public int getCn(int asoc) {
        Enumeration keys = this.definitions.keys();
        while (keys.hasMoreElements()) {
            int[] bfr = (int[])this.definitions.get(keys.nextElement());
            if (asoc != this.getAsoc(bfr)) continue;
            return this.getCn(bfr);
        }
        return asoc;
    }

    public int getTyp(int channel) {
        int[] bfr = (int[])this.definitions.get(new Integer(channel));
        return this.getTyp(bfr);
    }

    public int getAsoc(int channel) {
        int[] bfr = (int[])this.definitions.get(new Integer(channel));
        return this.getAsoc(bfr);
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ChannelDefinitionBox ").append(eol).append("  ");
        rep.append("ndefs= ").append(String.valueOf(this.ndefs));
        Enumeration keys = this.definitions.keys();
        while (keys.hasMoreElements()) {
            int[] bfr = (int[])this.definitions.get(keys.nextElement());
            rep.append(eol).append("  ").append("Cn= ").append(String.valueOf(this.getCn(bfr))).append(", ").append("Typ= ").append(String.valueOf(this.getTyp(bfr))).append(", ").append("Asoc= ").append(String.valueOf(this.getAsoc(bfr)));
        }
        rep.append("]");
        return rep.toString();
    }

    private int getCn(byte[] bfr) {
        return ICCProfile.getShort(bfr, 0);
    }

    private int getTyp(byte[] bfr) {
        return ICCProfile.getShort(bfr, 2);
    }

    private int getAsoc(byte[] bfr) {
        return ICCProfile.getShort(bfr, 4);
    }

    private int getCn(int[] bfr) {
        return bfr[0];
    }

    private int getTyp(int[] bfr) {
        return bfr[1];
    }

    private int getAsoc(int[] bfr) {
        return bfr[2];
    }

    static {
        type = 1667523942;
    }
}

