/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grib.grib2.Grib2Data;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2GetData {
    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileContainingData> ");
        System.out.println("<OffsetToGds> obtained from Grib2Indexer program");
        System.out.println("<OffsetToPds> obtained from Grib2Indexer program");
        System.out.println("<output file>");
        System.out.println();
        System.out.println("java -Xmx256m ucar/grib/grib2/" + className + " <GribFileContainingData> <OffsetToGds> <OffsetToPds>");
        System.exit(0);
    }

    public static void main(String[] args) {
        Grib2GetData func = new Grib2GetData();
        if (args.length < 3) {
            Class<?> cl = func.getClass();
            Grib2GetData.usage(cl.getName());
        }
        TimeZone tz = TimeZone.getTimeZone("127");
        TimeZone.setDefault(tz);
        Date now = Calendar.getInstance().getTime();
        try {
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            long GdsOffset = 0L;
            long PdsOffset = 0L;
            if (args.length == 3 || args.length == 4) {
                raf = new RandomAccessFile(args[0], "r");
                raf.order(0);
                GdsOffset = Long.parseLong(args[1]);
                PdsOffset = Long.parseLong(args[2]);
            } else {
                System.exit(0);
            }
            if (args.length == 4) {
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[3], false)));
            }
            Grib2Data g2d = new Grib2Data(raf);
            float[] data = g2d.getData(GdsOffset, PdsOffset, 0L);
            float min = 9999.0f;
            float max = -9999.0f;
            if (data != null) {
                for (int j = 0; j < data.length; ++j) {
                    if (data[j] < min) {
                        min = data[j];
                    }
                    if (data[j] > max) {
                        max = data[j];
                    }
                    ps.println("data[ " + j + " ]=" + data[j]);
                    if (Float.isNaN(data[j])) continue;
                    data[j] = (float)((double)Math.round((double)data[j] * 1000.0) / 1000.0);
                }
            }
            raf.close();
            ps.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
    }
}

