/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Dump {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    static Calendar calendar;

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans file");
        System.out.println("<output file> file to store results");
        System.out.println("<true or false> whether to read/display data too");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <output file> <true or false>");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Grib1Dump func = new Grib1Dump();
        if (args.length < 1) {
            Class<?> cl = func.getClass();
            Grib1Dump.usage(cl.getName());
        }
        boolean displayData = false;
        Date now = Calendar.getInstance().getTime();
        calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        PrintStream ps = System.out;
        try {
            RandomAccessFile raf = null;
            if (args.length == 3) {
                raf = new RandomAccessFile(args[0], "r");
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[1], false)));
                displayData = args[2].equalsIgnoreCase("true");
            } else if (args.length == 2) {
                raf = new RandomAccessFile(args[0], "r");
                if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("false")) {
                    displayData = args[1].equalsIgnoreCase("true");
                } else {
                    ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[1], false)));
                }
            } else if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
            } else {
                System.exit(0);
            }
            raf.order(0);
            Grib1Input g1i = new Grib1Input(raf);
            g1i.scan(false, false);
            ArrayList<Grib1Record> records = g1i.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                Grib1Record record = records.get(i);
                Grib1IndicatorSection is = record.getIs();
                Grib1ProductDefinitionSection pds = record.getPDS();
                Grib1GridDefinitionSection gds = record.getGDS();
                ps.println("--------------------------------------------------------------------");
                ps.println("                        Header : " + record.getHeader());
                Grib1Dump.printIS(is, ps);
                Grib1Dump.printPDS(pds, ps);
                Grib1Dump.printGDS(gds, pds, ps);
                ps.println();
                if (!displayData) continue;
                float[] data = null;
                ps.println("--------------------------------------------------------------------");
                Grib1Data gd = new Grib1Data(raf);
                data = gd.getData(record.getDataOffset(), pds.getDecimalScale(), pds.bmsExists());
                if (data == null) break;
                for (int j = 0; j < data.length; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
                break;
            }
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        finally {
            ps.close();
        }
        now = Calendar.getInstance().getTime();
    }

    private static void printIS(Grib1IndicatorSection is, PrintStream ps) {
        ps.println("                    Discipline : 0 Meteorological Products");
        ps.println("                  GRIB Edition : " + is.getGribEdition());
        ps.println("                   GRIB length : " + is.getGribLength());
    }

    public static void printGDS(Grib1GridDefinitionSection gds, Grib1ProductDefinitionSection pds, PrintStream ps) {
        Grib1Pds pdsv;
        Grib1GDSVariables gdsv = gds.getGdsVars();
        int gdtn = gdsv.getGdtn();
        int numberOfPoints = gdsv.getNx() * gdsv.getNy();
        if (pds != null && (pdsv = pds.getPdsVars()).getGenProcessId() == 96) {
            numberOfPoints = 3447;
        }
        ps.println("         Number of data points : " + numberOfPoints);
        ps.println("                     Grid Name : " + Grib1Tables.getGridName(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        switch (gdtn) {
            case 0: 
            case 4: 
            case 10: 
            case 40: 
            case 201: 
            case 202: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib1Tables.getShapeName(gdtn));
                if (gdsv.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("                            Nx : " + gdsv.getNx());
                ps.println("                            Ny : " + gdsv.getNy());
                ps.println("                           La1 : " + gdsv.getLa1());
                ps.println("                           Lo1 : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           La2 : " + gdsv.getLa2());
                ps.println("                           Lo2 : " + gdsv.getLo2());
                ps.println("                            Dx : " + gdsv.getDx());
                if (gdtn == 4) {
                    ps.println("                            Np : " + gdsv.getNp());
                } else {
                    ps.println("                            Dy : " + gdsv.getDy());
                }
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                if (gdtn == 10) {
                    ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                    ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                    ps.println("             Angle of Rotation : " + gdsv.getAngle());
                    break;
                }
                if (gdtn == 2 || gdtn != 3) break;
                ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                break;
            }
            case 1: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib1Tables.getShapeName(gdtn));
                if (gdsv.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("                            Nx : " + gdsv.getNx());
                ps.println("                            Ny : " + gdsv.getNy());
                ps.println("                           La1 : " + gdsv.getLa1());
                ps.println("                           Lo1 : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           La2 : " + gdsv.getLa2());
                ps.println("                           Lo2 : " + gdsv.getLo2());
                ps.println("                         Latin : " + gdsv.getLatin1());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                ps.println("                            Dx : " + gdsv.getDx());
                ps.println("                            Dy : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                break;
            }
            case 5: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib1Tables.getShapeName(gdtn));
                if (gdsv.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("                            Nx : " + gdsv.getNx());
                ps.println("                            Ny : " + gdsv.getNy());
                ps.println("                           La1 : " + gdsv.getLa1());
                ps.println("                           Lo1 : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           LoV : " + gdsv.getLoV());
                ps.println("                            Dx : " + gdsv.getDx());
                ps.println("                            Dy : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("             Projection center : " + gdsv.getProjectionFlag());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                break;
            }
            case 3: {
                ps.println("                    Grid Shape : " + gdsv.getShape() + " " + Grib1Tables.getShapeName(gdtn));
                if (gdsv.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("                            Nx : " + gdsv.getNx());
                ps.println("                            Ny : " + gdsv.getNy());
                ps.println("                           La1 : " + gdsv.getLa1());
                ps.println("                           Lo1 : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           LoV : " + gdsv.getLoV());
                ps.println("                            Dx : " + gdsv.getDx());
                ps.println("                            Dy : " + gdsv.getDy());
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("             Projection center : " + gdsv.getProjectionFlag());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                ps.println("                        Latin1 : " + gdsv.getLatin1());
                ps.println("                        Latin2 : " + gdsv.getLatin2());
                ps.println("                         SpLat : " + gdsv.getSpLat());
                ps.println("                         SpLon : " + gdsv.getSpLon());
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                ps.println("                     Grid Shape: " + gdsv.getShape() + " " + Grib1Tables.getShapeName(gdtn));
                if (gdsv.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gdsv.getEarthRadius());
                } else if (gdsv.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gdsv.getMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gdsv.getMinorAxis());
                }
                ps.println("Number of points along parallel: " + gdsv.getNx());
                ps.println("Number of points along meridian: " + gdsv.getNy());
                ps.println("  Latitude of first grid point : " + gdsv.getLa1());
                ps.println(" Longitude of first grid point : " + gdsv.getLo1());
                ps.println("  Resolution & Component flags : " + gdsv.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                    Grid Units : " + gdsv.getGridUnits());
                ps.println("   Latitude of last grid point : " + gdsv.getLa2());
                ps.println("  Longitude of last grid point : " + gdsv.getLo2());
                ps.println("         i direction increment : " + gdsv.getDx());
                ps.println("                 Scanning mode : " + gdsv.getScanMode());
                if (gdtn == 41) {
                    ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                    ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                    break;
                }
                if (gdtn == 42 || gdtn != 43) break;
                ps.println("     Latitude of southern pole : " + gdsv.getSpLat());
                ps.println("    Longitude of southern pole : " + gdsv.getSpLon());
                break;
            }
            default: {
                ps.println("Unknown Grid Type : " + gdtn);
            }
        }
    }

    private static void printPDS(Grib1ProductDefinitionSection pds, PrintStream ps) {
        Grib1Pds pdsv = pds.getPdsVars();
        int center = pdsv.getCenter();
        int subCenter = pdsv.getSubCenter();
        ps.println("            Originating Center : " + center + " " + Grib1Tables.getCenter_idName(center));
        String sc = Grib1Tables.getSubCenter_idName(center, subCenter);
        ps.print("        Originating Sub-Center : " + subCenter);
        if (sc == null) {
            ps.println();
        } else {
            ps.println(" " + sc);
        }
        ps.println("            TimeRangeIndicator : " + pdsv.getTimeRangeIndicator());
        ps.println("            Parameter Category : -1 Meteorological Parameters");
        int pn = pdsv.getParameterNumber();
        GridParameter parameter = GribPDSParamTable.getParameter(center, subCenter, pdsv.getParameterTableVersion(), pn);
        if (parameter != null) {
            ps.println("                Parameter Name : " + pn + " " + parameter.getName() + " " + parameter.getDescription());
            ps.println("               Parameter Units : " + parameter.getUnit());
        }
        long refTime = pdsv.getReferenceTime();
        calendar.setTimeInMillis(refTime);
        ps.println("                Reference Time : " + dateFormat.format(calendar.getTime()));
        ps.println("                    Time Units : " + Grib1Tables.getTimeUnit(pdsv.getTimeUnit(), false));
        ps.println("          Time Range Indicator : " + Grib1Tables.getTimeRange(pdsv.getTimeRangeIndicator()));
        ps.println("                   Time 1 (P1) : " + pdsv.getP1());
        ps.println("                   Time 2 (P2) : " + pdsv.getP2());
        int tgp = pdsv.getGenProcessId();
        ps.println("       Generating Process Type : " + tgp + " " + Grib1Tables.getTypeGenProcessName(center, tgp));
        ps.println("                    Level Type : " + pds.getLevelType() + " " + pds.getLevelName());
        ps.println("                 Level Value 1 : " + pdsv.getLevelValue1());
        ps.println("                 Level Value 2 : " + pdsv.getLevelValue2());
        ps.println("                    GDS Exists : " + pdsv.gdsExists());
        ps.println("                    BMS Exists : " + pdsv.bmsExists());
    }

    public static void printPDS(Grib1Pds pdsv, Formatter f) {
        int center = pdsv.getCenter();
        int subCenter = pdsv.getSubCenter();
        f.format("            Originating Center : (%d) %s%n", center, Grib1Tables.getCenter_idName(center));
        f.format("        Originating Sub-Center : (%d) %s%n", subCenter, Grib1Tables.getSubCenter_idName(center, subCenter));
        f.format("               Parameter_table : center=%d subcenter=%d tableVersion=%d%n", center, subCenter, pdsv.getParameterTableVersion());
        int pn = pdsv.getParameterNumber();
        GribPDSParamTable parameter_table = GribPDSParamTable.getParameterTable(center, subCenter, pdsv.getParameterTableVersion());
        if (parameter_table != null) {
            GridParameter parameter = parameter_table.getParameter(pn);
            if (parameter != null) {
                f.format("                Parameter Name : %d %s %s%n", pn, parameter.getName(), parameter.getDescription());
                f.format("               Parameter Units : %s%n", parameter.getUnit());
            } else {
                f.format("               Parameter %d in table %d %d %d NOT FOUND%n", pn, center, subCenter, pdsv.getParameterTableVersion());
            }
        } else {
            f.format("               Parameter_table : %d %d %d NOT FOUND%n", center, subCenter, pdsv.getParameterTableVersion());
        }
        f.format("                Reference Time : %s%n", dateFormat.format(pdsv.getReferenceDate()));
        f.format("                    Time Units : %s%n", Grib1Tables.getTimeUnit(pdsv.getTimeUnit(), false));
        f.format("          Time Range Indicator : (%d) %s%n", pdsv.getTimeRangeIndicator(), Grib1Tables.getTimeRange(pdsv.getTimeRangeIndicator()));
        f.format("                   Time 1 (P1) : %s%n", pdsv.getP1());
        f.format("                   Time 2 (P2) : %s%n", pdsv.getP2());
        int tgp = pdsv.getGenProcessId();
        f.format("       Generating Process Type : (%d) %s%n", tgp, Grib1Tables.getTypeGenProcessName(center, tgp));
        f.format("                    Level Type : (%d) %s%n", pdsv.getLevelType1(), pdsv.getLevelName());
        f.format("                 Level Value 1 : %f%n", pdsv.getLevelValue1());
        f.format("                 Level Value 2 : %f%n", pdsv.getLevelValue2());
        f.format("                    GDS Exists : %s%n", pdsv.gdsExists());
        f.format("                    BMS Exists : %s%n", pdsv.bmsExists());
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

