/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionBitMap {
    private final long startingPosition;
    private final int bitMapIndicator;

    public Grib2SectionBitMap(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        int length = GribNumbers.int4(raf);
        int section = raf.read();
        if (section != 6) {
            throw new IllegalArgumentException("Not a GRIB-2 Bitmap section");
        }
        this.bitMapIndicator = raf.read();
        raf.seek(this.startingPosition + (long)length);
    }

    public Grib2SectionBitMap(long startingPosition, int bitMapIndicator) {
        this.startingPosition = startingPosition;
        this.bitMapIndicator = bitMapIndicator;
    }

    public int getBitMapIndicator() {
        return this.bitMapIndicator;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    byte[] getBitmap(RandomAccessFile raf) throws IOException {
        if (this.bitMapIndicator == 255) {
            return null;
        }
        if (this.bitMapIndicator != 0) {
            throw new UnsupportedOperationException("Grib2 Bit map section pre-defined (provided by center) = " + this.bitMapIndicator);
        }
        raf.seek(this.startingPosition);
        int length = GribNumbers.int4(raf);
        raf.skipBytes(2);
        byte[] data = new byte[length - 6];
        raf.readFully(data);
        return data;
    }
}

