/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Drs {
    public static Grib2Drs factory(int template, RandomAccessFile raf) throws IOException {
        switch (template) {
            case 0: {
                return new Type0(raf);
            }
            case 2: {
                return new Type2(raf);
            }
            case 3: {
                return new Type3(raf);
            }
            case 40: {
                return new Type40(raf);
            }
        }
        throw new UnsupportedOperationException("Unsupported DRS type = " + template);
    }

    public static class Type40
    extends Type0 {
        public int compressionMethod;
        public int compressionRatio;
        boolean hasSignedProblem = false;

        Type40(RandomAccessFile raf) throws IOException {
            super(raf);
            this.compressionMethod = raf.read();
            this.compressionRatio = raf.read();
        }

        public boolean hasSignedProblem() {
            return this.hasSignedProblem;
        }
    }

    public static class Type3
    extends Type2 {
        public int orderSpatial;
        public int descriptorSpatial;

        Type3(RandomAccessFile raf) throws IOException {
            super(raf);
            this.orderSpatial = raf.read();
            this.descriptorSpatial = raf.read();
        }
    }

    public static class Type2
    extends Type0 {
        public float secondaryMissingValue;
        public float primaryMissingValue;
        public int missingValueManagement;
        public int splittingMethod;
        public int numberOfGroups;
        public int referenceGroupWidths;
        public int bitsGroupWidths;
        public int referenceGroupLength;
        public int lengthIncrement;
        public int lengthLastGroup;
        public int bitsScaledGroupLength;

        Type2(RandomAccessFile raf) throws IOException {
            super(raf);
            this.splittingMethod = raf.read();
            this.missingValueManagement = raf.read();
            this.primaryMissingValue = raf.readFloat();
            this.secondaryMissingValue = raf.readFloat();
            this.numberOfGroups = GribNumbers.int4(raf);
            this.referenceGroupWidths = raf.read();
            this.bitsGroupWidths = raf.read();
            this.referenceGroupLength = GribNumbers.int4(raf);
            this.lengthIncrement = raf.read();
            this.lengthLastGroup = GribNumbers.int4(raf);
            this.bitsScaledGroupLength = raf.read();
        }
    }

    public static class Type0
    extends Grib2Drs {
        public float referenceValue;
        public int binaryScaleFactor;
        public int decimalScaleFactor;
        public int numberOfBits;
        public int originalType;

        Type0(RandomAccessFile raf) throws IOException {
            this.referenceValue = raf.readFloat();
            this.binaryScaleFactor = GribNumbers.int2(raf);
            this.decimalScaleFactor = GribNumbers.int2(raf);
            this.numberOfBits = raf.read();
            this.originalType = raf.read();
        }
    }
}

