/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.grib1.Grib1Iosp;
import ucar.nc2.iosp.IOServiceProvider;

public class Grib1TimePartition
extends TimePartition {
    private static final Logger logger = LoggerFactory.getLogger(Grib1TimePartition.class);

    Grib1TimePartition(String name, File directory, FeatureCollectionConfig.GribConfig tpc) {
        super(name, directory, tpc, true);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String groupName, String filename, FeatureCollectionConfig.GribConfig gribConfig) throws IOException {
        GribCollection.GroupHcs want = this.findGroupById(groupName);
        if (want == null) {
            return null;
        }
        Grib1Iosp iosp = new Grib1Iosp(want);
        iosp.setLookupTablePath(gribConfig.lookupTablePath);
        iosp.setParamTablePath(gribConfig.paramTablePath);
        iosp.setParamTable(gribConfig.paramTable);
        GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
        return new NetcdfDataset((NetcdfFile)ncfile);
    }

    @Override
    public ucar.nc2.dt.GridDataset getGridDataset(String groupName, String filename, FeatureCollectionConfig.GribConfig gribConfig) throws IOException {
        GribCollection.GroupHcs want = this.findGroupById(groupName);
        if (want == null) {
            return null;
        }
        Grib1Iosp iosp = new Grib1Iosp(want);
        iosp.setLookupTablePath(gribConfig.lookupTablePath);
        iosp.setParamTablePath(gribConfig.paramTablePath);
        iosp.setParamTable(gribConfig.paramTable);
        GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
        NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
        return new GridDataset(ncd);
    }
}

