/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.grib1.Grib1Iosp;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Iosp;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcGrib.class);
    private static final String COLLECTION = "collection";
    private static final String VARIABLES = "?metadata=variableMap";
    private static final boolean addLatest = false;
    private final FeatureCollectionConfig.GribConfig gribConfig;
    private final AtomicBoolean needsUpdate = new AtomicBoolean();
    private final AtomicBoolean needsProto = new AtomicBoolean();
    private boolean first = true;
    private DataFormatType format;
    private Map<Integer, ThreddsMetadata.Variable> map = null;
    private Grib1Customizer cust1 = null;
    private Grib2Customizer cust2 = null;

    public InvDatasetFcGrib(InvDatasetImpl parent, String name, String path, FeatureType featureType, FeatureCollectionConfig config) {
        super(parent, name, path, featureType, config);
        String errs;
        this.gribConfig = config.gribConfig;
        Formatter errlog = new Formatter();
        if (config.useIndexOnly) {
            this.dcm = TimePartitionCollection.fromExistingIndices((FeatureCollectionConfig)config, (Formatter)errlog);
        } else if (config.timePartition != null) {
            this.dcm = TimePartitionCollection.factory((FeatureCollectionConfig)config, (Formatter)errlog);
            this.dcm.setChangeChecker(GribIndex.getChangeChecker());
        } else {
            this.dcm = new MFileCollectionManager(config, errlog);
            this.dcm.setChangeChecker(GribIndex.getChangeChecker());
        }
        if (config.gribConfig != null) {
            this.dcm.putAuxInfo("gribConfig", (Object)config.gribConfig);
        }
        if ((errs = errlog.toString()).length() > 0) {
            logger.warn("{}: CollectionManager parse error = {} ", (Object)name, (Object)errs);
        }
        this.tmi.setDataType(FeatureType.GRID);
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CollectionManager.Force force) {
        if (this.first) {
            Object object = this.lock;
            synchronized (object) {
                this.format = this.getDataFormatType();
                this.firstInit();
                this.first = false;
            }
        }
        StateGrib localState = new StateGrib((StateGrib)this.state);
        try {
            this.updateCollection(localState, force);
        }
        catch (Throwable e) {
            logger.error("Fail to create/update collection", e);
            return;
        }
        this.makeTopDatasets(localState);
        localState.lastInvChange = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
        }
    }

    public void updateProto() {
        this.needsProto.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateGrib checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.format = this.getDataFormatType();
                this.firstInit();
                this.dcm.scanIfNeeded();
                this.first = false;
            } else if (!this.dcm.scanIfNeeded()) {
                return (StateGrib)this.state;
            }
            boolean tdsUsingTdm = !CollectionUpdater.INSTANCE.isTdm() && this.config.tdmConfig != null;
            CollectionManager.Force ff = tdsUsingTdm || this.config.updateConfig.isStatic() ? CollectionManager.Force.nocheck : CollectionManager.Force.test;
            StateGrib localState = new StateGrib((StateGrib)this.state);
            this.updateCollection(localState, ff);
            this.makeTopDatasets(localState);
            localState.lastInvChange = System.currentTimeMillis();
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
            return localState;
        }
    }

    private void updateCollection(StateGrib localState, CollectionManager.Force force) throws IOException {
        if (this.config.timePartition != null) {
            TimePartition previous = localState.timePartition;
            localState.timePartition = TimePartition.factory(this.format == DataFormatType.GRIB1, (TimePartitionCollection)this.dcm, force, new Formatter());
            localState.gribCollection = null;
            if (previous != null) {
                previous.close();
            }
            logger.debug("{}: TimePartition object was recreated", (Object)this.getName());
        } else {
            GribCollection previous = localState.gribCollection;
            localState.gribCollection = GribCollection.factory(this.format == DataFormatType.GRIB1, this.dcm, force, new Formatter());
            localState.timePartition = null;
            if (previous != null) {
                previous.close();
            }
            logger.debug("{}: GribCollection object was recreated", (Object)this.getName());
        }
    }

    private void makeTopDatasets(StateGrib localState) {
        ArrayList<Object> datasets = new ArrayList<Object>();
        if (localState.timePartition == null) {
            ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(localState.gribCollection.getGroups());
            Collections.sort(groups);
            boolean isSingleGroup = groups.size() == 1;
            for (GribCollection.GroupHcs group : groups) {
                String dpath;
                String groupId;
                InvDatasetImpl ds;
                if (isSingleGroup) {
                    ds = new InvDatasetImpl((InvDataset)this, this.getName());
                    groupId = null;
                    dpath = this.getPath() + "/" + COLLECTION;
                } else {
                    ds = new InvDatasetImpl((InvDataset)this, group.getDescription());
                    groupId = group.getId();
                    dpath = this.getPath() + "/" + groupId + "/" + COLLECTION;
                }
                ds.setUrlPath(dpath);
                ds.setID(dpath);
                ds.tmi.addVariableMapLink(this.makeMetadataLink(dpath, VARIABLES));
                this.addFileDatasets(ds, groupId);
                ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
                CalendarDateRange cdr = this.extractCalendarDateRange(group);
                if (cdr != null) {
                    ds.tmi.setTimeCoverage(cdr);
                }
                ds.finish();
                datasets.add(ds);
            }
        } else {
            InvCatalogRef ds = new InvCatalogRef((InvDatasetImpl)this, COLLECTION, this.getCatalogHref(COLLECTION));
            ds.finish();
            datasets.add(ds);
            for (TimePartition.Partition dc : localState.timePartition.getPartitions()) {
                String dname = dc.getName();
                ds = new InvCatalogRef((InvDatasetImpl)this, dname, this.getCatalogHref(dname));
                ds.finish();
                datasets.add(ds);
            }
        }
        localState.datasets = datasets;
        this.datasets = datasets;
        this.finish();
    }

    private void addFileDatasets(InvDatasetImpl parent, String prefix) {
        String name = prefix == null ? "files" : prefix + "/" + "files";
        InvCatalogRef ds = new InvCatalogRef((InvDatasetImpl)this, "files", this.getCatalogHref(name));
        ds.finish();
        parent.addDataset((InvDatasetImpl)ds);
    }

    public InvCatalogImpl makeCatalog(String match, String orgPath, URI baseURI) {
        StateGrib localState;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(baseURI, localState);
                main.addService(this.virtualService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
                main.finish();
                return main;
            }
            if (localState.timePartition == null) {
                GribCollection.GroupHcs group;
                String[] path = match.split("/");
                if (path.length == 1 && path[0].equals("files")) {
                    group = localState.gribCollection.getGroup(0);
                } else {
                    if (path.length < 2) {
                        return null;
                    }
                    group = localState.gribCollection.findGroupById(path[0]);
                }
                if (group != null) {
                    return this.makeFilesCatalog(localState.gribCollection, group, baseURI, localState);
                }
            } else {
                if (match.equals(COLLECTION)) {
                    return this.makeGribCollectionCatalog(localState.timePartition, baseURI, localState);
                }
                TimePartition.Partition tpp = localState.timePartition.getPartitionByName(match);
                if (tpp != null) {
                    GribCollection gc = tpp.getGribCollection();
                    InvCatalogImpl result = this.makeGribCollectionCatalog(gc, baseURI, localState);
                    gc.close();
                    return result;
                }
                String[] path = match.split("/");
                if (path.length < 2) {
                    return null;
                }
                tpp = localState.timePartition.getPartitionByName(path[0]);
                if (tpp != null) {
                    InvCatalogImpl result;
                    GribCollection gc = tpp.getGribCollection();
                    if (path[1].equals("files")) {
                        GribCollection.GroupHcs group = gc.getGroup(0);
                        result = this.makeFilesCatalog(gc, group, baseURI, localState);
                    } else {
                        GribCollection.GroupHcs group = gc.findGroupById(path[1]);
                        if (group == null) {
                            return null;
                        }
                        result = this.makeFilesCatalog(gc, group, baseURI, localState);
                    }
                    gc.close();
                    return result;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, (Throwable)e);
        }
        return null;
    }

    private InvCatalogImpl makeGribCollectionCatalog(GribCollection gribCollection, URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        String collectionName = gribCollection.getName();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(collectionName));
        InvCatalogImpl partCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl((InvDatasetImpl)this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(collectionName);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        partCatalog.addDataset(top);
        partCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(gribCollection.getGroups());
        Collections.sort(groups);
        boolean isSingleGroup = groups.size() == 1;
        for (GribCollection.GroupHcs group : groups) {
            String cname;
            String dpath;
            InvDatasetImpl ds;
            String groupId = group.getId();
            if (isSingleGroup) {
                ds = new InvDatasetImpl((InvDataset)this, collectionName);
                dpath = this.path + "/" + collectionName + "/" + COLLECTION;
                cname = collectionName;
            } else {
                ds = new InvDatasetImpl((InvDataset)this, group.getDescription());
                dpath = this.path + "/" + collectionName + "/" + groupId;
                cname = collectionName + "/" + groupId;
            }
            ds.setUrlPath(dpath);
            ds.setID(dpath);
            if (!(gribCollection instanceof TimePartition)) {
                this.addFileDatasets(ds, cname);
            }
            ds.tmi.addVariableMapLink(this.makeMetadataLink(dpath, VARIABLES));
            ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
            CalendarDateRange cdr = this.extractCalendarDateRange(group);
            if (cdr != null) {
                ds.tmi.setTimeCoverage(cdr);
            }
            ds.finish();
            top.addDataset(ds);
        }
        partCatalog.finish();
        return partCatalog;
    }

    private InvCatalogImpl makeFilesCatalog(GribCollection gc, GribCollection.GroupHcs group, URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref("files"));
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl((InvDatasetImpl)this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName("files");
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        result.addDataset(top);
        result.addService(this.orgService);
        top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        boolean isSingleGroup = gc.getGroups().size() == 1;
        List<String> filenames = isSingleGroup ? gc.getFilenames() : group.getFilenames();
        for (String f : filenames) {
            if (!f.startsWith(this.topDirectory)) {
                logger.warn("File {} doesnt start with topDir {}", (Object)f, (Object)this.topDirectory);
            }
            String fname = f.substring(this.topDirectory.length() + 1);
            String path = "files/" + fname;
            InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, fname);
            ds.setUrlPath(this.path + "/" + path);
            ds.setID(id + "/" + path);
            ds.tmi.addVariableMapLink(this.makeMetadataLink(this.path + "/" + path, VARIABLES));
            File file = new File(f);
            ds.tm.setDataSize((double)file.length());
            ds.finish();
            top.addDataset(ds);
        }
        result.finish();
        return result;
    }

    private String makeMetadataLink(String datasetName, String metadata) {
        String result = context + "/medadata/" + datasetName + metadata;
        return result;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollection.GroupHcs group) {
        GdsHorizCoordSys gdsCoordSys = group.hcs;
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox((Projection)gdsCoordSys.proj, (double)gdsCoordSys.getStartX(), (double)gdsCoordSys.getStartY(), (double)gdsCoordSys.getEndX(), (double)gdsCoordSys.getEndY());
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        if (llbb != null) {
            gc.setBoundingBox(llbb);
        }
        if (group.hcs.isLatLon()) {
            gc.setLonResolution(gdsCoordSys.dx);
            gc.setLatResolution(gdsCoordSys.dy);
        }
        return gc;
    }

    private CalendarDateRange extractCalendarDateRange(GribCollection.GroupHcs group) {
        TimeCoord max = null;
        for (TimeCoord tc : group.timeCoords) {
            if (tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
            max = tc;
        }
        if (max == null) {
            for (TimeCoord tc : group.timeCoords) {
                if (!tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
                max = tc;
            }
        }
        return max == null ? null : max.getCalendarRange();
    }

    public GridDataset getGridDataset(String matchPath) throws IOException {
        GridDataset result = super.getGridDataset(matchPath);
        if (result != null) {
            return result;
        }
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        DatasetParse dp = this.parse(matchPath, localState);
        if (dp == null) {
            return null;
        }
        if (localState.timePartition == null) {
            return localState.gribCollection.getGridDataset(dp.group, dp.filename, this.gribConfig);
        }
        if (dp.partition != null) {
            return dp.partition.getGribCollection().getGridDataset(dp.group, dp.filename, this.gribConfig);
        }
        return localState.timePartition.getGridDataset(dp.group, dp.filename, this.gribConfig);
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        NetcdfDataset result = super.getNetcdfDataset(matchPath);
        if (result != null) {
            return result;
        }
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        DatasetParse dp = this.parse(matchPath, localState);
        if (dp == null) {
            return null;
        }
        if (localState.timePartition == null) {
            return localState.gribCollection.getNetcdfDataset(dp.group, dp.filename, this.gribConfig);
        }
        if (dp.partition != null) {
            return dp.partition.getGribCollection().getNetcdfDataset(dp.group, dp.filename, this.gribConfig);
        }
        return localState.timePartition.getNetcdfDataset(dp.group, dp.filename, this.gribConfig);
    }

    private DatasetParse parse(String matchPath, StateGrib localState) {
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        if (paths.length == 2 && paths[0].equals("files")) {
            return new DatasetParse(paths[1]);
        }
        if (localState.timePartition == null) {
            boolean isCollection = paths[0].equals(COLLECTION);
            String groupName = isCollection ? localState.gribCollection.getGroup(0).getId() : paths[0];
            return new DatasetParse(null, groupName, isCollection);
        }
        if (paths.length == 2) {
            boolean isCollection = paths[1].equals(COLLECTION);
            TimePartition.Partition tpp = localState.timePartition.getPartitionByName(paths[0]);
            String name = localState.timePartition.getName();
            if (isCollection) {
                if (tpp != null) {
                    return new DatasetParse(tpp, localState.timePartition.getGroup(0).getId(), true);
                }
                if (paths[0].equals(name)) {
                    return new DatasetParse(null, localState.timePartition.getGroup(0).getId(), true);
                }
            } else {
                if (tpp != null) {
                    return new DatasetParse(tpp, paths[1], false);
                }
                return new DatasetParse(null, paths[1], true);
            }
        }
        return null;
    }

    private ThreddsMetadata.Variables extractThreddsVariables(GribCollection gribCollection, GribCollection.GroupHcs group) {
        ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables(this.format.toString());
        for (GribCollection.VariableIndex vindex : group.varIndex) {
            vars.addVariable(this.extractThreddsVariables(gribCollection, vindex));
        }
        vars.sort();
        return vars;
    }

    public ThreddsMetadata.Variable extractThreddsVariables(GribCollection gc, GribCollection.VariableIndex vindex) {
        String paramCategory;
        ThreddsMetadata.Variable tv;
        if (this.map == null) {
            this.map = new HashMap<Integer, ThreddsMetadata.Variable>(100);
        }
        if ((tv = this.map.get(vindex.cdmHash)) != null) {
            return tv;
        }
        tv = new ThreddsMetadata.Variable();
        if (gc.isGrib1()) {
            if (this.cust1 == null) {
                this.cust1 = Grib1Customizer.factory(gc.getCenter(), gc.getSubcenter(), gc.getLocal(), null);
            }
            tv.setName(this.cust1.makeVariableName(gc, vindex));
            tv.setDescription(Grib1Iosp.makeVariableLongName(this.cust1, gc, vindex));
            tv.setUnits(Grib1Iosp.makeVariableUnits(this.cust1, gc, vindex));
            tv.setVocabularyId("1-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
            this.map.put(vindex.cdmHash, tv);
            return tv;
        }
        if (this.cust2 == null) {
            this.cust2 = Grib2Customizer.factory(gc.getCenter(), gc.getSubcenter(), gc.getMaster(), gc.getLocal());
        }
        tv.setName(Grib2Iosp.makeVariableName(this.cust2, gc, vindex));
        tv.setDescription(Grib2Iosp.makeVariableLongName(this.cust2, vindex));
        tv.setUnits(Grib2Iosp.makeVariableUnits(this.cust2, vindex));
        tv.setVocabularyId("2-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
        String paramDisc = this.cust2.getTableValue("0.0", vindex.discipline);
        if (paramDisc == null) {
            paramDisc = "Unknown";
        }
        if ((paramCategory = this.cust2.getTableValue("4.1." + vindex.discipline, vindex.category)) == null) {
            paramCategory = "Unknown";
        }
        String paramName = this.cust2.getVariableName(vindex.discipline, vindex.category, vindex.parameter);
        tv.setVocabularyName(paramDisc + " / " + paramCategory + " / " + paramName);
        this.map.put(vindex.cdmHash, tv);
        return tv;
    }

    private class Vhash {
        int center;
        int subcenter;
        int local;
        int master;
        int discipline;
        int category;
        int param;

        private Vhash() {
        }
    }

    private class DatasetParse {
        TimePartition.Partition partition;
        String group;
        String filename;
        boolean isCollection;
        boolean isFile;

        private DatasetParse(TimePartition.Partition tpp, String group, boolean collection) {
            this.partition = tpp;
            this.group = group;
            this.isCollection = collection;
        }

        private DatasetParse(String filename) {
            this.filename = filename;
            this.isFile = true;
        }
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        TimePartition timePartition;
        GribCollection gribCollection;

        protected StateGrib(StateGrib from) {
            super((InvDatasetFeatureCollection)InvDatasetFcGrib.this, (InvDatasetFeatureCollection.State)from);
            if (from != null) {
                this.timePartition = from.timePartition;
                this.gribCollection = from.gribCollection;
            }
        }
    }
}

