/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.util.Misc;

public class VertCoord
implements Comparable {
    private String name;
    private String units;
    private int id;
    private double[] values1;
    private double[] values2;

    VertCoord() {
    }

    VertCoord(CoordinateAxis1D axis) {
        this.name = axis.getFullName();
        this.units = axis.getUnitsString();
        int n = (int)axis.getSize();
        if (axis.isInterval()) {
            this.values1 = axis.getBound1();
            this.values2 = axis.getBound2();
        } else {
            this.values1 = new double[n];
            int i = 0;
            while ((long)i < axis.getSize()) {
                this.values1[i] = axis.getCoordValue(i);
                ++i;
            }
        }
    }

    VertCoord(VertCoord vc) {
        this.name = vc.getName();
        this.units = vc.getUnits();
        this.id = vc.id;
        this.values1 = (double[])vc.getValues1().clone();
        this.values2 = vc.getValues2() == null ? null : (double[])vc.getValues2().clone();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public double[] getValues1() {
        return this.values1;
    }

    public void setValues1(double[] values) {
        this.values1 = values;
    }

    public double[] getValues2() {
        return this.values2;
    }

    public void setValues2(double[] values) {
        this.values2 = values;
    }

    public int getSize() {
        return this.values1.length;
    }

    public boolean equalsData(VertCoord other) {
        int i;
        if (this.values1.length != other.values1.length) {
            return false;
        }
        for (i = 0; i < this.values1.length; ++i) {
            if (Misc.closeEnough(this.values1[i], other.values1[i])) continue;
            return false;
        }
        if (this.values2 == null && other.values2 == null) {
            return true;
        }
        if (this.values2 == null || other.values2 == null) {
            return false;
        }
        if (this.values2.length != other.values2.length) {
            return false;
        }
        for (i = 0; i < this.values2.length; ++i) {
            if (Misc.closeEnough(this.values2[i], other.values2[i])) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        VertCoord other = (VertCoord)o;
        return this.name.compareTo(other.name);
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("values=", new Object[0]);
        if (this.values2 == null) {
            for (double val : this.values1) {
                out.format("%5f, ", val);
            }
        } else {
            for (int i = 0; i < this.values1.length; ++i) {
                out.format("(%6.3f,%6.3f) ", this.values1[i], this.values2[i]);
            }
        }
        out.format("; name=%s", this.name);
        return out.toString();
    }

    public static VertCoord findVertCoord(List<VertCoord> vertCoords, VertCoord want) {
        if (want == null) {
            return null;
        }
        for (VertCoord vc : vertCoords) {
            if (!want.equalsData(vc)) continue;
            return vc;
        }
        VertCoord result = new VertCoord(want);
        vertCoords.add(result);
        return result;
    }

    public static void normalize(VertCoord result, List<VertCoord> vcList) {
        HashSet<LevelCoord> valueSet = new HashSet<LevelCoord>();
        VertCoord.addValues(valueSet, result.getValues1(), result.getValues2());
        for (VertCoord vc : vcList) {
            VertCoord.addValues(valueSet, vc.getValues1(), vc.getValues2());
        }
        List<LevelCoord> valueList = Arrays.asList(valueSet.toArray(new LevelCoord[valueSet.size()]));
        Collections.sort(valueList);
        double[] values1 = new double[valueList.size()];
        double[] values2 = new double[valueList.size()];
        boolean has_values2 = false;
        for (int i = 0; i < valueList.size(); ++i) {
            LevelCoord lc = valueList.get(i);
            values1[i] = lc.value1;
            values2[i] = lc.value2;
            if (lc.value2 == 0.0) continue;
            has_values2 = true;
        }
        result.setValues1(values1);
        if (has_values2) {
            result.setValues2(values2);
        }
    }

    private static void addValues(Set<LevelCoord> valueSet, double[] values1, double[] values2) {
        for (int i = 0; i < values1.length; ++i) {
            double val2 = values2 == null ? 0.0 : values2[i];
            valueSet.add(new LevelCoord(values1[i], val2));
        }
    }

    @Immutable
    private static class LevelCoord
    implements Comparable {
        final double mid;
        final double value1;
        final double value2;

        LevelCoord(double value1, double value2) {
            this.value1 = value1;
            this.value2 = value2;
            this.mid = value2 == 0.0 ? value1 : (value1 + value2) / 2.0;
        }

        public int compareTo(Object o) {
            LevelCoord other = (LevelCoord)o;
            if (this.mid < other.mid) {
                return -1;
            }
            if (this.mid > other.mid) {
                return 1;
            }
            return 0;
        }

        public boolean equals2(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof LevelCoord)) {
                return false;
            }
            LevelCoord other = (LevelCoord)oo;
            return Misc.closeEnough(this.value1, other.value1) && Misc.closeEnough(this.value2, other.value2);
        }

        public int hashCode2() {
            return (int)(this.value1 * 100000.0 + this.value2 * 100.0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LevelCoord that = (LevelCoord)o;
            if (!Misc.closeEnough(that.value1, this.value1)) {
                return false;
            }
            return Misc.closeEnough(that.value2, this.value2);
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value1);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.value2);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

