/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.wmo;

import ucar.unidata.util.StringUtil2;

public class Util {
    public static String cleanUnit(String unit) {
        if (unit == null) {
            return null;
        }
        if (unit.equalsIgnoreCase("Proportion") || unit.equalsIgnoreCase("Numeric")) {
            unit = "";
        } else if (unit.equalsIgnoreCase("-")) {
            unit = "";
        } else if (unit.startsWith("degree") && unit.endsWith("true")) {
            unit = unit.replace(' ', '_');
        } else if (!unit.contains(" table ")) {
            if (unit.startsWith("/")) {
                unit = "1" + unit;
            }
            unit = unit.trim();
            unit = StringUtil2.remove(unit, "**");
            StringBuilder sb = new StringBuilder(unit);
            StringUtil2.removeAll(sb, "^[]");
            StringUtil2.replace(sb, ' ', ".");
            StringUtil2.replace(sb, '*', ".");
            unit = sb.toString();
        }
        return unit;
    }

    public static String cleanName(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.indexOf("(see");
        if (pos < 0) {
            pos = name.indexOf("(See");
        }
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        name = StringUtil2.replace(name, '/', "-");
        StringBuilder sb = new StringBuilder(name);
        StringUtil2.replace(sb, '+', "plus");
        StringUtil2.removeAll(sb, ".;,=[]()/*\"");
        return StringUtil2.collapseWhitespace(sb.toString().trim());
    }

    public static String cleanupDescription(String desc) {
        if (desc == null) {
            return null;
        }
        int pos = desc.indexOf("(see");
        if (pos > 0) {
            desc = desc.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder(desc.trim());
        StringUtil2.removeAll(sb, ".;,=[]()/*");
        return sb.toString().trim();
    }

    public static boolean equivilantName(String name1, String name2) {
        if (name1 == null || name2 == null) {
            return name1 == name2;
        }
        String name1clean = Util.cleanName(name1).toLowerCase();
        String name2clean = Util.cleanName(name2).toLowerCase();
        if (name1.equals(name2)) {
            return true;
        }
        StringBuilder sb1 = new StringBuilder(name1clean);
        StringUtil2.removeAll(sb1, " -\u2019'");
        StringBuilder sb2 = new StringBuilder(name2clean);
        StringUtil2.removeAll(sb2, " -\u2019'");
        return sb1.toString().equals(sb2.toString());
    }

    public static boolean isUnitless(String unit) {
        if (unit == null) {
            return true;
        }
        String munge = unit.toLowerCase().trim();
        return (munge = StringUtil2.remove(munge, 40)).length() == 0 || munge.startsWith("numeric") || munge.startsWith("non-dim") || munge.startsWith("see") || munge.startsWith("proportion") || munge.startsWith("code") || munge.startsWith("0=") || munge.equals("1");
    }

    public static void main(String[] args) {
        System.out.printf("clean '/s' = %s%n", Util.cleanUnit("/s"));
    }
}

