/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.tools;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.UrlEscapers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.util.Format;

public class DatasetHtmlWriter {
    private Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
    private Escaper urlPathEscaper = UrlEscapers.urlPathSegmentEscaper();
    private Escaper urlParamEscaper = UrlEscapers.urlFormParameterEscaper();

    /*
     * WARNING - void declaration
     */
    public void writeHtmlDescription(Formatter out, Dataset ds, boolean complete, boolean isServer, boolean datasetEvents, boolean catrefEvents, boolean resolveRelativeUrls) {
        DateRange tc;
        ThreddsMetadata.GeospatialCoverage geospatialCoverage;
        List<ThreddsMetadata.VariableGroup> list;
        List<ThreddsMetadata.Source> list2;
        List<ThreddsMetadata.Source> list3;
        List<ThreddsMetadata.Vocab> list4;
        List<DateType> list5;
        List<ThreddsMetadata.Vocab> list6;
        List<ThreddsMetadata.Contributor> list7;
        List<Access> access;
        if (ds == null) {
            return;
        }
        if (complete) {
            out.format("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"%n", new Object[0]);
            out.format("        \"http://www.w3.org/TR/html4/loose.dtd\">%n", new Object[0]);
            out.format("<html>%n", new Object[0]);
            out.format("<head>%n", new Object[0]);
            out.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">%n", new Object[0]);
            out.format("</head>%n", new Object[0]);
            out.format("<body>%n", new Object[0]);
        }
        out.format("<h2>Dataset: %s</h2>%n<ul>", ds.getName());
        if (ds.getDataFormatName() != null) {
            out.format(" <li><em>Data format: </em>%s</li>%n", this.htmlEscaper.escape(ds.getDataFormatName()));
        }
        if (ds.getDataSize() > 0L) {
            out.format(" <li><em>Data size: </em>%s</li>%n", Format.formatByteSize(ds.getDataSize()));
        }
        if (ds.getFeatureTypeName() != null) {
            out.format(" <li><em>Feature type: </em>%s</li>%n", this.htmlEscaper.escape(ds.getFeatureTypeName()));
        }
        if (ds.getCollectionType() != null) {
            out.format(" <li><em>Collection type: </em>%s</li>%n", this.htmlEscaper.escape(ds.getCollectionType()));
        }
        if (ds.isHarvest()) {
            out.format(" <li><em>Harvest:</em> true</li>%n", new Object[0]);
        }
        if (ds.getAuthority() != null) {
            out.format(" <li><em>Naming Authority: </em>%s</li>%n%n", this.htmlEscaper.escape(ds.getAuthority()));
        }
        if (ds.getId() != null) {
            out.format(" <li><em>ID: </em>%s</li>%n", this.htmlEscaper.escape(ds.getId()));
        }
        if (ds.getRestrictAccess() != null) {
            out.format(" <li><em>RestrictAccess: </em>%s</li>%n", this.htmlEscaper.escape(ds.getRestrictAccess()));
        }
        if (ds instanceof CatalogRef) {
            Object href;
            CatalogRef catref = (CatalogRef)ds;
            Object object = href = resolveRelativeUrls | catrefEvents ? this.resolve(ds, catref.getXlinkHref()) : catref.getXlinkHref();
            if (catrefEvents) {
                href = "catref:" + (String)href;
            }
            out.format(" <li><em>CatalogRef: </em>%s</li>%n", this.makeHref((String)href, null, null));
        }
        out.format("</ul>%n", new Object[0]);
        List<Documentation> docs = ds.getDocumentation();
        if (docs.size() > 0) {
            out.format("<h3>Documentation:</h3>%n<ul>%n", new Object[0]);
            for (Documentation documentation : docs) {
                String string = documentation.getType() == null ? "" : "<strong>" + this.htmlEscaper.escape(documentation.getType()) + ":</strong> ";
                String string2 = documentation.getInlineContent();
                if (string2 != null && string2.length() > 0) {
                    out.format(" <li>%s %s</li>%n", string, this.htmlEscaper.escape(string2));
                }
                if (!documentation.hasXlink()) continue;
                out.format(" <li>%s %s</li>%n", string, this.makeHref(documentation.getXlinkHref(), null, documentation.getXlinkTitle()));
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((access = ds.getAccess()).size() > 0) {
            out.format("<h3>Access:</h3>%n<ol>%n", new Object[0]);
            for (Access access2 : access) {
                void var14_42;
                void var13_28;
                Service service = access2.getService();
                String string = resolveRelativeUrls || datasetEvents ? access2.getStandardUrlName() : access2.getUnresolvedUrlName();
                Object var14_43 = null;
                if (datasetEvents) {
                    String string3 = "dataset:" + string;
                }
                ServiceType serviceType = service.getType();
                if (isServer && serviceType != null) {
                    switch (serviceType) {
                        case OPENDAP: 
                        case DODS: {
                            void var13_31;
                            String string4 = (String)var13_31 + ".html";
                            break;
                        }
                        case DAP4: {
                            void var13_31;
                            String string5 = (String)var13_31 + ".dmr.xml";
                            break;
                        }
                        case WCS: {
                            String string6 = "service=WCS&version=1.0.0&request=GetCapabilities";
                            break;
                        }
                        case WMS: {
                            String string7 = "service=WMS&version=1.3.0&request=GetCapabilities";
                            break;
                        }
                        case NCML: 
                        case UDDC: 
                        case ISO: {
                            void var16_64;
                            String string8 = ds.getCatalogUrl();
                            String string9 = ds.getId();
                            if (string8 == null || string9 == null) break;
                            if (string8.indexOf(35) > 0) {
                                String string10 = string8.substring(0, string8.lastIndexOf(35));
                            }
                            String string11 = "catalog=" + this.urlParamEscaper.escape((String)var16_64) + "&dataset=" + this.urlParamEscaper.escape(string9);
                            break;
                        }
                        case NetcdfSubset: {
                            void var13_31;
                            String string12 = (String)var13_31 + "/dataset.html";
                            break;
                        }
                        case CdmRemote: {
                            String string13 = "req=cdl";
                            break;
                        }
                        case CdmrFeature: {
                            String string14 = "req=form";
                        }
                    }
                }
                out.format(" <li> <b>%s: </b>%s</li>%n", service.getServiceTypeName(), this.makeHref((String)var13_28, (String)var14_42, null));
            }
            out.format("</ol>%n", new Object[0]);
        }
        if ((list7 = ds.getContributors()).size() > 0) {
            out.format("<h3>Contributors:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Contributor contributor : list7) {
                String string = contributor.getRole() == null ? "" : "<strong> (" + this.htmlEscaper.escape(contributor.getRole()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", this.htmlEscaper.escape(contributor.getName()), string);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((list6 = ds.getKeywords()).size() > 0) {
            out.format("<h3>Keywords:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Vocab vocab : list6) {
                String string = vocab.getVocabulary() == null ? "" : " <strong>(" + this.htmlEscaper.escape(vocab.getVocabulary()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", this.htmlEscaper.escape(vocab.getText()), string);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((list5 = ds.getDates()).size() > 0) {
            out.format("<h3>Dates:</h3>%n<ul>%n", new Object[0]);
            for (DateType dateType : list5) {
                String string = dateType.getType() == null ? "" : " <strong>(" + this.htmlEscaper.escape(dateType.getType()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", this.htmlEscaper.escape(dateType.getText()), string);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((list4 = ds.getProjects()).size() > 0) {
            out.format("<h3>Projects:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Vocab vocab : list4) {
                String string = vocab.getVocabulary() == null ? "" : " <strong>(" + this.htmlEscaper.escape(vocab.getVocabulary()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", this.htmlEscaper.escape(vocab.getText()), string);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((list3 = ds.getCreators()).size() > 0) {
            out.format("<h3>Creators:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Source source : list3) {
                out.format(" <li><strong>%s</strong><ul>%n", this.htmlEscaper.escape(source.getName()));
                out.format(" <li><em>email: </em>%s</li>%n", this.htmlEscaper.escape(source.getEmail()));
                if (source.getUrl() != null) {
                    String string = resolveRelativeUrls ? this.makeHrefResolve(ds, source.getUrl(), null) : this.makeHref(source.getUrl(), null, null);
                    out.format(" <li> <em>%s</em></li>%n", string);
                }
                out.format(" </ul></li>%n", new Object[0]);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((list2 = ds.getPublishers()).size() > 0) {
            out.format("<h3>Publishers:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Source source : list2) {
                out.format(" <li><strong>%s</strong><ul>%n", this.htmlEscaper.escape(source.getName()));
                out.format(" <li><em>email: </em>%s%n", this.htmlEscaper.escape(source.getEmail()));
                if (source.getUrl() != null) {
                    String urlLink = resolveRelativeUrls ? this.makeHrefResolve(ds, source.getUrl(), null) : this.makeHref(source.getUrl(), null, null);
                    out.format(" <li> <em>%s</em></li>%n", urlLink);
                }
                out.format(" </ul>%n", new Object[0]);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((list = ds.getVariables()).size() > 0) {
            out.format("<h3>Variables:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.VariableGroup t : list) {
                Object vocabLink;
                out.format("<li><em>Vocabulary</em> [", new Object[0]);
                if (t.getVocabUri() != null) {
                    ThreddsMetadata.UriResolved uri = t.getVocabUri();
                    vocabLink = resolveRelativeUrls ? this.makeHref(uri.resolved.toString(), null, t.getVocabulary()) : this.makeHref(uri.href, null, t.getVocabulary());
                    out.format((String)vocabLink, new Object[0]);
                } else {
                    out.format(this.htmlEscaper.escape(t.getVocabulary()), new Object[0]);
                }
                out.format("]:%n<ul>%n", new Object[0]);
                List<ThreddsMetadata.Variable> vlist = t.getVariableList();
                if (vlist.size() > 0) {
                    vocabLink = vlist.iterator();
                    while (vocabLink.hasNext()) {
                        ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vocabLink.next();
                        String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                        out.format(" <li><strong>%s</strong> = ", this.htmlEscaper.escape(v.getName() + units));
                        if (v.getDescription() != null) {
                            out.format(" <i>%s</i> = ", this.htmlEscaper.escape(v.getDescription()));
                        }
                        if (v.getVocabularyName() != null) {
                            out.format("%s", this.htmlEscaper.escape(v.getVocabularyName()));
                        }
                        out.format("%n", new Object[0]);
                    }
                }
                out.format("</ul>%n", new Object[0]);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if (ds.getVariableMapLink() != null) {
            out.format("<h3>Variables:</h3>%n", new Object[0]);
            ThreddsMetadata.UriResolved uriResolved = ds.getVariableMapLink();
            out.format("<ul><li>%s</li></ul>%n", this.makeHref(uriResolved.resolved.toASCIIString(), null, "VariableMap"));
        }
        if ((geospatialCoverage = ds.getGeospatialCoverage()) != null) {
            List<ThreddsMetadata.Vocab> nlist;
            out.format("<h3>GeospatialCoverage:</h3>%n<ul>%n", new Object[0]);
            out.format(" <li><em> Longitude: </em> %s</li>%n", this.rangeString(geospatialCoverage.getEastWestRange()));
            out.format(" <li><em> Latitude: </em> %s</li>%n", this.rangeString(geospatialCoverage.getNorthSouthRange()));
            if (geospatialCoverage.getUpDownRange() != null) {
                out.format(" <li><em> Altitude: </em> %s (positive is <strong>%s)</strong></li>%n", this.rangeString(geospatialCoverage.getUpDownRange()), geospatialCoverage.getZPositive());
            }
            if ((nlist = geospatialCoverage.getNames()) != null && nlist.size() > 0) {
                out.format(" <li><em>  Names: </em> <ul>%n", new Object[0]);
                for (ThreddsMetadata.Vocab elem : nlist) {
                    out.format(" <li>%s</li>%n", this.htmlEscaper.escape(elem.getText()));
                }
                out.format(" </ul>%n", new Object[0]);
            }
            out.format(" </ul>%n", new Object[0]);
        }
        if ((tc = ds.getTimeCoverage()) != null) {
            TimeDuration resolution;
            Iterator<ThreddsMetadata.MetadataOther> duration;
            DateType end;
            out.format("<h3>TimeCoverage:</h3>%n<ul>%n", new Object[0]);
            DateType start = tc.getStart();
            if (start != null) {
                out.format(" <li><em>  Start: </em> %s</li>%n", start.toString());
            }
            if ((end = tc.getEnd()) != null) {
                out.format(" <li><em>  End: </em> %s</li>%n", end.toString());
            }
            if ((duration = tc.getDuration()) != null) {
                out.format(" <li><em>  Duration: </em> %s</li>%n", this.htmlEscaper.escape(((TimeDuration)((Object)duration)).toString()));
            }
            if ((resolution = tc.getResolution()) != null) {
                out.format(" <li><em>  Resolution: </em> %s</li>%n", this.htmlEscaper.escape(resolution.toString()));
            }
            out.format(" </ul>%n", new Object[0]);
        }
        List<ThreddsMetadata.MetadataOther> metadata = ds.getMetadataOther();
        boolean gotSomeMetadata = false;
        for (ThreddsMetadata.MetadataOther m : metadata) {
            if (m.getXlinkHref() == null) continue;
            gotSomeMetadata = true;
        }
        if (gotSomeMetadata) {
            out.format("<h3>Metadata:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.MetadataOther m : metadata) {
                String type;
                String string = type = m.getType() == null ? "" : m.getType();
                if (m.getXlinkHref() == null) continue;
                String title = m.getTitle() == null ? "Type " + type : m.getTitle();
                String mdLink = resolveRelativeUrls ? this.makeHrefResolve(ds, m.getXlinkHref(), title) : this.makeHref(m.getXlinkHref(), null, title);
                out.format(" <li> %s</li>%n", mdLink);
            }
            out.format("</ul>%n", new Object[0]);
        }
        List<Property> propsOrg = ds.getProperties();
        ArrayList<Property> props = new ArrayList<Property>(ds.getProperties().size());
        for (Property p : propsOrg) {
            if (p.getName().startsWith("viewer")) continue;
            props.add(p);
        }
        if (props.size() > 0) {
            out.format("<h3>Properties:</h3>%n<ul>%n", new Object[0]);
            for (Property p : props) {
                if (p.getName().equals("attachments")) {
                    String attachLink = resolveRelativeUrls ? this.makeHrefResolve(ds, p.getValue(), p.getName()) : this.makeHref(p.getValue(), null, p.getName());
                    out.format(" <li>%s</li>%n", attachLink);
                    continue;
                }
                out.format(" <li>%s = \"%s\"</li>%n", this.htmlEscaper.escape(p.getName()), this.htmlEscaper.escape(p.getValue()));
            }
            out.format("</ul>%n", new Object[0]);
        }
        if (complete) {
            out.format("</body></html>", new Object[0]);
        }
    }

    private String rangeString(ThreddsMetadata.GeospatialRange r) {
        if (r == null) {
            return "";
        }
        String units = r.getUnits() == null ? "" : " " + r.getUnits();
        String resolution = r.hasResolution() ? " Resolution=" + r.getResolution() : "";
        return this.htmlEscaper.escape(r.getStart() + " to " + (r.getStart() + r.getSize()) + resolution + units);
    }

    public String resolve(Dataset ds, String href) {
        Catalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                return "DatasetHtmlWriter: error parsing URL= " + href;
            }
        }
        return href;
    }

    private String makeHref(String urlPath, String query, String title) {
        if (title == null) {
            title = urlPath;
        }
        if (query != null) {
            urlPath = urlPath + "?" + query;
        }
        return "<a href='" + this.htmlEscaper.escape(urlPath) + "'>" + this.htmlEscaper.escape(title) + "</a>";
    }

    private String makeHrefResolve(Dataset ds, String href, String title) {
        href = this.resolve(ds, href);
        return this.makeHref(href, null, title);
    }
}

