/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTaskImpl;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;

public class Nccopy {
    public static void main(String[] args) throws Exception {
        String progName = Nccopy.class.getName();
        try {
            CommandLine cmdLine = new CommandLine(progName, args);
            if (cmdLine.help) {
                cmdLine.printUsage();
                return;
            }
            String datasetIn = cmdLine.inputFile.getAbsolutePath();
            String datasetOut = cmdLine.outputFile.getAbsolutePath();
            CancelTaskImpl cancel = new CancelTaskImpl();
            Formatter errlog = new Formatter();
            System.out.printf("NetcdfDatataset read from %s write %s to %s ", new Object[]{datasetIn, cmdLine.format, datasetOut});
            try (NetcdfFile ncfileIn = NetcdfDataset.openFile(datasetIn, cancel);){
                FileWriter2 writer = new FileWriter2(ncfileIn, datasetOut, cmdLine.format, cmdLine.getNc4Chunking());
                writer.getNetcdfFileWriter().setLargeFile(cmdLine.isLargeFile);
                NetcdfFile ncfileOut = writer.write(cancel);
                if (ncfileOut != null) {
                    ncfileOut.close();
                }
                cancel.setDone(true);
                System.out.printf("%s%n", cancel);
            }
            catch (Exception ex) {
                System.out.printf("%s = %s %n", ex.getClass().getName(), ex.getMessage());
                String err = errlog.toString();
                if (err.length() > 0) {
                    System.out.printf(" errlog=%s%n", err);
                }
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.printf("Try \"%s --help\" for more information.%n", progName);
        }
    }

    private static class CommandLine {
        @Parameter(names={"-i", "--input"}, description="Input dataset.", required=true)
        public File inputFile;
        @Parameter(names={"-o", "--output"}, description="Output file.", required=true)
        public File outputFile;
        @Parameter(names={"-f", "--format"}, description="Output file format. Allowed values = [netcdf3, netcdf4, netcdf4_classic, netcdf3c, netcdf3c64, ncstream]")
        public NetcdfFileWriter.Version format = NetcdfFileWriter.Version.netcdf3;
        @Parameter(names={"-st", "--strategy"}, description="Chunking strategy. Only used in NetCDF 4. Allowed values = [standard, grib, none]")
        public Nc4Chunking.Strategy strategy = Nc4Chunking.Strategy.standard;
        @Parameter(names={"-isLargeFile", "--isLargeFile"}, description="Write to large file format. Only used in NetCDF 3.")
        public boolean isLargeFile = false;
        @Parameter(names={"-d", "--deflateLevel"}, description="Compression level. Only used in NetCDF 4. Allowed values = 0 (no compression, fast) to 9 (max compression, slow)")
        public int deflateLevel = 5;
        @Parameter(names={"-sh", "--shuffle"}, description="Enable the shuffle filter, which may improve compression. Only used in NetCDF 4. This option is ignored unless a non-zero deflate level is specified.")
        public boolean shuffle = true;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help = false;
        private final JCommander jc;

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
            this.jc.setParameterDescriptionComparator((Comparator)new ParameterDescriptionComparator());
        }

        public void printUsage() {
            this.jc.usage();
        }

        public Nc4Chunking getNc4Chunking() {
            return Nc4ChunkingStrategy.factory(this.strategy, this.deflateLevel, this.shuffle);
        }

        private static class ParameterDescriptionComparator
        implements Comparator<ParameterDescription> {
            private final List<String> orderedParamNames = Arrays.asList("--input", "--output", "--format", "--isLargeFile", "--strategy", "--deflateLevel", "--shuffle", "--help");

            private ParameterDescriptionComparator() {
            }

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                int index0 = this.orderedParamNames.indexOf(p0.getLongestName());
                int index1 = this.orderedParamNames.indexOf(p1.getLongestName());
                assert (index0 >= 0) : "Unexpected parameter name: " + p0.getLongestName();
                assert (index1 >= 0) : "Unexpected parameter name: " + p1.getLongestName();
                return Integer.compare(index0, index1);
            }
        }
    }
}

