/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.ExecutionException;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;

public class FileCacheGuava
implements FileCacheIF {
    private final String name;
    private LoadingCache<String, FileCacheable> cache;

    public FileCacheGuava(String name, int maxSize) {
        this.name = name;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).recordStats().build((CacheLoader)new CacheLoader<String, FileCacheable>(){

            public FileCacheable load(String key) throws IOException {
                throw new IllegalStateException();
            }
        });
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
        this.clearCache(true);
        this.cache = null;
    }

    @Override
    public FileCacheable acquire(FileFactory factory, DatasetUrl durl) throws IOException {
        return this.acquire(factory, durl.trueurl, durl, -1, null, null);
    }

    @Override
    public FileCacheable acquire(FileFactory factory, Object hashKey, DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (null == hashKey) {
            hashKey = durl.trueurl;
        }
        if (null == hashKey) {
            throw new IllegalArgumentException();
        }
        try {
            return (FileCacheable)this.cache.get((Object)((String)hashKey), () -> factory.open(durl, buffer_size, cancelTask, spiObject));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public boolean release(FileCacheable ncfile) throws IOException {
        return false;
    }

    @Override
    public void eject(Object hashKey) {
    }

    @Override
    public void clearCache(boolean force) {
        this.cache.invalidateAll();
    }

    @Override
    public void resetTracking() {
    }

    @Override
    public void showTracking(Formatter format) {
    }

    @Override
    public void showCache(Formatter f) {
        CacheStats stats = this.cache.stats();
        f.format("%n%s%n%s%n", this.name, stats);
    }

    @Override
    public void showStats(Formatter f) {
        CacheStats stats = this.cache.stats();
        f.format("%s", stats);
    }

    @Override
    public List<String> showCache() {
        return null;
    }
}

