/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.URLnaming;
import ucar.unidata.util.StringUtil2;

public class CatalogBuilder {
    private static Logger logger = LoggerFactory.getLogger(CatalogBuilder.class);
    private Map<String, Service> serviceMap = new HashMap<String, Service>();
    protected Formatter errlog = new Formatter();
    protected boolean fatalError = false;
    protected String name;
    protected String version;
    protected CalendarDate expires;
    protected URI baseURI;
    protected List<Property> properties;
    protected List<Service> services;
    protected List<DatasetBuilder> datasetBuilders;

    public Catalog buildFromLocation(String location, URI baseURI) throws IOException {
        location = StringUtil2.replace(location, "\\", "/");
        if (baseURI == null) {
            try {
                baseURI = new URI(location);
            }
            catch (URISyntaxException e) {
                this.errlog.format("Bad location = '%s' err='%s'%n", location, e.getMessage());
                this.fatalError = true;
                return null;
            }
        }
        this.baseURI = baseURI;
        this.readXML(location);
        return this.fatalError ? null : this.makeCatalog();
    }

    public Catalog buildFromURI(URI uri) throws IOException {
        this.baseURI = uri;
        this.readXML(uri);
        return this.fatalError ? null : this.makeCatalog();
    }

    public Catalog buildFromCatref(CatalogRef catref) throws IOException {
        URI catrefURI = catref.getURI();
        if (catrefURI == null) {
            this.errlog.format("Catref doesnt have valid UrlPath=%s%n", catref.getUrlPath());
            this.fatalError = true;
            return null;
        }
        this.baseURI = catrefURI;
        Catalog result = this.buildFromURI(catrefURI);
        catref.setRead(!this.fatalError);
        return this.fatalError ? null : result;
    }

    public Catalog buildFromString(String catalogAsString, URI docBaseUri) throws IOException {
        this.baseURI = docBaseUri;
        this.readXMLfromString(catalogAsString);
        return this.fatalError ? null : this.makeCatalog();
    }

    public Catalog buildFromStream(InputStream stream, URI docBaseUri) throws IOException {
        this.baseURI = docBaseUri;
        this.readXML(stream);
        return this.fatalError ? null : this.makeCatalog();
    }

    public Catalog buildFromJdom(Element root, URI docBaseUri) throws IOException {
        this.baseURI = docBaseUri;
        this.readCatalog(root);
        return this.fatalError ? null : this.makeCatalog();
    }

    public String getErrorMessage() {
        return this.errlog.toString();
    }

    public String getValidationMessage() {
        return this.errlog.toString();
    }

    public boolean hasFatalError() {
        return this.fatalError;
    }

    public CatalogBuilder() {
    }

    public CatalogBuilder(Catalog from) {
        this.name = from.getName();
        this.expires = from.getExpires();
        this.baseURI = from.getBaseURI();
        this.properties = from.getProperties();
        this.services = from.getServices();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public void setExpires(CalendarDate expires) {
        this.expires = expires;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addProperty(Property p) {
        if (p == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        if (!this.properties.contains(p)) {
            this.properties.add(p);
        }
    }

    public void addService(Service s) {
        if (s == null) {
            return;
        }
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        if (!this.services.contains(s) && !this.containsService(s.getName())) {
            this.services.add(s);
        }
    }

    private boolean containsService(String name) {
        if (name == null) {
            return false;
        }
        if (this.services == null) {
            return false;
        }
        for (Service s : this.services) {
            if (!name.equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeAnyService() {
        this.services = null;
    }

    public void addDataset(DatasetBuilder d) {
        if (d == null) {
            return;
        }
        if (this.datasetBuilders == null) {
            this.datasetBuilders = new ArrayList<DatasetBuilder>();
        }
        this.datasetBuilders.add(d);
    }

    public Catalog makeCatalog() {
        this.setServices(this.getDatasets());
        Map<String, Object> flds = this.setFields();
        return new Catalog(this.baseURI, this.name, flds, this.datasetBuilders);
    }

    private void setServices(Iterable<DatasetBuilder> dsIter) {
        for (DatasetBuilder dsb : dsIter) {
            for (Service s : dsb.getServices()) {
                this.addService(s);
            }
            this.setServices(dsb.getDatasets());
        }
    }

    protected Map<String, Object> setFields() {
        HashMap<String, Object> flds = new HashMap<String, Object>(10);
        if (this.expires != null) {
            flds.put("Expires", this.expires);
        }
        if (this.version != null) {
            flds.put("Version", this.version);
        }
        if (this.services != null) {
            flds.put("Services", this.services);
        }
        if (this.properties != null) {
            flds.put("Properties", this.properties);
        }
        return flds;
    }

    @Nullable
    public DatasetBuilder getTopDataset() {
        if (this.datasetBuilders == null) {
            return null;
        }
        return this.datasetBuilders.get(0);
    }

    public Iterable<DatasetBuilder> getDatasets() {
        if (this.datasetBuilders != null) {
            return this.datasetBuilders;
        }
        return new ArrayList<DatasetBuilder>(0);
    }

    public boolean hasService(String name) {
        if (this.services == null) {
            return false;
        }
        for (Service s : this.services) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasServiceInDataset(String name) {
        for (DatasetBuilder dsb : this.datasetBuilders) {
            for (Service s : dsb.getServices()) {
                if (!s.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void readXML(String location) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document jdomDoc = saxBuilder.build(location);
            this.readCatalog(jdomDoc.getRootElement());
        }
        catch (Exception e) {
            this.errlog.format("failed to read catalog at '%s' err='%s'%n", location, e);
            logger.error("failed to read catalog at " + location, (Throwable)e);
            this.fatalError = true;
        }
    }

    private void readXML(URI uri) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document jdomDoc = saxBuilder.build(uri.toURL());
            this.readCatalog(jdomDoc.getRootElement());
        }
        catch (Exception e) {
            this.errlog.format("failed to read catalog at '%s' err='%s'%n", uri.toString(), e);
            logger.error("failed to read catalog at " + uri.toString(), (Throwable)e);
            this.fatalError = true;
        }
    }

    private void readXMLfromString(String catalogAsString) throws IOException {
        try {
            StringReader in = new StringReader(catalogAsString);
            SAXBuilder saxBuilder = new SAXBuilder();
            Document jdomDoc = saxBuilder.build((Reader)in);
            this.readCatalog(jdomDoc.getRootElement());
        }
        catch (Exception e) {
            this.errlog.format("failed to read catalogAsString err='%s'%n", e);
            logger.error("failed to read catalogAsString at" + this.baseURI.toString(), (Throwable)e);
            e.printStackTrace();
            this.fatalError = true;
        }
    }

    private void readXML(InputStream stream) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document jdomDoc = saxBuilder.build(stream);
            this.readCatalog(jdomDoc.getRootElement());
        }
        catch (Exception e) {
            this.errlog.format("failed to read catalogAsString err='%s'%n", e);
            logger.error("failed to read catalogAsString at" + this.baseURI.toString(), (Throwable)e);
            e.printStackTrace();
            this.fatalError = true;
        }
    }

    private void readCatalog(Element catalogElem) {
        String name = catalogElem.getAttributeValue("name");
        String catSpecifiedBaseURL = catalogElem.getAttributeValue("base");
        String expiresS = catalogElem.getAttributeValue("expires");
        String version = catalogElem.getAttributeValue("version");
        CalendarDate expires = null;
        if (expiresS != null) {
            try {
                expires = CalendarDateFormatter.isoStringToCalendarDate(null, expiresS);
            }
            catch (Exception e) {
                this.errlog.format("bad expires date '%s' err='%s'%n", expiresS, e.getMessage());
            }
        }
        if (catSpecifiedBaseURL != null) {
            try {
                URI userSpecifiedBaseUri;
                this.baseURI = userSpecifiedBaseUri = new URI(catSpecifiedBaseURL);
            }
            catch (URISyntaxException e) {
                this.errlog.format("readCatalog(): bad catalog specified base URI='%s' %n", catSpecifiedBaseURL);
            }
        }
        this.setName(name);
        this.setExpires(expires);
        this.setVersion(version);
        List sList = catalogElem.getChildren("service", Catalog.defNS);
        for (Object e : sList) {
            this.addService(this.readService((Element)e));
        }
        List pList = catalogElem.getChildren("property", Catalog.defNS);
        for (Element e : pList) {
            this.addProperty(this.readProperty(e));
        }
        List allChildren = catalogElem.getChildren();
        for (Element e : allChildren) {
            if (e.getName().equals("dataset")) {
                this.addDataset(this.readDataset(null, e));
                continue;
            }
            if (e.getName().equals("catalogRef")) {
                this.addDataset(this.readCatalogRef(null, e));
                continue;
            }
            this.addDataset(this.buildOtherDataset(null, e));
        }
    }

    protected DatasetBuilder buildOtherDataset(DatasetBuilder parent, Element dsElem) {
        return null;
    }

    protected AccessBuilder readAccess(DatasetBuilder dataset, Element accessElem) {
        String urlPath = accessElem.getAttributeValue("urlPath");
        String serviceName = accessElem.getAttributeValue("serviceName");
        String dataFormat = accessElem.getAttributeValue("dataFormat");
        Service s = this.serviceMap.get(serviceName);
        if (s == null) {
            this.errlog.format("Cant find service name='%s'%n", serviceName);
        }
        return new AccessBuilder(dataset, urlPath, s, dataFormat, this.readDataSize(accessElem));
    }

    protected Property readProperty(Element s) {
        String name = s.getAttributeValue("name");
        String value = s.getAttributeValue("value");
        return new Property(name, value);
    }

    protected Service readService(Element s) {
        String name = s.getAttributeValue("name");
        String typeS = s.getAttributeValue("serviceType");
        String serviceBase = s.getAttributeValue("base");
        String suffix = s.getAttributeValue("suffix");
        String desc = s.getAttributeValue("desc");
        ServiceType type = ServiceType.getServiceTypeIgnoreCase(typeS);
        if (type == null) {
            this.errlog.format(" non-standard service type = '%s'%n", typeS);
        }
        ArrayList<Property> properties = null;
        List propertyList = s.getChildren("property", Catalog.defNS);
        for (Element e : propertyList) {
            if (properties == null) {
                properties = new ArrayList<Property>();
            }
            properties.add(this.readProperty(e));
        }
        ArrayList<Service> services = null;
        List serviceList = s.getChildren("service", Catalog.defNS);
        for (Element e : serviceList) {
            if (services == null) {
                services = new ArrayList<Service>();
            }
            services.add(this.readService(e));
        }
        Service result = new Service(name, serviceBase, typeS, desc, suffix, services, properties);
        this.serviceMap.put(name, result);
        return result;
    }

    protected DatasetBuilder readCatalogRef(DatasetBuilder parent, Element catRefElem) {
        String title = catRefElem.getAttributeValue("title", Catalog.xlinkNS);
        if (title == null) {
            title = catRefElem.getAttributeValue("name");
        }
        String href = catRefElem.getAttributeValue("href", Catalog.xlinkNS);
        CatalogRefBuilder catRef = new CatalogRefBuilder(parent);
        this.readDatasetInfo(catRef, catRefElem);
        catRef.setTitle(title);
        catRef.setHref(href);
        return catRef;
    }

    protected DatasetBuilder readDataset(DatasetBuilder parent, Element dsElem) {
        DatasetBuilder dataset = new DatasetBuilder(parent);
        this.readDatasetInfo(dataset, dsElem);
        List aList = dsElem.getChildren("access", Catalog.defNS);
        for (Element e : aList) {
            dataset.addAccess(this.readAccess(dataset, e));
        }
        List allChildren = dsElem.getChildren();
        for (Element e : allChildren) {
            if (e.getName().equals("dataset")) {
                dataset.addDataset(this.readDataset(dataset, e));
                continue;
            }
            if (e.getName().equals("catalogRef")) {
                dataset.addDataset(this.readCatalogRef(dataset, e));
                continue;
            }
            dataset.addDataset(this.buildOtherDataset(dataset, e));
        }
        return dataset;
    }

    protected void readDatasetInfo(DatasetBuilder dataset, Element dsElem) {
        String harvest;
        FeatureType dataType;
        String name = dsElem.getAttributeValue("name");
        if (name == null) {
            if (dsElem.getName().equals("catalogRef")) {
                dataset.setName("");
            } else {
                this.errlog.format(" ** warning: dataset must have a name = '%s'%n", dsElem);
            }
        } else {
            dataset.setName(name);
        }
        dataset.put("Alias", dsElem.getAttributeValue("alias"));
        dataset.put("Authority", dsElem.getAttributeValue("authority"));
        dataset.put("CollectionType", dsElem.getAttributeValue("collectionType"));
        dataset.put("Id", dsElem.getAttributeValue("ID"));
        dataset.putInheritedField("RestrictAccess", dsElem.getAttributeValue("restrictAccess"));
        dataset.put("ServiceName", dsElem.getAttributeValue("serviceName"));
        dataset.put("UrlPath", dsElem.getAttributeValue("urlPath"));
        String dataTypeName = dsElem.getAttributeValue("dataType");
        dataset.put("FeatureType", dataTypeName);
        if (dataTypeName != null && (dataType = FeatureType.getType(dataTypeName.toUpperCase())) == null) {
            this.errlog.format(" ** warning: non-standard data type = '%s'%n", dataTypeName);
        }
        if ((harvest = dsElem.getAttributeValue("harvest")) != null && harvest.equalsIgnoreCase("true")) {
            dataset.put("Harvest", Boolean.TRUE);
        }
        this.readThreddsMetadataGroup(dataset.flds, dataset, dsElem);
    }

    protected void readThreddsMetadataGroup(Map<String, Object> flds, DatasetBuilder dataset, Element parent) {
        ThreddsMetadata.UriResolved mapUri;
        long size;
        String dataFormatTypeName;
        Element dataFormatElem;
        Element dataTypeElem;
        Element authElem;
        Element serviceNameElem;
        DateRange tc;
        List list = parent.getChildren("creator", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Creators", this.readSource(e));
        }
        list = parent.getChildren("contributor", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Contributors", this.readContributor(e));
        }
        list = parent.getChildren("date", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Dates", this.readDate(e, null));
        }
        list = parent.getChildren("documentation", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Documentation", this.readDocumentation(e));
        }
        list = parent.getChildren("keyword", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Keywords", this.readControlledVocabulary(e));
        }
        list = parent.getChildren("metadata", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "MetadataOther", this.readMetadata(flds, dataset, e));
        }
        list = parent.getChildren("project", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Projects", this.readControlledVocabulary(e));
        }
        list = parent.getChildren("property", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Properties", this.readProperty(e));
        }
        list = parent.getChildren("publisher", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Publishers", this.readSource(e));
        }
        list = parent.getChildren("variables", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "VariableGroups", this.readVariables(e));
        }
        ThreddsMetadata.GeospatialCoverage gc = this.readGeospatialCoverage(parent.getChild("geospatialCoverage", Catalog.defNS));
        if (gc != null) {
            flds.put("GeospatialCoverage", gc);
        }
        if ((tc = this.readTimeCoverage(parent.getChild("timeCoverage", Catalog.defNS))) != null) {
            flds.put("TimeCoverage", tc);
        }
        if ((serviceNameElem = parent.getChild("serviceName", Catalog.defNS)) != null) {
            flds.put("ServiceName", serviceNameElem.getText());
        }
        if ((authElem = parent.getChild("authority", Catalog.defNS)) != null) {
            flds.put("Authority", authElem.getText());
        }
        if ((dataTypeElem = parent.getChild("dataType", Catalog.defNS)) != null) {
            FeatureType dataType;
            String dataTypeName = dataTypeElem.getText();
            flds.put("FeatureType", dataTypeName);
            if (dataTypeName != null && dataTypeName.length() > 0 && (dataType = FeatureType.getType(dataTypeName.toUpperCase())) == null) {
                this.errlog.format(" ** warning: non-standard feature type = '%s'%n", dataTypeName);
            }
        }
        if ((dataFormatElem = parent.getChild("dataFormat", Catalog.defNS)) != null && (dataFormatTypeName = dataFormatElem.getText()) != null && dataFormatTypeName.length() > 0) {
            DataFormatType dataFormatType = DataFormatType.getType(dataFormatTypeName);
            if (dataFormatType == null) {
                this.errlog.format(" ** warning: non-standard dataFormat type = '%s'%n", dataFormatTypeName);
            }
            flds.put("DataFormatType", dataFormatTypeName);
        }
        if ((size = this.readDataSize(parent)) > 0L) {
            flds.put("DataSize", size);
        }
        if ((mapUri = this.readUri(parent.getChild("variableMap", Catalog.defNS), "variableMap")) != null) {
            flds.put("VariableMapLinkURI", mapUri);
        }
    }

    protected ThreddsMetadata.Contributor readContributor(Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Contributor(elem.getText(), elem.getAttributeValue("role"));
    }

    protected long readDataSize(Element parent) {
        double size;
        Element elem = parent.getChild("dataSize", Catalog.defNS);
        if (elem == null) {
            return -1L;
        }
        String sizeS = elem.getText();
        try {
            size = Double.parseDouble(sizeS);
        }
        catch (NumberFormatException e) {
            this.errlog.format(" ** Parse error: Bad double format in size element = '%s'%n", sizeS);
            return -1L;
        }
        String units = elem.getAttributeValue("units");
        char c = Character.toUpperCase(units.charAt(0));
        if (c == 'K') {
            size *= 1000.0;
        } else if (c == 'M') {
            size *= 1000000.0;
        } else if (c == 'G') {
            size *= 1.0E9;
        } else if (c == 'T') {
            size *= 1.0E12;
        } else if (c == 'P') {
            size *= 1.0E15;
        }
        return (long)size;
    }

    protected Documentation readDocumentation(Element s) {
        String href = s.getAttributeValue("href", Catalog.xlinkNS);
        String title = s.getAttributeValue("title", Catalog.xlinkNS);
        String type = s.getAttributeValue("type");
        String content = s.getTextNormalize();
        URI uri = null;
        if (href != null) {
            try {
                uri = Catalog.resolveUri(this.baseURI, href);
            }
            catch (Exception e) {
                this.errlog.format(" ** Invalid documentation href = '%s' err='%s'%n", href, e.getMessage());
            }
        }
        return new Documentation(href, uri, title, type, content);
    }

    protected double readDouble(Element elem) {
        if (elem == null) {
            return Double.NaN;
        }
        String text = elem.getText();
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            this.errlog.format(" ** Parse error: Bad double format = '%s'%n", text);
            return Double.NaN;
        }
    }

    protected ThreddsMetadata.GeospatialCoverage readGeospatialCoverage(Element gcElem) {
        if (gcElem == null) {
            return null;
        }
        String zpositive = gcElem.getAttributeValue("zpositive");
        ThreddsMetadata.GeospatialRange northsouth = this.readGeospatialRange(gcElem.getChild("northsouth", Catalog.defNS), "degrees_north");
        ThreddsMetadata.GeospatialRange eastwest = this.readGeospatialRange(gcElem.getChild("eastwest", Catalog.defNS), "degrees_east");
        ThreddsMetadata.GeospatialRange updown = this.readGeospatialRange(gcElem.getChild("updown", Catalog.defNS), "m");
        ArrayList<ThreddsMetadata.Vocab> names = new ArrayList<ThreddsMetadata.Vocab>();
        List list = gcElem.getChildren("name", Catalog.defNS);
        for (Element e : list) {
            ThreddsMetadata.Vocab name = this.readControlledVocabulary(e);
            names.add(name);
        }
        return new ThreddsMetadata.GeospatialCoverage(eastwest, northsouth, updown, names, zpositive);
    }

    protected ThreddsMetadata.GeospatialRange readGeospatialRange(Element spElem, String defUnits) {
        if (spElem == null) {
            return null;
        }
        double start = this.readDouble(spElem.getChild("start", Catalog.defNS));
        double size = this.readDouble(spElem.getChild("size", Catalog.defNS));
        double resolution = this.readDouble(spElem.getChild("resolution", Catalog.defNS));
        String units = spElem.getChildText("units", Catalog.defNS);
        if (units == null) {
            units = defUnits;
        }
        return new ThreddsMetadata.GeospatialRange(start, size, resolution, units);
    }

    protected ThreddsMetadata.MetadataOther readMetadata(Map<String, Object> flds, DatasetBuilder dataset, Element mdataElement) {
        Map<String, Object> useFlds;
        boolean isThreddsNamespace;
        List inlineElements = mdataElement.getChildren();
        Namespace namespace = inlineElements.size() > 0 ? ((Element)inlineElements.get(0)).getNamespace() : mdataElement.getNamespace();
        String mtype = mdataElement.getAttributeValue("metadataType");
        String href = mdataElement.getAttributeValue("href", Catalog.xlinkNS);
        String title = mdataElement.getAttributeValue("title", Catalog.xlinkNS);
        String inheritedS = mdataElement.getAttributeValue("inherited");
        boolean inherited = inheritedS != null && inheritedS.equalsIgnoreCase("true");
        boolean bl = isThreddsNamespace = (mtype == null || mtype.equalsIgnoreCase("THREDDS")) && namespace.getURI().equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
        if (!isThreddsNamespace) {
            if (inlineElements.size() > 0) {
                return new ThreddsMetadata.MetadataOther(mtype, namespace.getURI(), namespace.getPrefix(), inherited, mdataElement);
            }
            return new ThreddsMetadata.MetadataOther(href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited);
        }
        if (inherited) {
            ThreddsMetadata tmi = (ThreddsMetadata)dataset.get("ThreddsMetadataInheritable");
            if (tmi == null) {
                tmi = new ThreddsMetadata();
                dataset.put("ThreddsMetadataInheritable", tmi);
            }
            useFlds = tmi.getFlds();
        } else {
            useFlds = flds;
        }
        this.readThreddsMetadataGroup(useFlds, dataset, mdataElement);
        if (href != null) {
            try {
                URI xlinkUri = Catalog.resolveUri(this.baseURI, href);
                Element remoteMdata = this.readMetadataFromUrl(xlinkUri);
                return this.readMetadata(useFlds, dataset, remoteMdata);
            }
            catch (Exception ioe) {
                this.errlog.format("Cant read in referenced metadata %s err=%s%n", href, ioe.getMessage());
            }
        }
        return null;
    }

    private Element readMetadataFromUrl(URI uri) throws IOException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            doc = saxBuilder.build(uri.toURL());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return doc.getRootElement();
    }

    protected ThreddsMetadata.Source readSource(Element elem) {
        if (elem == null) {
            return null;
        }
        ThreddsMetadata.Vocab name = this.readControlledVocabulary(elem.getChild("name", Catalog.defNS));
        Element contact = elem.getChild("contact", Catalog.defNS);
        if (contact == null) {
            this.errlog.format(" ** Parse error: Missing contact element in = '%s'%n", elem.getName());
            return null;
        }
        return new ThreddsMetadata.Source(name, contact.getAttributeValue("url"), contact.getAttributeValue("email"));
    }

    protected DateRange readTimeCoverage(Element tElem) {
        if (tElem == null) {
            return null;
        }
        Calendar calendar = this.readCalendar(tElem.getAttributeValue("calendar"));
        DateType start = this.readDate(tElem.getChild("start", Catalog.defNS), calendar);
        DateType end = this.readDate(tElem.getChild("end", Catalog.defNS), calendar);
        TimeDuration duration = this.readDuration(tElem.getChild("duration", Catalog.defNS));
        TimeDuration resolution = this.readDuration(tElem.getChild("resolution", Catalog.defNS));
        try {
            return new DateRange(start, end, duration, resolution);
        }
        catch (IllegalArgumentException e) {
            this.errlog.format(" ** warning: TimeCoverage error ='%s'%n", e.getMessage());
            return null;
        }
    }

    protected Calendar readCalendar(String calendarAttribValue) {
        if (calendarAttribValue == null) {
            return Calendar.getDefault();
        }
        Calendar calendar = Calendar.get(calendarAttribValue);
        if (calendar == null) {
            this.errlog.format(" ** Parse error: Bad calendar name = '%s'%n", calendarAttribValue);
            return Calendar.getDefault();
        }
        return calendar;
    }

    protected DateType readDate(Element elem, Calendar calendar) {
        if (elem == null) {
            return null;
        }
        String format = elem.getAttributeValue("format");
        String type = elem.getAttributeValue("type");
        return this.makeDateType(elem.getText(), format, type, calendar);
    }

    protected DateType makeDateType(String text, String format, String type, Calendar calendar) {
        if (text == null) {
            return null;
        }
        try {
            return new DateType(text, format, type, calendar);
        }
        catch (ParseException e) {
            this.errlog.format(" ** Parse error: Bad date format = '%s'%n", text);
            return null;
        }
    }

    protected TimeDuration readDuration(Element elem) {
        if (elem == null) {
            return null;
        }
        String text = null;
        try {
            text = elem.getText();
            return new TimeDuration(text);
        }
        catch (ParseException e) {
            this.errlog.format(" ** Parse error: Bad duration format = '%s'%n", text);
            return null;
        }
    }

    protected ThreddsMetadata.VariableGroup readVariables(Element varsElem) {
        if (varsElem == null) {
            return null;
        }
        String vocab = varsElem.getAttributeValue("vocabulary");
        ThreddsMetadata.UriResolved variableVocabUri = this.readUri(varsElem, "Variables vocabulary");
        List vlist = varsElem.getChildren("variable", Catalog.defNS);
        ThreddsMetadata.UriResolved variableMap = this.readUri(varsElem.getChild("variableMap", Catalog.defNS), "Variables Map");
        if (variableMap != null && vlist.size() > 0) {
            this.errlog.format(" ** Catalog error: cant have variableMap and variable in same element '%s'%n", varsElem);
        }
        ArrayList<ThreddsMetadata.Variable> variables = new ArrayList<ThreddsMetadata.Variable>();
        for (Element e : vlist) {
            variables.add(CatalogBuilder.readVariable(e));
        }
        return new ThreddsMetadata.VariableGroup(vocab, variableVocabUri, variableMap, variables);
    }

    public static ThreddsMetadata.Variable readVariable(Element varElem) {
        if (varElem == null) {
            return null;
        }
        String name = varElem.getAttributeValue("name");
        String desc = varElem.getText();
        String vocabulary_name = varElem.getAttributeValue("vocabulary_name");
        String units = varElem.getAttributeValue("units");
        String id = varElem.getAttributeValue("vocabulary_id");
        return new ThreddsMetadata.Variable(name, desc, vocabulary_name, units, id);
    }

    protected ThreddsMetadata.Vocab readControlledVocabulary(Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Vocab(elem.getText(), elem.getAttributeValue("vocabulary"));
    }

    private ThreddsMetadata.UriResolved readUri(Element elemWithHref, String what) {
        if (elemWithHref == null) {
            return null;
        }
        String mapHref = elemWithHref.getAttributeValue("href", Catalog.xlinkNS);
        if (mapHref == null) {
            return null;
        }
        try {
            String mapUri = URLnaming.resolve(this.baseURI.toString(), mapHref);
            return new ThreddsMetadata.UriResolved(mapHref, new URI(mapUri));
        }
        catch (Exception e) {
            this.errlog.format(" ** Invalid %s URI= '%s' err='%s'%n", what, mapHref, e.getMessage());
            return null;
        }
    }
}

