/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;

public class Misc {
    public static final int referenceSize = 4;
    public static final int objectSize = 16;
    public static final double maxReletiveError = 1.0E-6;
    private static final String threddsPropFileName = "thredds.properties";
    private static final String testdataDirPropName = "unidata.testdata.path";
    private static String testdataDirPath = null;

    public static double howClose(double d1, double d2) {
        double pd = (d1 - d2) / d1;
        return Math.abs(pd);
    }

    public static boolean closeEnough(double v1, double v2, double maxRelDiff) {
        double largest;
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            return true;
        }
        if (Double.isNaN(v1) || Double.isNaN(v2)) {
            return false;
        }
        if (v1 == v2) {
            return true;
        }
        double diff = Math.abs(v1 - v2);
        return diff <= (largest = Math.max(Math.abs(v1), Math.abs(v2))) * maxRelDiff;
    }

    public static boolean closeEnough(double v1, double v2) {
        return Misc.closeEnough(v1, v2, 1.0E-6);
    }

    public static boolean closeEnough(float v1, float v2, float maxRelDiff) {
        float largest;
        if (Float.isNaN(v1) && Float.isNaN(v2)) {
            return true;
        }
        if (Float.isNaN(v1) || Float.isNaN(v2)) {
            return false;
        }
        float diff = Math.abs(v1 - v2);
        return diff <= (largest = Math.max(Math.abs(v1), Math.abs(v2))) * maxRelDiff;
    }

    public static boolean closeEnough(float v1, float v2) {
        return Misc.closeEnough((double)v1, (double)v2, 1.0E-6);
    }

    public static boolean closeEnoughAbs(double v1, double v2, double maxAbsDiff) {
        return Math.abs(v1 - v2) <= Math.abs(maxAbsDiff);
    }

    public static boolean closeEnoughAbs(float v1, float v2, float maxAbsDiff) {
        return Math.abs(v1 - v2) <= Math.abs(maxAbsDiff);
    }

    public static String showInts(int[] inta) {
        if (inta == null) {
            return "null";
        }
        Formatter f = new Formatter();
        for (int i : inta) {
            f.format("%d,", i);
        }
        return f.toString();
    }

    public static String showInts(List<Integer> intList) {
        if (intList == null) {
            return "null";
        }
        Formatter f = new Formatter();
        for (int i : intList) {
            f.format("%d,", i);
        }
        return f.toString();
    }

    public static void showInts(int[] inta, Formatter f) {
        if (inta == null) {
            f.format("null", new Object[0]);
            return;
        }
        for (int i : inta) {
            f.format("%d, ", i);
        }
    }

    public static String showBytes(byte[] buff) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < buff.length; ++i) {
            int ub;
            int b = buff[i];
            int n = ub = b < 0 ? b + 256 : b;
            if (i > 0) {
                sbuff.append(" ");
            }
            sbuff.append(ub);
        }
        return sbuff.toString();
    }

    public static void showBytes(byte[] buff, Formatter f) {
        for (int n : buff) {
            int ub = n < 0 ? n + 256 : n;
            f.format("%3d ", ub);
        }
    }

    public static int getSize(Iterable ii) {
        if (ii instanceof Collection) {
            return ((Collection)ii).size();
        }
        int count = 0;
        for (Object i : ii) {
            ++count;
        }
        return count;
    }

    public static List getList(Iterable ii) {
        if (ii instanceof List) {
            return (List)ii;
        }
        ArrayList result = new ArrayList();
        for (Object i : ii) {
            result.add(i);
        }
        return result;
    }

    public static String getTestdataDirPath() {
        File userHomeDirFile;
        File userThreddsPropsFile;
        if (testdataDirPath == null) {
            testdataDirPath = System.getProperty(testdataDirPropName);
        }
        if (testdataDirPath == null && (userThreddsPropsFile = new File(userHomeDirFile = new File(System.getProperty("user.home")), threddsPropFileName)).exists() && userThreddsPropsFile.canRead()) {
            Properties userThreddsProps = new Properties();
            try (FileInputStream fin = new FileInputStream(userThreddsPropsFile);){
                userThreddsProps.load(fin);
            }
            catch (IOException e) {
                System.out.println("**Failed loading user THREDDS property file: " + e.getMessage());
            }
            if (!userThreddsProps.isEmpty()) {
                testdataDirPath = userThreddsProps.getProperty(testdataDirPropName);
            }
        }
        return testdataDirPath;
    }

    public static boolean compare(byte[] raw1, byte[] raw2, Formatter f) {
        if (raw1 == null || raw2 == null) {
            return false;
        }
        if (raw1.length != raw2.length) {
            f.format("length 1= %3d != length 2=%3d%n", raw1.length, raw2.length);
        }
        int len = Math.min(raw1.length, raw2.length);
        int ndiff = 0;
        for (int i = 0; i < len; ++i) {
            if (raw1[i] == raw2[i]) continue;
            f.format(" %3d : %3d != %3d%n", i + 1, raw1[i], raw2[i]);
            ++ndiff;
        }
        f.format("tested %d bytes  diff = %d %n", len, ndiff);
        return ndiff == 0 && raw1.length == raw2.length;
    }

    public static void compare(float[] raw1, float[] raw2, Formatter f) {
        if (raw1.length != raw2.length) {
            f.format("compareFloat: length 1= %3d != length 2=%3d%n", raw1.length, raw2.length);
        }
        int len = Math.min(raw1.length, raw2.length);
        int ndiff = 0;
        for (int i = 0; i < len; ++i) {
            if (Misc.closeEnough(raw1[i], raw2[i]) || Double.isNaN(raw1[i]) || Double.isNaN(raw2[i])) continue;
            f.format(" %5d : %3f != %3f%n", i, Float.valueOf(raw1[i]), Float.valueOf(raw2[i]));
            ++ndiff;
        }
        f.format("tested %d floats diff = %d %n", len, ndiff);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuffer buf = new StringBuffer();
        for (StackTraceElement ste : stackTrace) {
            buf.append(ste.toString());
            buf.append("\n");
        }
        return buf.toString();
    }
}

