/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ft.fmrc.EnsCoord;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.TimeCoord;
import ucar.nc2.ft.fmrc.VertCoord;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class FmrcInv {
    private static final Logger log = LoggerFactory.getLogger(FmrcInv.class);
    private final String name;
    private final List<RunSeq> runSeqs = new ArrayList<RunSeq>();
    private final List<EnsCoord> ensCoords = new ArrayList<EnsCoord>();
    private final List<VertCoord> vertCoords = new ArrayList<VertCoord>();
    private final List<FmrInv> fmrList;
    private final List<UberGrid> uberGridList;
    private final List<CalendarDate> runTimeList;
    private final CalendarDate baseDate;
    private final List<CalendarDate> forecastTimeList;
    private final boolean regularize;
    private final TimeCoord tcOffAll;
    private final TimeCoord tcIntAll;

    FmrcInv(String name, List<FmrInv> fmrList, boolean regularize) {
        this.name = name;
        this.regularize = regularize;
        this.fmrList = new ArrayList<FmrInv>(fmrList);
        this.runTimeList = new ArrayList<CalendarDate>();
        CalendarDate firstDate = null;
        HashMap<String, UberGrid> uvHash = new HashMap<String, UberGrid>();
        HashSet<Double> offsetHash = new HashSet<Double>();
        HashSet<TimeCoord.Tinv> intervalHash = new HashSet<TimeCoord.Tinv>();
        HashSet<CalendarDate> forecastTimeHash = new HashSet<CalendarDate>();
        for (FmrInv fmrInv : fmrList) {
            this.runTimeList.add(fmrInv.getRunDate());
            if (firstDate == null) {
                firstDate = fmrInv.getRunDate();
            }
            int hour = fmrInv.getRunDate().getHourOfDay();
            for (FmrInv.GridVariable gridVariable : fmrInv.getGrids()) {
                UberGrid uv = (UberGrid)uvHash.get(gridVariable.getName());
                if (uv == null) {
                    uv = new UberGrid(gridVariable.getName());
                    uvHash.put(gridVariable.getName(), uv);
                }
                uv.addGridVariable(gridVariable, hour);
            }
            for (TimeCoord timeCoord : fmrInv.getTimeCoords()) {
                if (timeCoord.isInterval()) {
                    double[] bounds1 = timeCoord.getBound1();
                    double[] bounds2 = timeCoord.getBound2();
                    for (int i = 0; i < bounds1.length; ++i) {
                        CalendarDate date1 = fmrInv.getRunDate().add(bounds1[i], CalendarPeriod.Field.Hour);
                        CalendarDate date2 = fmrInv.getRunDate().add(bounds2[i], CalendarPeriod.Field.Hour);
                        forecastTimeHash.add(date2);
                        double b1 = FmrcInv.getOffsetInHours(firstDate, date1);
                        double b2 = FmrcInv.getOffsetInHours(firstDate, date2);
                        intervalHash.add(new TimeCoord.Tinv(b1, b2));
                    }
                    continue;
                }
                for (double offset : timeCoord.getOffsetTimes()) {
                    CalendarDate fcDate = fmrInv.getRunDate().add(offset, CalendarPeriod.Field.Hour);
                    forecastTimeHash.add(fcDate);
                    double d = FmrcInv.getOffsetInHours(firstDate, fcDate);
                    offsetHash.add(d);
                }
            }
        }
        this.baseDate = firstDate;
        this.uberGridList = new ArrayList(uvHash.values());
        Collections.sort(this.uberGridList);
        for (UberGrid uberGrid : this.uberGridList) {
            uberGrid.finish();
        }
        int seqno = 0;
        for (RunSeq seq : this.runSeqs) {
            seq.id = seqno++;
        }
        this.forecastTimeList = Arrays.asList(forecastTimeHash.toArray(new CalendarDate[forecastTimeHash.size()]));
        Collections.sort(this.forecastTimeList);
        List<Double> list = Arrays.asList(offsetHash.toArray(new Double[offsetHash.size()]));
        Collections.sort(list);
        int counto = 0;
        double[] offs = new double[list.size()];
        for (double off : list) {
            offs[counto++] = off;
        }
        this.tcOffAll = new TimeCoord(this.baseDate);
        this.tcOffAll.setOffsetTimes(offs);
        List<TimeCoord.Tinv> list2 = Arrays.asList(intervalHash.toArray(new TimeCoord.Tinv[intervalHash.size()]));
        Collections.sort(list2);
        this.tcIntAll = new TimeCoord(this.baseDate);
        this.tcIntAll.setBounds(list2);
    }

    public List<FmrInv> getFmrList() {
        return this.fmrList;
    }

    public String getName() {
        return this.name;
    }

    public List<RunSeq> getRunSeqs() {
        return this.runSeqs;
    }

    public List<EnsCoord> getEnsCoords() {
        return this.ensCoords;
    }

    public List<VertCoord> getVertCoords() {
        return this.vertCoords;
    }

    public List<UberGrid> getUberGrids() {
        return this.uberGridList;
    }

    public UberGrid findUberGrid(String name) {
        for (UberGrid grid : this.uberGridList) {
            if (!grid.getName().equals(name)) continue;
            return grid;
        }
        return null;
    }

    public List<CalendarDate> getForecastTimes() {
        return this.forecastTimeList;
    }

    public List<FmrInv> getFmrInv() {
        return this.fmrList;
    }

    public CalendarDate getBaseDate() {
        return this.baseDate;
    }

    public static double getOffsetInHours(CalendarDate base, CalendarDate forecast) {
        double result;
        long testRoundoff;
        long diff = forecast.getDifferenceInMsecs(base);
        if (diff != (testRoundoff = (long)((result = (double)diff / 1000.0 / 60.0 / 60.0) * 1000.0 * 60.0 * 60.0))) {
            System.out.println("HEY getOffsetInHours");
        }
        return result;
    }

    public static CalendarDate makeOffsetDate(CalendarDate base, double offset) {
        return base.add(offset, CalendarPeriod.Field.Hour);
    }

    private RunSeq findRunSeq(List<FmrInv.GridVariable> runs) {
        for (RunSeq seq : this.runSeqs) {
            if (!seq.equalsData(runs)) continue;
            return seq;
        }
        RunSeq result = new RunSeq(runs);
        this.runSeqs.add(result);
        return result;
    }

    public class RunSeq {
        private final HashMap<CalendarDate, TimeCoord> coordMap;
        private final List<UberGrid> vars = new ArrayList<UberGrid>();
        private int id;
        private List<TimeCoord> timeList = null;
        private TimeCoord timeCoordUnion = null;
        private boolean isInterval;

        RunSeq(List<FmrInv.GridVariable> runs) {
            this.coordMap = new HashMap(2 * runs.size());
            for (CalendarDate d : FmrcInv.this.runTimeList) {
                this.coordMap.put(d, TimeCoord.EMPTY);
            }
            boolean first = true;
            for (FmrInv.GridVariable grid : runs) {
                this.coordMap.put(grid.getRunDate(), grid.getTimeExpected());
                if (first) {
                    this.isInterval = grid.getTimeCoord().isInterval();
                } else if (this.isInterval != grid.getTimeCoord().isInterval()) {
                    log.error("mixed intervals for grid " + grid.getName());
                    throw new IllegalArgumentException("mixed intervals for grid " + grid.getName());
                }
                first = false;
            }
        }

        public boolean isInterval() {
            return this.isInterval;
        }

        public List<TimeCoord> getTimes() {
            if (this.timeList == null) {
                this.getUnionTimeCoord();
            }
            return this.timeList;
        }

        public String getName() {
            return this.id == 0 ? "time" : "time" + this.id;
        }

        public int getNTimeOffsets() {
            int n = 0;
            for (TimeCoord tc : this.coordMap.values()) {
                n = Math.max(n, tc.getNCoords());
            }
            return n;
        }

        public TimeCoord getUnionTimeCoord() {
            if (this.timeCoordUnion == null) {
                this.timeList = new ArrayList<TimeCoord>();
                for (TimeCoord tc : this.coordMap.values()) {
                    if (tc == null || tc == TimeCoord.EMPTY) continue;
                    this.timeList.add(tc);
                }
                Collections.sort(this.timeList, new Comparator<TimeCoord>(){

                    @Override
                    public int compare(TimeCoord o1, TimeCoord o2) {
                        if (o1 == null || o1.getRunDate() == null) {
                            return -1;
                        }
                        if (o2 == null || o2.getRunDate() == null) {
                            return 1;
                        }
                        return o1.getRunDate().compareTo(o2.getRunDate());
                    }
                });
                this.timeCoordUnion = TimeCoord.makeUnion(this.timeList, FmrcInv.this.baseDate);
            }
            return this.timeCoordUnion;
        }

        boolean equalsData(List<FmrInv.GridVariable> oruns) {
            ArrayList<FmrInv.GridVariable> okAdd = null;
            for (FmrInv.GridVariable grid : oruns) {
                TimeCoord run = this.coordMap.get(grid.getRunDate());
                if (run == null) {
                    if (okAdd == null) {
                        okAdd = new ArrayList<FmrInv.GridVariable>();
                    }
                    okAdd.add(grid);
                    continue;
                }
                TimeCoord orune = grid.getTimeExpected();
                if (run.equalsData(orune)) continue;
                return false;
            }
            if (okAdd != null) {
                for (FmrInv.GridVariable grid : okAdd) {
                    this.coordMap.put(grid.getRunDate(), grid.getTimeExpected());
                }
            }
            return true;
        }

        void addVariable(UberGrid uv) {
            this.vars.add(uv);
        }

        public List<UberGrid> getUberGrids() {
            return this.vars;
        }
    }

    private static class HourGroup {
        final int hour;
        final List<FmrInv.GridVariable> runs = new ArrayList<FmrInv.GridVariable>();
        private TimeCoord expected;

        HourGroup(int hour) {
            this.hour = hour;
        }
    }

    public class UberGrid
    implements Comparable<UberGrid> {
        private final String gridName;
        private final List<FmrInv.GridVariable> runs = new ArrayList<FmrInv.GridVariable>();
        private VertCoord vertCoordUnion = null;
        private RunSeq runSeq = null;

        UberGrid(String name) {
            this.gridName = name;
        }

        void addGridVariable(FmrInv.GridVariable grid, int hour) {
            this.runs.add(grid);
        }

        public String getName() {
            return this.gridName;
        }

        public String toString() {
            return this.gridName;
        }

        public TimeCoord getUnionTimeCoord() {
            return this.runSeq.getUnionTimeCoord();
        }

        public boolean isInterval() {
            return this.getUnionTimeCoord().isInterval();
        }

        public String getTimeCoordName() {
            return this.runSeq.getName();
        }

        public String getVertCoordName() {
            return this.vertCoordUnion == null ? "" : this.vertCoordUnion.getName();
        }

        public List<FmrInv.GridVariable> getRuns() {
            return this.runs;
        }

        @Override
        public int compareTo(UberGrid o) {
            return this.gridName.compareTo(o.gridName);
        }

        public int countTotal() {
            int total = 0;
            for (FmrInv.GridVariable grid : this.runs) {
                total += grid.countTotal();
            }
            return total;
        }

        public int countExpected() {
            int nvert = this.vertCoordUnion == null ? 1 : this.vertCoordUnion.getSize();
            int ntimes = 0;
            for (FmrInv.GridVariable grid : this.runs) {
                TimeCoord exp = grid.getTimeExpected();
                ntimes += exp.getNCoords();
            }
            return ntimes * nvert;
        }

        void finish() {
            if (this.runs.size() == 1) {
                FmrInv.GridVariable grid = this.runs.get(0);
                this.vertCoordUnion = VertCoord.findVertCoord(FmrcInv.this.getVertCoords(), grid.vertCoordUnion);
                grid.timeExpected = grid.timeCoordUnion;
                this.runSeq = FmrcInv.this.findRunSeq(this.runs);
                this.runSeq.addVariable(this);
                return;
            }
            ArrayList<EnsCoord> ensList = new ArrayList<EnsCoord>();
            EnsCoord ec_union = null;
            for (FmrInv.GridVariable grid : this.runs) {
                EnsCoord ec = grid.ensCoordUnion;
                if (ec == null) continue;
                if (ec_union == null) {
                    ec_union = new EnsCoord(ec);
                    continue;
                }
                if (ec_union.equalsData(ec)) continue;
                ensList.add(ec);
            }
            if (ec_union != null && ensList.size() > 0) {
                EnsCoord.normalize(ec_union, ensList);
            }
            ArrayList<VertCoord> vertList = new ArrayList<VertCoord>();
            VertCoord vc_union = null;
            for (FmrInv.GridVariable gridVariable : this.runs) {
                VertCoord vc = gridVariable.vertCoordUnion;
                if (vc == null) continue;
                if (vc_union == null) {
                    vc_union = new VertCoord(vc);
                    continue;
                }
                if (vc_union.equalsData(vc)) continue;
                vertList.add(vc);
            }
            if (vc_union != null) {
                VertCoord.normalize(vc_union, vertList);
                this.vertCoordUnion = VertCoord.findVertCoord(FmrcInv.this.getVertCoords(), vc_union);
            }
            if (FmrcInv.this.regularize) {
                HashMap<Integer, HourGroup> hourMap = new HashMap<Integer, HourGroup>();
                for (FmrInv.GridVariable grid : this.runs) {
                    CalendarDate runDate = grid.getRunDate();
                    int hour = runDate.getHourOfDay();
                    HourGroup hg = (HourGroup)hourMap.get(hour);
                    if (hg == null) {
                        hg = new HourGroup(hour);
                        hourMap.put(hour, hg);
                    }
                    hg.runs.add(grid);
                }
                for (HourGroup hg : hourMap.values()) {
                    ArrayList<TimeCoord> timeListExp = new ArrayList<TimeCoord>();
                    for (FmrInv.GridVariable run : hg.runs) {
                        timeListExp.add(run.timeCoordUnion);
                    }
                    hg.expected = TimeCoord.makeUnion(timeListExp, FmrcInv.this.baseDate);
                    if (hg.expected.isInterval()) {
                        for (FmrInv.GridVariable grid : hg.runs) {
                            grid.timeExpected = new TimeCoord(grid.getRunDate());
                            grid.timeExpected.setBounds(hg.expected.getBound1(), hg.expected.getBound2());
                        }
                        continue;
                    }
                    for (FmrInv.GridVariable grid : hg.runs) {
                        grid.timeExpected = new TimeCoord(grid.getRunDate(), hg.expected.getOffsetTimes());
                    }
                }
                this.runSeq = FmrcInv.this.findRunSeq(this.runs);
                this.runSeq.addVariable(this);
            } else {
                for (FmrInv.GridVariable gridVariable : this.runs) {
                    gridVariable.timeExpected = gridVariable.timeCoordUnion;
                }
                this.runSeq = FmrcInv.this.findRunSeq(this.runs);
                this.runSeq.addVariable(this);
            }
        }
    }
}

