/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.adapter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.ArrayDouble;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis2D;

public class GeoGridCoordinate2D {
    private static boolean debug = false;
    private static final Logger log = LoggerFactory.getLogger(GeoGridCoordinate2D.class);
    private final CoordinateAxis2D latCoord;
    private final CoordinateAxis2D lonCoord;
    private final int nrows;
    private final int ncols;
    private ArrayDouble.D2 latEdge;
    private ArrayDouble.D2 lonEdge;
    private MAMath.MinMax latMinMax;
    private MAMath.MinMax lonMinMax;

    GeoGridCoordinate2D(CoordinateAxis2D latCoord, CoordinateAxis2D lonCoord) {
        this.latCoord = latCoord;
        this.lonCoord = lonCoord;
        assert (latCoord.getRank() == 2);
        assert (lonCoord.getRank() == 2);
        int[] shape = latCoord.getShape();
        this.nrows = shape[0];
        this.ncols = shape[1];
    }

    private void findBounds() {
        if (this.lonMinMax != null) {
            return;
        }
        this.lonEdge = this.lonCoord.getEdges();
        this.latEdge = this.latCoord.getEdges();
        this.latMinMax = MAMath.getMinMax(this.latEdge);
        this.lonMinMax = MAMath.getMinMax(this.lonEdge);
        if (debug) {
            System.out.printf("Bounds (%d %d): lat= (%f,%f) lon = (%f,%f) %n", this.nrows, this.ncols, this.latMinMax.min, this.latMinMax.max, this.lonMinMax.min, this.lonMinMax.max);
        }
    }

    public boolean findCoordElementForce(double wantLat, double wantLon, int[] rectIndex) {
        this.findBounds();
        if (wantLat < this.latMinMax.min) {
            return false;
        }
        if (wantLat > this.latMinMax.max) {
            return false;
        }
        if (wantLon < this.lonMinMax.min) {
            return false;
        }
        if (wantLon > this.lonMinMax.max) {
            return false;
        }
        boolean saveDebug = debug;
        debug = false;
        for (int row = 0; row < this.nrows; ++row) {
            int col = 0;
            while (col < this.ncols) {
                rectIndex[0] = row;
                rectIndex[1] = col++;
                if (!this.contains(wantLat, wantLon, rectIndex)) continue;
                debug = saveDebug;
                return true;
            }
        }
        return false;
    }

    public boolean findCoordElement(double wantLat, double wantLon, int[] rectIndex) {
        return this.findCoordElementNoForce(wantLat, wantLon, rectIndex);
    }

    public boolean findCoordElementNoForce(double wantLat, double wantLon, int[] rectIndex) {
        this.findBounds();
        if (wantLat < this.latMinMax.min) {
            return false;
        }
        if (wantLat > this.latMinMax.max) {
            return false;
        }
        if (wantLon < this.lonMinMax.min) {
            return false;
        }
        if (wantLon > this.lonMinMax.max) {
            return false;
        }
        double gradientLat = (this.latMinMax.max - this.latMinMax.min) / (double)this.nrows;
        double gradientLon = (this.lonMinMax.max - this.lonMinMax.min) / (double)this.ncols;
        double diffLat = wantLat - this.latMinMax.min;
        double diffLon = wantLon - this.lonMinMax.min;
        rectIndex[0] = (int)Math.round(diffLat / gradientLat);
        rectIndex[1] = (int)Math.round(diffLon / gradientLon);
        int count = 0;
        do {
            ++count;
            if (debug) {
                System.out.printf("%nIteration %d %n", count);
            }
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
            if (this.jump2(wantLat, wantLon, rectIndex)) continue;
            return false;
        } while (count <= 10);
        return this.incr(wantLat, wantLon, rectIndex);
    }

    private boolean containsOld(double wantLat, double wantLon, int[] rectIndex) {
        rectIndex[0] = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        int row = rectIndex[0];
        int col = rectIndex[1];
        if (debug) {
            System.out.printf(" (%d,%d) contains (%f,%f) in (lat=%f %f) (lon=%f %f) ?%n", rectIndex[0], rectIndex[1], wantLat, wantLon, this.latEdge.get(row, col), this.latEdge.get(row + 1, col), this.lonEdge.get(row, col), this.lonEdge.get(row, col + 1));
        }
        if (wantLat < this.latEdge.get(row, col)) {
            return false;
        }
        if (wantLat > this.latEdge.get(row + 1, col)) {
            return false;
        }
        if (wantLon < this.lonEdge.get(row, col)) {
            return false;
        }
        return !(wantLon > this.lonEdge.get(row, col + 1));
    }

    private boolean contains(double wantLat, double wantLon, int[] rectIndex) {
        rectIndex[0] = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        int row = rectIndex[0];
        int col = rectIndex[1];
        double x1 = this.lonEdge.get(row, col);
        double y1 = this.latEdge.get(row, col);
        double x2 = this.lonEdge.get(row, col + 1);
        double y2 = this.latEdge.get(row, col + 1);
        double x3 = this.lonEdge.get(row + 1, col + 1);
        double y3 = this.latEdge.get(row + 1, col + 1);
        double x4 = this.lonEdge.get(row + 1, col);
        double y4 = this.latEdge.get(row + 1, col);
        boolean sign = this.detIsPositive(x1, y1, x2, y2, wantLon, wantLat);
        if (sign != this.detIsPositive(x2, y2, x3, y3, wantLon, wantLat)) {
            return false;
        }
        if (sign != this.detIsPositive(x3, y3, x4, y4, wantLon, wantLat)) {
            return false;
        }
        return sign == this.detIsPositive(x4, y4, x1, y1, wantLon, wantLat);
    }

    private boolean detIsPositive(double x0, double y0, double x1, double y1, double x2, double y2) {
        double det = x1 * y2 - y1 * x2 - x0 * y2 + y0 * x2 + x0 * y1 - y0 * x1;
        if (det == 0.0) {
            log.warn("determinate = 0 on lat/lon=" + this.latCoord.getFullName() + ", " + this.latCoord.getFullName());
        }
        return det > 0.0;
    }

    private boolean jumpOld(double wantLat, double wantLon, int[] rectIndex) {
        int row = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        int col = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        double gradientLat = this.latEdge.get(row + 1, col) - this.latEdge.get(row, col);
        double gradientLon = this.lonEdge.get(row, col + 1) - this.lonEdge.get(row, col);
        double diffLat = wantLat - this.latEdge.get(row, col);
        double diffLon = wantLon - this.lonEdge.get(row, col);
        int drow = (int)Math.round(diffLat / gradientLat);
        int dcol = (int)Math.round(diffLon / gradientLon);
        if (debug) {
            System.out.printf("   jump from %d %d (grad=%f %f) (diff=%f %f) (delta=%d %d)", row, col, gradientLat, gradientLon, diffLat, diffLon, drow, dcol);
        }
        if (drow == 0 && dcol == 0) {
            if (debug) {
                System.out.printf("%n   incr:", new Object[0]);
            }
            return this.incr(wantLat, wantLon, rectIndex);
        }
        rectIndex[0] = Math.max(Math.min(row + drow, this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(col + dcol, this.ncols - 1), 0);
        if (debug) {
            System.out.printf(" to (%d %d)%n", rectIndex[0], rectIndex[1]);
        }
        return row != rectIndex[0] || col != rectIndex[1];
    }

    private boolean jump2(double wantLat, double wantLon, int[] rectIndex) {
        int row = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        int col = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        double lat = this.latEdge.get(row, col);
        double lon = this.lonEdge.get(row, col);
        double diffLat = wantLat - lat;
        double diffLon = wantLon - lon;
        double dlatdy = this.latEdge.get(row + 1, col) - lat;
        double dlatdx = this.latEdge.get(row, col + 1) - lat;
        double dlondx = this.lonEdge.get(row, col + 1) - lon;
        double dlondy = this.lonEdge.get(row + 1, col) - lon;
        double dx = (diffLon - dlondy * diffLat / dlatdy) / (dlondx - dlatdx * dlondy / dlatdy);
        double dy = (diffLat - dlatdx * dx) / dlatdy;
        if (debug) {
            System.out.printf("   jump from %d %d (dlondx=%f dlondy=%f dlatdx=%f dlatdy=%f) (diffLat,Lon=%f %f) (deltalat,Lon=%f %f)", row, col, dlondx, dlondy, dlatdx, dlatdy, diffLat, diffLon, dy, dx);
        }
        int drow = (int)Math.round(dy);
        int dcol = (int)Math.round(dx);
        if (drow == 0 && dcol == 0) {
            if (debug) {
                System.out.printf("%n   incr:", new Object[0]);
            }
            return this.incr(wantLat, wantLon, rectIndex);
        }
        rectIndex[0] = Math.max(Math.min(row + drow, this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(col + dcol, this.ncols - 1), 0);
        if (debug) {
            System.out.printf(" to (%d %d)%n", rectIndex[0], rectIndex[1]);
        }
        return row != rectIndex[0] || col != rectIndex[1];
    }

    private boolean incr(double wantLat, double wantLon, int[] rectIndex) {
        int row = rectIndex[0];
        int col = rectIndex[1];
        double diffLat = wantLat - this.latEdge.get(row, col);
        double diffLon = wantLon - this.lonEdge.get(row, col);
        if (Math.abs(diffLat) > Math.abs(diffLon)) {
            rectIndex[0] = row + (diffLat > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
            rectIndex[1] = col + (diffLon > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
        } else {
            rectIndex[1] = col + (diffLon > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
            rectIndex[0] = row + (diffLat > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
        }
        rectIndex[0] = row;
        rectIndex[1] = col;
        return this.box9(wantLat, wantLon, rectIndex);
    }

    private boolean box9(double wantLat, double wantLon, int[] rectIndex) {
        int row = rectIndex[0];
        int minrow = Math.max(row - 1, 0);
        int maxrow = Math.min(row + 1, this.nrows);
        int col = rectIndex[1];
        int mincol = Math.max(col - 1, 0);
        int maxcol = Math.min(col + 1, this.ncols);
        if (debug) {
            System.out.printf("%n   box9:", new Object[0]);
        }
        for (int i = minrow; i <= maxrow; ++i) {
            int j = mincol;
            while (j <= maxcol) {
                rectIndex[0] = i;
                rectIndex[1] = j++;
                if (!this.contains(wantLat, wantLon, rectIndex)) continue;
                return true;
            }
        }
        return false;
    }
}

