/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import javax.annotation.concurrent.Immutable;

@Immutable
public class KMPMatch {
    private final byte[] match;
    private final int[] failure;

    public KMPMatch(byte[] match) {
        this.match = match;
        this.failure = this.computeFailure(match);
    }

    public int getMatchLength() {
        return this.match.length;
    }

    public int indexOf(byte[] data, int start, int max) {
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        if (start + max > data.length) {
            System.out.println("HEY KMPMatch");
        }
        for (int i = start; i < start + max; ++i) {
            while (j > 0 && this.match[j] != data[i]) {
                j = this.failure[j - 1];
            }
            if (this.match[j] == data[i]) {
                ++j;
            }
            if (j != this.match.length) continue;
            return i - this.match.length + 1;
        }
        return -1;
    }

    private int[] computeFailure(byte[] match) {
        int[] result = new int[match.length];
        int j = 0;
        for (int i = 1; i < match.length; ++i) {
            while (j > 0 && match[j] != match[i]) {
                j = result[j - 1];
            }
            if (match[j] == match[i]) {
                // empty if block
            }
            result[i] = ++j;
        }
        return result;
    }
}

