/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoordSysSet;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageReader;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

@Immutable
public class CoverageCollection
implements Closeable,
CoordSysContainer {
    private final String name;
    private final AttributeContainerHelper atts;
    private final LatLonRect latLonBoundingBox;
    private final ProjectionRect projBoundingBox;
    private final CalendarDateRange calendarDateRange;
    private final List<CoordSysSet> coverageSets;
    private final List<CoverageCoordSys> coordSys;
    private final List<CoverageTransform> coordTransforms;
    private final List<CoverageCoordAxis> coordAxes;
    private final Map<String, Coverage> coverageMap = new HashMap<String, Coverage>();
    private final Map<String, CoverageCoordAxis> axisMap = new HashMap<String, CoverageCoordAxis>();
    private final FeatureType coverageType;
    protected final CoverageReader reader;
    protected final HorizCoordSys hcs;

    public CoverageCollection(String name, FeatureType coverageType, AttributeContainerHelper atts, LatLonRect latLonBoundingBox, ProjectionRect projBoundingBox, CalendarDateRange calendarDateRange, List<CoverageCoordSys> coordSys, List<CoverageTransform> coordTransforms, List<CoverageCoordAxis> coordAxes, List<Coverage> coverages, CoverageReader reader) {
        this.name = name;
        this.atts = atts;
        this.calendarDateRange = calendarDateRange;
        this.coverageType = coverageType;
        this.coordSys = coordSys;
        this.coordTransforms = coordTransforms;
        this.coordAxes = coordAxes;
        this.coverageSets = this.wireObjectsTogether(coverages);
        this.hcs = this.wireHorizCoordSys();
        this.reader = reader;
        this.projBoundingBox = this.hcs.isProjection() ? (projBoundingBox != null ? projBoundingBox : this.hcs.calcProjectionBoundingBox()) : null;
        this.latLonBoundingBox = latLonBoundingBox != null ? latLonBoundingBox : this.hcs.calcLatLonBoundingBox();
    }

    private List<CoordSysSet> wireObjectsTogether(List<Coverage> coverages) {
        for (CoverageCoordAxis coverageCoordAxis : this.coordAxes) {
            this.axisMap.put(coverageCoordAxis.getName(), coverageCoordAxis);
        }
        for (CoverageCoordAxis coverageCoordAxis : this.coordAxes) {
            coverageCoordAxis.setDataset(this);
        }
        HashMap<String, CoordSysSet> map = new HashMap<String, CoordSysSet>();
        for (Coverage coverage : coverages) {
            this.coverageMap.put(coverage.getName(), coverage);
            CoordSysSet gset = (CoordSysSet)map.get(coverage.getCoordSysName());
            if (gset == null) {
                CoverageCoordSys ccsys = this.findCoordSys(coverage.getCoordSysName());
                if (ccsys == null) {
                    throw new IllegalStateException("Cant find " + coverage.getCoordSysName());
                }
                gset = new CoordSysSet(ccsys);
                map.put(coverage.getCoordSysName(), gset);
                gset.getCoordSys().setDataset(this);
            }
            gset.addCoverage(coverage);
            coverage.setCoordSys(gset.getCoordSys());
        }
        ArrayList<CoordSysSet> arrayList = new ArrayList<CoordSysSet>(map.values());
        Collections.sort(arrayList, (o1, o2) -> o1.getCoordSys().getName().compareTo(o2.getCoordSys().getName()));
        return arrayList;
    }

    private HorizCoordSys wireHorizCoordSys() {
        CoverageCoordSys csys1 = this.coordSys.get(0);
        HorizCoordSys hcs = csys1.makeHorizCoordSys();
        for (CoverageCoordSys csys : this.coordSys) {
            csys.setHorizCoordSys(hcs);
            csys.setImmutable();
        }
        return hcs;
    }

    public String getName() {
        return this.name;
    }

    public List<Attribute> getGlobalAttributes() {
        return this.atts.getAttributes();
    }

    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.atts.findAttValueIgnoreCase(attName, defaultValue);
    }

    public Attribute findAttribute(String attName) {
        return this.atts.findAttribute(attName);
    }

    public Attribute findAttributeIgnoreCase(String attName) {
        return this.atts.findAttributeIgnoreCase(attName);
    }

    public LatLonRect getLatlonBoundingBox() {
        return this.latLonBoundingBox;
    }

    public ProjectionRect getProjBoundingBox() {
        return this.projBoundingBox;
    }

    public CalendarDateRange getCalendarDateRange() {
        return this.calendarDateRange;
    }

    public Calendar getCalendar() {
        if (this.calendarDateRange != null) {
            return this.calendarDateRange.getStart().getCalendar();
        }
        return Calendar.getDefault();
    }

    public Iterable<Coverage> getCoverages() {
        return this.coverageMap.values();
    }

    public int getCoverageCount() {
        return this.coverageMap.values().size();
    }

    public FeatureType getCoverageType() {
        return this.coverageType;
    }

    public List<CoordSysSet> getCoverageSets() {
        return this.coverageSets;
    }

    public List<CoverageCoordSys> getCoordSys() {
        return this.coordSys;
    }

    public List<CoverageTransform> getCoordTransforms() {
        return this.coordTransforms != null ? this.coordTransforms : new ArrayList<CoverageTransform>();
    }

    public List<CoverageCoordAxis> getCoordAxes() {
        return this.coordAxes;
    }

    public HorizCoordSys getHorizCoordSys() {
        return this.hcs;
    }

    public CoverageReader getReader() {
        return this.reader;
    }

    public String toString() {
        Formatter f = new Formatter();
        this.toString(f);
        return f.toString();
    }

    public void toString(Formatter f) {
        Indent indent = new Indent(2);
        f.format("%sGridDatasetCoverage %s%n", indent, this.name);
        f.format("%s Global attributes:%n", indent);
        for (Attribute att : this.atts.getAttributes()) {
            f.format("%s  %s%n", indent, att);
        }
        f.format("%s Date Range:%s%n", indent, this.calendarDateRange);
        f.format("%s LatLon BoundingBox:%s%n", indent, this.latLonBoundingBox);
        if (this.projBoundingBox != null) {
            f.format("%s Projection BoundingBox:%s%n", indent, this.projBoundingBox);
        }
        f.format("%n%s Coordinate Systems:%n", indent);
        for (CoverageCoordSys cs : this.coordSys) {
            cs.toString(f, indent);
        }
        f.format("%s Coordinate Transforms:%n", indent);
        for (CoverageTransform t : this.coordTransforms) {
            t.toString(f, indent);
        }
        f.format("%s Coordinate Axes:%n", indent);
        for (CoverageCoordAxis a : this.coordAxes) {
            a.toString(f, indent);
        }
        f.format("%n%s Grids:%n", indent);
        for (Coverage grid : this.getCoverages()) {
            grid.toString(f, indent);
        }
    }

    public Coverage findCoverage(String name) {
        return this.coverageMap.get(name);
    }

    public Coverage findCoverageByAttribute(String attName, String attValue) {
        for (Coverage cov : this.coverageMap.values()) {
            for (Attribute att : cov.getAttributes()) {
                if (!attName.equals(att.getShortName()) || !attValue.equals(att.getStringValue())) continue;
                return cov;
            }
        }
        return null;
    }

    public CoverageCoordSys findCoordSys(String name) {
        for (CoverageCoordSys gcs : this.coordSys) {
            if (!gcs.getName().equalsIgnoreCase(name)) continue;
            return gcs;
        }
        return null;
    }

    @Override
    public CoverageCoordAxis findCoordAxis(String name) {
        return this.axisMap.get(name);
    }

    @Override
    public CoverageTransform findCoordTransform(String name) {
        for (CoverageTransform ct : this.coordTransforms) {
            if (!ct.getName().equalsIgnoreCase(name)) continue;
            return ct;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

