/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataScalar;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.VariableSimpleImpl;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFPointCollection
extends CFPointWriter {
    private int obsRecno = 0;

    public WriterCFPointCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.point.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Point Data, H.1"));
    }

    public void writeHeader(PointFeature pf) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleImpl.makeScalar("time", "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).add(new Attribute("calendar", this.timeUnit.getCalendar().toString())));
        coords.add(VariableSimpleImpl.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE));
        coords.add(VariableSimpleImpl.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE));
        Formatter coordNames = new Formatter().format("%s %s %s", "time", "latitude", "longitude");
        if (this.altUnits != null) {
            coords.add(VariableSimpleImpl.makeScalar("altitude", "altitude of measurement", this.altUnits, DataType.DOUBLE).add(new Attribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits))));
            coordNames.format(" %s", "altitude");
        }
        super.writeHeader(coords, null, pf.getDataAll(), coordNames.toString());
    }

    @Override
    protected void makeFeatureVariables(StructureData featureData, boolean isExtended) throws IOException {
    }

    public void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc.getLatLon(), obsDate);
        StructureDataScalar coords = new StructureDataScalar("Coords");
        coords.addMember("time", null, null, DataType.DOUBLE, timeCoordValue);
        coords.addMember("latitude", null, null, DataType.DOUBLE, loc.getLatitude());
        coords.addMember("longitude", null, null, DataType.DOUBLE, loc.getLongitude());
        if (this.altUnits != null) {
            coords.addMember("altitude", null, null, DataType.DOUBLE, loc.getAltitude());
        }
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(coords);
        sdall.add(sdata);
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

