/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.EnhanceScaleMissingUnsignedImpl;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.CancelTask;

public class VariableDS
extends Variable
implements VariableEnhanced,
EnhanceScaleMissingUnsigned {
    private EnhancementsImpl enhanceProxy;
    private EnhanceScaleMissingUnsignedImpl scaleMissingUnsignedProxy = new EnhanceScaleMissingUnsignedImpl();
    private Set<NetcdfDataset.Enhance> enhanceMode = EnumSet.noneOf(NetcdfDataset.Enhance.class);
    protected Variable orgVar;
    protected DataType orgDataType;
    protected String orgName;

    public VariableDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDataType(dataType);
        this.setDimensions(dims);
        this.orgDataType = dataType;
        if (dataType == DataType.STRUCTURE) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + shortName);
        }
        if (units != null) {
            this.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
        this.enhanceProxy = new EnhancementsImpl(this, units, desc);
    }

    public VariableDS(Group group, Structure parent, String shortName, Variable orgVar) {
        super(null, group, parent, shortName);
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.enhanceProxy = new EnhancementsImpl(this);
    }

    public VariableDS(Group g, Variable orgVar, boolean enhance) {
        super(orgVar);
        if (g != null) {
            this.setParentGroup(g);
        }
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.enhanceProxy = new EnhancementsImpl(this);
        if (enhance) {
            this.enhance(NetcdfDataset.getDefaultEnhanceMode());
        }
    }

    protected VariableDS(VariableDS vds, boolean isCopy) {
        super(vds);
        this.orgVar = vds;
        this.orgDataType = vds.orgDataType;
        this.orgName = vds.orgName;
        this.enhanceProxy = new EnhancementsImpl(this);
        this.scaleMissingUnsignedProxy = vds.scaleMissingUnsignedProxy;
        if (!isCopy) {
            this.createNewCache();
        }
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.group.getNetcdfFile();
    }

    @Override
    protected Variable copy() {
        return new VariableDS(this, true);
    }

    @Override
    public void clearCoordinateSystems() {
        this.enhanceProxy = new EnhancementsImpl(this, this.getUnitsString(), this.getDescription());
    }

    @Override
    public void enhance(Set<NetcdfDataset.Enhance> enhancements) {
        this.enhanceMode = EnumSet.copyOf(enhancements);
        if (this.orgVar instanceof VariableDS) {
            for (NetcdfDataset.Enhance orgVarEnhancement : ((VariableDS)this.orgVar).getEnhanceMode()) {
                this.enhanceMode.remove((Object)orgVarEnhancement);
            }
        }
        this.setDataType(this.orgDataType);
        this.scaleMissingUnsignedProxy = new EnhanceScaleMissingUnsignedImpl(this);
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.dataType.isEnum()) {
            this.setDataType(DataType.STRING);
            return;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned)) {
            this.setDataType(this.scaleMissingUnsignedProxy.getUnsignedConversionType());
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && (this.dataType.isNumeric() || this.dataType == DataType.CHAR) && this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            this.setDataType(this.scaleMissingUnsignedProxy.getScaledOffsetType());
        }
    }

    boolean needConvert() {
        Set<NetcdfDataset.Enhance> enhancements = this.getEnhanceMode();
        return enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) || enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing);
    }

    Array convert(Array data) {
        return this.convert(data, this.enhanceMode);
    }

    Array convert(Array data, Set<NetcdfDataset.Enhance> enhancements) {
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.orgDataType.isEnum()) {
            return this.convertEnums(data);
        }
        return this.scaleMissingUnsignedProxy.convert(data, enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned), enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset), enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing));
    }

    private Array convertEnums(Array values) {
        if (!values.getDataType().isIntegral()) {
            return values;
        }
        Array result = Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            String sval = this.lookupEnumString(values.nextInt());
            ii.setObjectNext(sval);
        }
        return result;
    }

    @Nonnull
    public Set<NetcdfDataset.Enhance> getEnhanceMode() {
        if (!(this.orgVar instanceof VariableDS)) {
            return Collections.unmodifiableSet(this.enhanceMode);
        }
        VariableDS orgVarDS = (VariableDS)this.orgVar;
        return Sets.union(this.enhanceMode, orgVarDS.getEnhanceMode());
    }

    public boolean addEnhancement(NetcdfDataset.Enhance enhancement) {
        if (this.enhanceMode.add(enhancement)) {
            this.enhance(this.enhanceMode);
            return true;
        }
        return false;
    }

    public boolean removeEnhancement(NetcdfDataset.Enhance enhancement) {
        if (this.enhanceMode.remove((Object)enhancement)) {
            this.enhance(this.enhanceMode);
            return true;
        }
        return false;
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    public void setOriginalVariable(Variable orgVar) {
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.orgVar = orgVar;
    }

    public DataType getOriginalDataType() {
        return this.orgDataType != null ? this.orgDataType : this.getDataType();
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public String lookupEnumString(int val) {
        if (this.dataType.isEnum()) {
            return super.lookupEnumString(val);
        }
        return this.orgVar.lookupEnumString(val);
    }

    @Override
    public String setName(String newName) {
        this.orgName = this.getShortName();
        super.setShortName(newName);
        return newName;
    }

    @Override
    public String toStringDebug() {
        return this.orgVar != null ? this.orgVar.toStringDebug() : "";
    }

    @Override
    public String getDatasetLocation() {
        String result = super.getDatasetLocation();
        if (result != null) {
            return result;
        }
        if (this.orgVar != null) {
            return this.orgVar.getDatasetLocation();
        }
        return null;
    }

    public boolean hasCachedDataRecurse() {
        return super.hasCachedData() || this.orgVar != null && this.orgVar.hasCachedData();
    }

    @Override
    public void setCaching(boolean caching) {
        if (caching && this.orgVar != null) {
            this.orgVar.setCaching(true);
        }
    }

    @Override
    protected Array _read() throws IOException {
        Array result = this.hasCachedData() ? super._read() : this.proxyReader.reallyRead(this, null);
        return this.convert(result);
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.orgVar == null) {
            return this.getMissingDataArray(this.shape);
        }
        return this.orgVar.read();
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        Array result = this.hasCachedData() ? super._read(section) : this.proxyReader.reallyRead(this, section, null);
        return this.convert(result);
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.reallyRead(client, cancelTask);
        }
        if (this.orgVar == null) {
            return this.getMissingDataArray(section.getShape());
        }
        return this.orgVar.read(section);
    }

    @Override
    public long readToStream(Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.orgVar == null) {
            return super.readToStream(section, out);
        }
        return this.orgVar.readToStream(section, out);
    }

    public Array getMissingDataArray(int[] shape) {
        Object[] storage;
        switch (this.getDataType()) {
            case BOOLEAN: {
                storage = new boolean[1];
                break;
            }
            case BYTE: 
            case UBYTE: 
            case ENUM1: {
                storage = new byte[1];
                break;
            }
            case CHAR: {
                storage = new char[1];
                break;
            }
            case SHORT: 
            case USHORT: 
            case ENUM2: {
                storage = new short[1];
                break;
            }
            case INT: 
            case UINT: 
            case ENUM4: {
                storage = new int[1];
                break;
            }
            case LONG: 
            case ULONG: {
                storage = new long[1];
                break;
            }
            case FLOAT: {
                storage = new float[1];
                break;
            }
            case DOUBLE: {
                storage = new double[1];
                break;
            }
            default: {
                storage = new Object[1];
            }
        }
        Array array = Array.factoryConstant(this.getDataType(), shape, storage);
        array.setObject(0, (Object)this.scaleMissingUnsignedProxy.getFillValue());
        return array;
    }

    public void showScaleMissingProxy(Formatter f) {
        f.format("has missing = %s%n", this.scaleMissingUnsignedProxy.hasMissing());
        if (this.scaleMissingUnsignedProxy.hasMissing()) {
            if (this.scaleMissingUnsignedProxy.hasMissingValue()) {
                f.format("   missing value(s) = ", new Object[0]);
                for (double d : this.scaleMissingUnsignedProxy.getMissingValues()) {
                    f.format(" %f", d);
                }
                f.format("%n", new Object[0]);
            }
            if (this.scaleMissingUnsignedProxy.hasFillValue()) {
                f.format("   fillValue = %f%n", this.scaleMissingUnsignedProxy.getFillValue());
            }
            if (this.scaleMissingUnsignedProxy.hasValidData()) {
                f.format("   valid min/max = [%f,%f]%n", this.scaleMissingUnsignedProxy.getValidMin(), this.scaleMissingUnsignedProxy.getValidMax());
            }
        }
        f.format("FillValue or default = %s%n", this.scaleMissingUnsignedProxy.getFillValue());
        f.format("%nhas scale/offset = %s%n", this.scaleMissingUnsignedProxy.hasScaleOffset());
        if (this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            double offset = this.scaleMissingUnsignedProxy.applyScaleOffset(0.0);
            double scale = this.scaleMissingUnsignedProxy.applyScaleOffset(1.0) - offset;
            f.format("   scale_factor = %f add_offset = %f%n", scale, offset);
        }
        f.format("original data type = %s%n", new Object[]{this.orgDataType});
        f.format("converted data type = %s%n", new Object[]{this.getDataType()});
    }

    @Override
    public String getDescription() {
        return this.enhanceProxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.enhanceProxy.getUnitsString();
    }

    @Override
    public void setUnitsString(String units) {
        this.enhanceProxy.setUnitsString(units);
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.enhanceProxy.getCoordinateSystems();
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem cs) {
        this.enhanceProxy.addCoordinateSystem(cs);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem cs) {
        this.enhanceProxy.removeCoordinateSystem(cs);
    }

    @Override
    public boolean hasScaleOffset() {
        return this.scaleMissingUnsignedProxy.hasScaleOffset();
    }

    @Override
    public double getScaleFactor() {
        return this.scaleMissingUnsignedProxy.getScaleFactor();
    }

    @Override
    public double getOffset() {
        return this.scaleMissingUnsignedProxy.getOffset();
    }

    @Override
    public boolean hasMissing() {
        return this.scaleMissingUnsignedProxy.hasMissing();
    }

    @Override
    public boolean isMissing(double val) {
        return this.scaleMissingUnsignedProxy.isMissing(val);
    }

    @Override
    public boolean hasValidData() {
        return this.scaleMissingUnsignedProxy.hasValidData();
    }

    @Override
    public double getValidMin() {
        return this.scaleMissingUnsignedProxy.getValidMin();
    }

    @Override
    public double getValidMax() {
        return this.scaleMissingUnsignedProxy.getValidMax();
    }

    @Override
    public boolean isInvalidData(double val) {
        return this.scaleMissingUnsignedProxy.isInvalidData(val);
    }

    @Override
    public boolean hasFillValue() {
        return this.scaleMissingUnsignedProxy.hasFillValue();
    }

    @Override
    public double getFillValue() {
        return this.scaleMissingUnsignedProxy.getFillValue();
    }

    @Override
    public boolean isFillValue(double val) {
        return this.scaleMissingUnsignedProxy.isFillValue(val);
    }

    @Override
    public boolean hasMissingValue() {
        return this.scaleMissingUnsignedProxy.hasMissingValue();
    }

    @Override
    public double[] getMissingValues() {
        return this.scaleMissingUnsignedProxy.getMissingValues();
    }

    @Override
    public boolean isMissingValue(double val) {
        return this.scaleMissingUnsignedProxy.isMissingValue(val);
    }

    @Override
    public void setFillValueIsMissing(boolean b) {
        this.scaleMissingUnsignedProxy.setFillValueIsMissing(b);
    }

    @Override
    public void setInvalidDataIsMissing(boolean b) {
        this.scaleMissingUnsignedProxy.setInvalidDataIsMissing(b);
    }

    @Override
    public void setMissingDataIsMissing(boolean b) {
        this.scaleMissingUnsignedProxy.setMissingDataIsMissing(b);
    }

    @Override
    @Nullable
    public DataType getScaledOffsetType() {
        return this.scaleMissingUnsignedProxy.getScaledOffsetType();
    }

    @Override
    @Nonnull
    public DataType getUnsignedConversionType() {
        return this.scaleMissingUnsignedProxy.getUnsignedConversionType();
    }

    @Override
    public DataType.Signedness getSignedness() {
        return this.scaleMissingUnsignedProxy.getSignedness();
    }

    @Override
    public double applyScaleOffset(Number value) {
        return this.scaleMissingUnsignedProxy.applyScaleOffset(value);
    }

    @Override
    public Array applyScaleOffset(Array data) {
        return this.scaleMissingUnsignedProxy.applyScaleOffset(data);
    }

    @Override
    public Number convertUnsigned(Number value) {
        return this.scaleMissingUnsignedProxy.convertUnsigned(value);
    }

    @Override
    public Array convertUnsigned(Array in) {
        return this.scaleMissingUnsignedProxy.convertUnsigned(in);
    }

    @Override
    public Number convertMissing(Number value) {
        return this.scaleMissingUnsignedProxy.convertMissing(value);
    }

    @Override
    public Array convertMissing(Array in) {
        return this.scaleMissingUnsignedProxy.convertMissing(in);
    }

    @Override
    public Array convert(Array in, boolean convertUnsigned, boolean applyScaleOffset, boolean convertMissing) {
        return this.scaleMissingUnsignedProxy.convert(in, convertUnsigned, applyScaleOffset, convertMissing);
    }
}

