/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.RangeIterator;
import ucar.nc2.util.Misc;

@Immutable
public class RangeScatter
implements RangeIterator {
    private final int[] vals;
    private final String name;

    public RangeScatter(String name, int ... val) throws InvalidRangeException {
        this.name = name;
        this.vals = val;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RangeIterator setName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        try {
            return new RangeScatter(name, this.vals);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int length() {
        return this.vals.length;
    }

    public String toString() {
        return "{" + Misc.showInts(this.vals) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeScatter that = (RangeScatter)o;
        return Arrays.equals(this.vals, that.vals);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vals);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ScatterIterator();
    }

    private class ScatterIterator
    implements Iterator<Integer> {
        private int current = 0;

        private ScatterIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < RangeScatter.this.vals.length;
        }

        @Override
        public Integer next() {
            return RangeScatter.this.vals[this.current++];
        }
    }
}

