/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamCompressedOutputStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamCompression {
    NcStreamProto.Compress type;
    Object compressInfo;

    private NcStreamCompression(NcStreamProto.Compress type, Object info) {
        this.type = type;
        this.compressInfo = info;
    }

    private NcStreamCompression(NcStreamProto.Compress type) {
        this(type, null);
    }

    public static NcStreamCompression none() {
        return new NcStreamCompression(NcStreamProto.Compress.NONE);
    }

    public static NcStreamCompression deflate() {
        return NcStreamCompression.deflate(-1);
    }

    public static NcStreamCompression deflate(int level) {
        return new NcStreamCompression(NcStreamProto.Compress.DEFLATE, level);
    }

    public DataOutputStream setupStream(OutputStream out, int size) throws IOException {
        switch (this.type) {
            case DEFLATE: {
                int level = Math.min(Math.max((Integer)this.compressInfo, -1), 9);
                int bufferSize = Math.min(size / 2, 0x20000000);
                return new NcStreamCompressedOutputStream(out, bufferSize, level);
            }
            default: {
                System.out.printf(" Unknown compression type %s. Defaulting to none.%n", new Object[]{this.type});
            }
            case NONE: 
        }
        DataOutputStream dos = new DataOutputStream(out);
        NcStream.writeVInt(dos, size);
        return dos;
    }
}

