/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nids;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBBpos;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.nids.Nidsheader;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Nidsiosp
extends AbstractIOServiceProvider {
    protected boolean readonly;
    protected Nidsheader headerParser;
    private int pcode;
    static final int Z_DEFLATED = 8;
    static final int DEF_WBITS = 15;
    protected int fileUsed = 0;
    protected int recStart = 0;
    protected boolean debug = false;
    protected boolean debugSize = false;
    protected boolean debugSPIO = false;
    protected boolean showHeaderBytes = false;
    protected boolean fill;
    protected HashMap dimHash = new HashMap(50);

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        Nidsheader localHeader = new Nidsheader();
        return localHeader.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.NIDS.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "NEXRAD Level-III (NIDS) Products";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.headerParser = new Nidsheader();
        this.headerParser.read(this.raf, ncfile);
        this.pcode = this.headerParser.pcode;
        ncfile.finish();
    }

    public Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Structure vp = v2.getParentStructure();
        List<Range> ranges = section.getRanges();
        Nidsheader.Vinfo vinfo = (Nidsheader.Vinfo)vp.getSPobject();
        byte[] vdata = this.headerParser.getUncompData((int)vinfo.doff, 0);
        ByteBuffer bos = ByteBuffer.wrap(vdata);
        if (vp.getShortName().startsWith("VADWindSpeed")) {
            return this.readNestedWindBarbData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getShortName().startsWith("unlinkedVectorStruct")) {
            return this.readNestedDataUnlinkVector(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getShortName().equals("linkedVectorStruct")) {
            return this.readNestedLinkedVectorData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getShortName().startsWith("textStruct")) {
            return this.readNestedTextStringData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getShortName().startsWith("VectorArrow")) {
            return this.readNestedVectorArrowData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        if (vp.getShortName().startsWith("circleStruct")) {
            return this.readNestedCircleStructData(vp.getShortName(), v2.getShortName(), bos, vinfo, ranges);
        }
        throw new UnsupportedOperationException("Unknown nested variable " + v2.getShortName());
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Array outputData;
        List<Range> ranges = section.getRanges();
        Nidsheader.Vinfo vinfo = (Nidsheader.Vinfo)v2.getSPobject();
        byte[] vdata = this.headerParser.getUncompData((int)vinfo.doff, 0);
        ByteBuffer bos = ByteBuffer.wrap(vdata);
        if (v2.getShortName().equals("azimuth")) {
            Object data = this.pcode == 176 ? this.readOneScanGenericData(bos, vinfo, v2.getShortName()) : this.readRadialDataAzi(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("gate")) {
            Object data = this.readRadialDataGate(vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("elevation")) {
            Object data = this.readRadialDataEle(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("latitude")) {
            double lat = this.ncfile.findGlobalAttribute("RadarLatitude").getNumericValue().doubleValue();
            Object data = this.readRadialDataLatLonAlt(lat, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("longitude")) {
            double lon = this.ncfile.findGlobalAttribute("RadarLongitude").getNumericValue().doubleValue();
            Object data = this.readRadialDataLatLonAlt(lon, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("altitude")) {
            double alt = this.ncfile.findGlobalAttribute("RadarAltitude").getNumericValue().doubleValue();
            Object data = this.readRadialDataLatLonAlt(alt, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("distance")) {
            Object data = this.readDistance(vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("rays_time")) {
            String rt = this.ncfile.findGlobalAttribute("time_coverage_start").getStringValue();
            Date pDate = DateUnit.getStandardOrISO(rt);
            double lt = pDate.getTime();
            double[] dd = new double[vinfo.yt];
            for (int radial = 0; radial < vinfo.yt; ++radial) {
                dd[radial] = (float)lt;
            }
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), (Object)dd);
        } else if (v2.getShortName().startsWith("EchoTop") || v2.getShortName().startsWith("VertLiquid") || v2.getShortName().startsWith("BaseReflectivityComp") || v2.getShortName().startsWith("LayerCompReflect")) {
            Object data = this.readOneArrayData(bos, vinfo, v2.getShortName());
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().startsWith("PrecipArray")) {
            Object data = this.readOneArrayData1(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().startsWith("Precip") && !vinfo.isRadial) {
            Object data = this.readOneArrayData(bos, vinfo, v2.getShortName());
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().equals("unlinkedVectorStruct")) {
            outputData = this.readUnlinkedVectorData(v2.getShortName(), bos, vinfo);
        } else if (v2.getShortName().equals("linkedVectorStruct")) {
            outputData = this.readLinkedVectorData(v2.getShortName(), bos, vinfo);
        } else if (v2.getShortName().startsWith("textStruct")) {
            outputData = this.readTextStringData(v2.getShortName(), bos, vinfo);
        } else if (v2.getShortName().startsWith("VADWindSpeed")) {
            outputData = this.readWindBarbData(v2.getShortName(), bos, vinfo, null);
        } else if (v2.getShortName().startsWith("VectorArrow")) {
            outputData = this.readVectorArrowData(v2.getShortName(), bos, vinfo);
        } else if (v2.getShortName().startsWith("TabMessagePage")) {
            Object data = this.readTabAlphaNumData(bos, vinfo);
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else if (v2.getShortName().startsWith("circleStruct")) {
            outputData = this.readCircleStructData(v2.getShortName(), bos, vinfo);
        } else if (v2.getShortName().startsWith("hail") || v2.getShortName().startsWith("TVS")) {
            outputData = this.readGraphicSymbolData(v2.getShortName(), bos, vinfo);
        } else if (v2.getShortName().startsWith("DigitalInstantaneousPrecipitationRate")) {
            Object data = this.readOneScanGenericData(bos, vinfo, v2.getShortName());
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        } else {
            Object data = this.readOneScanData(bos, vinfo, v2.getShortName());
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        }
        return outputData.sectionNoReduce(ranges);
    }

    public Array readNestedGraphicSymbolData(String name, StructureMembers.Member m, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readCircleStructData(name, bos, vinfo);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readGraphicSymbolData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] dlen = vinfo.len;
        int size = pos.length;
        int vlen = 0;
        for (int i = 0; i < size; ++i) {
            vlen += dlen[i];
        }
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("x_start");
        members.findMember("y_start");
        ArrayStructureW asw = new ArrayStructureW(members, new int[]{vlen});
        int ii = 0;
        for (int i = 0; i < size; ++i) {
            bos.position(pos[i]);
            for (int j = 0; j < dlen[i]; ++j) {
                StructureDataW sdata = new StructureDataW(asw.getStructureMembers());
                Iterator<StructureMembers.Member> memberIter = sdata.getMembers().iterator();
                ArrayFloat.D0 sArray = new ArrayFloat.D0();
                sArray.set((float)bos.getShort() / 4.0f);
                sdata.setMemberData(memberIter.next(), (Array)sArray);
                sArray = new ArrayFloat.D0();
                sArray.set((float)bos.getShort() / 4.0f);
                sdata.setMemberData(memberIter.next(), (Array)sArray);
                asw.setStructureData(sdata, ii);
                ++ii;
            }
        }
        return asw;
    }

    public Array readNestedLinkedVectorData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readLinkedVectorData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readLinkedVectorData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] dlen = vinfo.len;
        bos.position(0);
        int size = pos.length;
        int vlen = 0;
        for (int i = 0; i < size; ++i) {
            vlen += dlen[i];
        }
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        short sValue = 0;
        int ii = 0;
        short[][] sArray = new short[5][vlen];
        for (int i = 0; i < size; ++i) {
            bos.position(pos[i]);
            if (vinfo.code == 9) {
                sValue = bos.getShort();
            }
            short istart = bos.getShort();
            short jstart = bos.getShort();
            for (int j = 0; j < dlen[i]; ++j) {
                short iend = bos.getShort();
                short jend = bos.getShort();
                if (vinfo.code == 9) {
                    sArray[0][ii] = sValue;
                }
                sArray[1][ii] = istart;
                sArray[2][ii] = jstart;
                sArray[3][ii] = iend;
                sArray[4][ii] = jend;
                ++ii;
            }
        }
        ArrayStructureMA asma = new ArrayStructureMA(members, new int[]{vlen});
        Array data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[0]);
        StructureMembers.Member m = members.findMember("sValue");
        if (m != null) {
            m.setDataArray(data);
        }
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[1]);
        m = members.findMember("x_start");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[2]);
        m = members.findMember("y_start");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[3]);
        m = members.findMember("x_end");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[4]);
        m = members.findMember("y_end");
        m.setDataArray(data);
        return asma;
    }

    public Array readNestedCircleStructData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readCircleStructData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readCircleStructData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        int recsize = pos[1] - pos[0];
        for (int i = 1; i < size; ++i) {
            int r = pos[i] - pos[i - 1];
            if (r == recsize) continue;
            System.out.println(" PROBLEM at " + i + " == " + r);
        }
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("x_center").setDataParam(0);
        members.findMember("y_center").setDataParam(2);
        members.findMember("radius").setDataParam(4);
        members.setStructureSize(recsize);
        return new ArrayStructureBBpos(members, new int[]{size}, bos, pos);
    }

    public Object readTabAlphaNumData(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int plen = vinfo.xt;
        int tablen = vinfo.yt;
        String[] pdata = new String[plen];
        bos.position(0);
        int ipage = 0;
        int icnt = 4;
        StringBuilder sbuf = new StringBuilder();
        while (ipage < plen && tablen > 128 + icnt) {
            short llen = bos.getShort();
            if (llen == -1) {
                pdata[ipage] = new String(sbuf);
                sbuf = new StringBuilder();
                ++ipage;
                icnt += 2;
                continue;
            }
            byte[] b = new byte[llen];
            bos.get(b);
            String sl = new String(b, CDM.utf8Charset) + "\n";
            sbuf.append(sl);
            icnt = icnt + llen + 2;
        }
        return pdata;
    }

    public Object readOneScanGenericData(ByteBuffer bos, Nidsheader.Vinfo vinfo, String vName) throws IOException, InvalidRangeException {
        int npixel = 0;
        short[] pdata = null;
        bos.position(0);
        int numRadials = vinfo.yt;
        float[] angleData = new float[numRadials];
        for (int k = 0; k < numRadials; ++k) {
            angleData[k] = bos.getFloat();
            bos.getFloat();
            bos.getFloat();
            bos.getInt();
            Nidsheader.readInString(bos);
            int numBins0 = bos.getInt();
            if (pdata == null) {
                npixel = numRadials * numBins0;
                pdata = new short[npixel];
            }
            for (int l = 0; l < numBins0; ++l) {
                pdata[k * numBins0 + l] = (short)bos.getInt();
            }
        }
        if (vName.endsWith("_RAW")) {
            return pdata;
        }
        if (vName.startsWith("azimuth")) {
            return angleData;
        }
        if (vName.startsWith("DigitalInstantaneousPrecipitationRate")) {
            int[] levels = vinfo.len;
            int scale = levels[0];
            int offset = levels[1];
            float[] fdata = new float[npixel];
            for (int i = 0; i < npixel; ++i) {
                short ival = pdata[i];
                fdata[i] = ival != 0 ? (float)(ival - offset) * 1.0f / (float)scale : Float.NaN;
            }
            return fdata;
        }
        return null;
    }

    public Object readOneScanData(ByteBuffer bos, Nidsheader.Vinfo vinfo, String vName) throws IOException, InvalidRangeException {
        float[] fdata;
        float[] fdata2;
        int i;
        int doff = 0;
        int npixel = vinfo.yt * vinfo.xt;
        byte[] odata = new byte[vinfo.xt];
        byte[] pdata = new byte[npixel];
        bos.position(0);
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            short runLen = bos.getShort();
            doff += 2;
            if (vinfo.isRadial) {
                short radialAngle = bos.getShort();
                doff += 2;
                short radialAngleD = bos.getShort();
                doff += 2;
            }
            byte[] rdata = null;
            byte[] bdata = null;
            if (vinfo.xt != runLen) {
                rdata = new byte[runLen * 2];
                bos.get(rdata, 0, runLen * 2);
                doff += runLen * 2;
                bdata = this.readOneBeamData(rdata, runLen, vinfo.xt, vinfo.level);
            } else {
                rdata = new byte[runLen];
                bos.get(rdata, 0, runLen);
                doff += runLen;
                bdata = (byte[])rdata.clone();
            }
            if (vinfo.x0 > 0) {
                for (i = 0; i < vinfo.x0; ++i) {
                    odata[i] = 0;
                }
            }
            System.arraycopy(bdata, 0, odata, vinfo.x0, bdata.length);
            System.arraycopy(odata, 0, pdata, vinfo.xt * radial, vinfo.xt);
        }
        int offset = 0;
        if (vName.endsWith("_RAW")) {
            return pdata;
        }
        if (vName.startsWith("DifferentialReflectivity") || vName.startsWith("CorrelationCoefficient") || vName.startsWith("DifferentialPhase")) {
            int[] levels = vinfo.len;
            int scale = levels[0];
            offset = levels[1];
            float isc = vinfo.code;
            float[] fdata3 = new float[npixel];
            for (int i2 = 0; i2 < npixel; ++i2) {
                short ival = DataType.unsignedByteToShort(pdata[i2]);
                fdata3[i2] = ival != 2 && ival != 0 && ival != 1 ? ((float)ival * isc - (float)offset) / (float)scale : Float.NaN;
            }
            return fdata3;
        }
        if (vName.startsWith("DigitalAccumulationArray") || vName.startsWith("Digital1HourDifferenceAccumulation") || vName.startsWith("DigitalStormTotalAccumulation") || vName.startsWith("Accumulation3Hour") || vName.startsWith("DigitalTotalDifferenceAccumulation")) {
            int[] levels = vinfo.len;
            int scale = levels[0];
            offset = levels[1];
            float isc = vinfo.code;
            float[] fdata4 = new float[npixel];
            for (int i3 = 0; i3 < npixel; ++i3) {
                short ival = DataType.unsignedByteToShort(pdata[i3]);
                fdata4[i3] = ival != 0 && ival != 1 ? ((float)ival * 1.0f - (float)offset * 1.0f / isc) / ((float)scale * 1.0f) : Float.NaN;
            }
            return fdata4;
        }
        if (vName.startsWith("HypridHydrometeorClassification") || vName.startsWith("HydrometeorClassification")) {
            int[] levels = vinfo.len;
            int scale = levels[0];
            offset = levels[1];
            fdata2 = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                short ival = DataType.unsignedByteToShort(pdata[i]);
                fdata2[i] = ival != 0 ? (float)ival : Float.NaN;
            }
            return fdata2;
        }
        if (vName.startsWith("BaseReflectivity") || vName.startsWith("BaseVelocity")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            fdata2 = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[DataType.unsignedByteToShort(pdata[i])];
                fdata2[i] = ival > -9997 && ival != -9866 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata2;
        }
        if (vName.startsWith("DigitalHybridReflectivity")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            fdata2 = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[DataType.unsignedByteToShort(pdata[i])];
                fdata2[i] = ival != levels[0] && ival != levels[1] ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata2;
        }
        if (vName.startsWith("RadialVelocity") || vName.startsWith("SpectrumWidth")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            fdata2 = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[DataType.unsignedByteToShort(pdata[i])];
                fdata2[i] = ival > -9996 && ival != -9866 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata2;
        }
        if (vName.startsWith("StormMeanVelocity")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            fdata2 = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[pdata[i]];
                fdata2[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata2;
        }
        if (vName.startsWith("Precip") || vName.startsWith("DigitalPrecip") || vName.startsWith("OneHourAccumulation") || vName.startsWith("StormTotalAccumulation")) {
            int[] levels = vinfo.len;
            int iscale = vinfo.code;
            fdata2 = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = pdata[i] < 0 ? -9997 : levels[pdata[i]];
                fdata2[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata2;
        }
        if (vName.startsWith("EnhancedEchoTop")) {
            int[] levels = vinfo.len;
            fdata = new float[npixel];
            for (int i4 = 0; i4 < npixel; ++i4) {
                short ival = DataType.unsignedByteToShort(pdata[i4]);
                fdata[i4] = ival == 0 || ival == 1 ? Float.NaN : (float)(ival & levels[0]) / (float)levels[1] - (float)levels[2];
            }
            return fdata;
        }
        if (vName.startsWith("DigitalIntegLiquid")) {
            int[] levels = vinfo.len;
            fdata = new float[npixel];
            float a = this.getHexDecodeValue((short)levels[0]);
            float b = this.getHexDecodeValue((short)levels[1]);
            float c = this.getHexDecodeValue((short)levels[3]);
            float d = this.getHexDecodeValue((short)levels[4]);
            for (int i5 = 0; i5 < npixel; ++i5) {
                short ival = DataType.unsignedByteToShort(pdata[i5]);
                if (ival == 0 || ival == 1) {
                    fdata[i5] = Float.NaN;
                    continue;
                }
                if (ival < 20) {
                    fdata[i5] = ((float)ival - b) / a;
                    continue;
                }
                float t = ((float)ival - d) / c;
                fdata[i5] = (float)Math.exp(t);
            }
            return fdata;
        }
        return null;
    }

    public float getHexDecodeValue(short val) {
        int s = val >> 15 & 1;
        int e = val >> 10 & 0x1F;
        int f = val & 0x3FF;
        float deco = e == 0 ? (float)Math.pow(-1.0, s) * 2.0f * (0.0f + (float)f / 1024.0f) : (float)(Math.pow(-1.0, s) * Math.pow(2.0, e - 16) * (double)(1.0f + (float)f / 1024.0f));
        return deco;
    }

    public byte[] readOneBeamData(byte[] ddata, int rLen, int xt, int level) throws IOException, InvalidRangeException {
        int run;
        byte[] bdata = new byte[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen * 2; ++run) {
            int drun = DataType.unsignedByteToShort(ddata[run]) >> 4;
            byte dcode1 = (byte)(DataType.unsignedByteToShort(ddata[run]) & 0xF);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public short[] readOneBeamShortData(byte[] ddata, int rLen, int xt, int level) throws IOException, InvalidRangeException {
        int run;
        short[] sdata = new short[xt];
        int total = 0;
        for (run = 0; run < rLen; ++run) {
            short dcode1;
            sdata[run] = dcode1 = DataType.unsignedByteToShort(ddata[run]);
            ++total;
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                sdata[run] = 0;
            }
        }
        return sdata;
    }

    public Array readNestedWindBarbData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readWindBarbData(name, bos, vinfo, null);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readWindBarbData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo, List sList) throws IOException, InvalidRangeException {
        int recsize;
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        if (size > 1) {
            recsize = pos[1] - pos[0];
            for (int i = 1; i < size; ++i) {
                int r = pos[i] - pos[i - 1];
                if (r == recsize) continue;
                System.out.println(" PROBLEM at " + i + " == " + r);
            }
        } else {
            recsize = 1;
        }
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("value").setDataParam(0);
        members.findMember("x_start").setDataParam(2);
        members.findMember("y_start").setDataParam(4);
        members.findMember("direction").setDataParam(6);
        members.findMember("speed").setDataParam(8);
        members.setStructureSize(recsize);
        ArrayStructureBBpos ay = new ArrayStructureBBpos(members, new int[]{size}, bos, pos);
        return sList != null ? (ArrayStructure)ay.sectionNoReduce(sList) : ay;
    }

    public Array readNestedVectorArrowData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readVectorArrowData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readVectorArrowData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        int recsize = pos[1] - pos[0];
        for (int i = 1; i < size; ++i) {
            int r = pos[i] - pos[i - 1];
            if (r == recsize) continue;
            System.out.println(" PROBLEM at " + i + " == " + r);
        }
        StructureMembers members = pdata.makeStructureMembers();
        members.findMember("x_start").setDataParam(0);
        members.findMember("y_start").setDataParam(2);
        members.findMember("direction").setDataParam(4);
        members.findMember("arrowLength").setDataParam(6);
        members.findMember("arrowHeadLength").setDataParam(8);
        members.setStructureSize(recsize);
        return new ArrayStructureBBpos(members, new int[]{size}, bos, pos);
    }

    public Array readNestedTextStringData(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Array ay;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readTextStringData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        String[] ps = new String[size];
        if (m.getName().equalsIgnoreCase("testString")) {
            for (int i = 0; i < size; ++i) {
                ps[i] = ma.getScalarString(i, m);
            }
            ay = Array.factory(String.class, pdata.getShape(), (Object)ps);
        } else {
            for (int i = 0; i < size; ++i) {
                pa[i] = ma.getScalarShort(i, m);
            }
            ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        }
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readTextStringData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] sizes = vinfo.len;
        int size = pos.length;
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        if (vinfo.code == 8) {
            members.findMember("strValue").setDataParam(0);
            members.findMember("x_start").setDataParam(2);
            members.findMember("y_start").setDataParam(4);
            members.findMember("textString").setDataParam(6);
        } else {
            members.findMember("x_start").setDataParam(0);
            members.findMember("y_start").setDataParam(2);
            members.findMember("textString").setDataParam(4);
        }
        return new MyArrayStructureBBpos(members, new int[]{size}, bos, pos, sizes);
    }

    public Array readNestedDataUnlinkVector(String name, String memberName, ByteBuffer bos, Nidsheader.Vinfo vinfo, List section) throws IOException, InvalidRangeException {
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        ArrayStructure ma = this.readUnlinkedVectorData(name, bos, vinfo);
        int size = (int)pdata.getSize();
        StructureMembers members = ma.getStructureMembers();
        StructureMembers.Member m = members.findMember(memberName);
        short[] pa = new short[size];
        for (int i = 0; i < size; ++i) {
            pa[i] = ma.getScalarShort(i, m);
        }
        Array ay = Array.factory(Short.TYPE, pdata.getShape(), (Object)pa);
        return ay.sectionNoReduce(section);
    }

    public ArrayStructure readUnlinkedVectorData(String name, ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] pos = vinfo.pos;
        int[] dlen = vinfo.len;
        bos.position(0);
        int size = pos.length;
        int vlen = 0;
        for (int i = 0; i < size; ++i) {
            vlen += dlen[i];
        }
        Structure pdata = (Structure)this.ncfile.findVariable(name);
        StructureMembers members = pdata.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(members, new int[]{vlen});
        int ii = 0;
        short[][] sArray = new short[5][vlen];
        for (int i = 0; i < size; ++i) {
            bos.position(pos[i]);
            short vlevel = bos.getShort();
            for (int j = 0; j < dlen[i]; ++j) {
                short istart = bos.getShort();
                short jstart = bos.getShort();
                short iend = bos.getShort();
                short jend = bos.getShort();
                sArray[0][ii] = vlevel;
                sArray[1][ii] = istart;
                sArray[2][ii] = jstart;
                sArray[3][ii] = iend;
                sArray[4][ii] = jend;
                ++ii;
            }
        }
        Array data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[0]);
        StructureMembers.Member m = members.findMember("iValue");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[1]);
        m = members.findMember("x_start");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[2]);
        m = members.findMember("y_start");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[3]);
        m = members.findMember("x_end");
        m.setDataArray(data);
        data = Array.factory(Short.TYPE, new int[]{vlen}, (Object)sArray[4]);
        m = members.findMember("y_end");
        m.setDataArray(data);
        return asma;
    }

    public Object readOneArrayData(ByteBuffer bos, Nidsheader.Vinfo vinfo, String vName) throws IOException, InvalidRangeException {
        int i;
        float[] fdata;
        int iscale;
        int doff = 0;
        boolean offset = false;
        byte[] pdata = new byte[vinfo.yt * vinfo.xt];
        byte[] b2 = new byte[2];
        int npixel = vinfo.yt * vinfo.xt;
        bos.position(0);
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            bos.get(b2);
            int runLen = this.getUInt(b2, 0, 2);
            doff += 2;
            byte[] rdata = new byte[runLen];
            int tmpp = bos.remaining();
            bos.get(rdata, 0, runLen);
            doff += runLen;
            byte[] bdata = this.readOneRowData(rdata, runLen, vinfo.xt);
            System.arraycopy(bdata, 0, pdata, vinfo.xt * radial, vinfo.xt);
        }
        if (vName.endsWith("_RAW")) {
            return pdata;
        }
        if (vName.equals("EchoTop") || vName.equals("VertLiquid") || vName.startsWith("Precip")) {
            int[] levels = vinfo.len;
            iscale = vinfo.code;
            fdata = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[pdata[i]];
                fdata[i] = ival > -9996 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        if (vName.startsWith("BaseReflectivityComp") || vName.startsWith("LayerCompReflect")) {
            int[] levels = vinfo.len;
            iscale = vinfo.code;
            fdata = new float[npixel];
            for (i = 0; i < npixel; ++i) {
                int ival = levels[pdata[i]];
                fdata[i] = ival > -9997 ? (float)ival / (float)iscale + (float)offset : Float.NaN;
            }
            return fdata;
        }
        return null;
    }

    public Object readOneArrayData1(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int doff = 0;
        short[] pdata = new short[vinfo.yt * vinfo.xt];
        bos.position(0);
        for (int row = 0; row < vinfo.yt; ++row) {
            short runLen = bos.getShort();
            doff += 2;
            byte[] rdata = new byte[runLen];
            int tmpp = bos.remaining();
            bos.get(rdata, 0, runLen);
            doff += runLen;
            short[] bdata = vinfo.code == 17 ? this.readOneRowData1(rdata, runLen, vinfo.xt) : this.readOneRowData2(rdata, runLen, vinfo.xt);
            System.arraycopy(bdata, 0, pdata, vinfo.xt * row, vinfo.xt);
        }
        return pdata;
    }

    public short[] readOneRowData1(byte[] ddata, int rLen, int xt) throws IOException, InvalidRangeException {
        int run;
        short[] bdata = new short[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen - 1; ++run) {
            int drun = DataType.unsignedByteToShort(ddata[run]);
            short dcode1 = DataType.unsignedByteToShort(ddata[++run]);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public short[] readOneRowData2(byte[] ddata, int rLen, int xt) throws IOException, InvalidRangeException {
        int run;
        short[] bdata = new short[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen; ++run) {
            int drun = DataType.unsignedByteToShort(ddata[run]) >> 4;
            short dcode1 = (short)(DataType.unsignedByteToShort(ddata[run]) & 0xF);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public byte[] readOneRowData(byte[] ddata, int rLen, int xt) throws IOException, InvalidRangeException {
        int run;
        byte[] bdata = new byte[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen; ++run) {
            int drun = DataType.unsignedByteToShort(ddata[run]) >> 4;
            byte dcode1 = (byte)(DataType.unsignedByteToShort(ddata[run]) & 0xF);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    public Object readRadialDataEle(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        float[] elvdata = new float[vinfo.yt];
        float elvAngle = (float)vinfo.y0 * 0.1f;
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            elvdata[radial] = elvAngle;
        }
        return elvdata;
    }

    public Object readRadialDataLatLonAlt(double t, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        float[] vdata = new float[vinfo.yt];
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            vdata[radial] = (float)t;
        }
        return vdata;
    }

    public Object readRadialDataAzi(ByteBuffer bos, Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int doff = 0;
        float[] azidata = new float[vinfo.yt];
        for (int radial = 0; radial < vinfo.yt; ++radial) {
            short runLen = bos.getShort();
            doff += 2;
            float radialAngle = (float)bos.getShort() / 10.0f;
            doff += 2;
            short radialAngleD = bos.getShort();
            doff += 2;
            doff = vinfo.xt != runLen ? (doff += runLen * 2) : (doff += runLen);
            bos.position(doff);
            Float ra = new Float(radialAngle);
            azidata[radial] = ra.floatValue();
        }
        return azidata;
    }

    public Object readDistance(Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        int[] data = new int[vinfo.yt * vinfo.xt];
        for (int row = 0; row < vinfo.yt; ++row) {
            for (int col = 0; col < vinfo.xt; ++col) {
                int i = row * vinfo.yt + col;
                data[i] = col + vinfo.x0;
            }
        }
        return data;
    }

    public Object readRadialDataGate(Nidsheader.Vinfo vinfo) throws IOException, InvalidRangeException {
        float[] gatedata = new float[vinfo.xt];
        double ddg = Nidsheader.code_reslookup(this.pcode);
        if (this.pcode == 169 || this.pcode == 170 || this.pcode == 171 || this.pcode == 175 || this.pcode == 172 || this.pcode == 173 || this.pcode == 174) {
            ddg = 1.0;
        }
        float sc = (float)vinfo.y0 * 1.0f;
        for (int rad = 0; rad < vinfo.xt; ++rad) {
            gatedata[rad] = (float)vinfo.x0 + (float)rad * sc * (float)ddg;
        }
        return gatedata;
    }

    public byte[] readCompData1(byte[] uncomp, long hoff, long doff) throws IOException {
        int off = 2 * ((uncomp[0] & 0x3F) << 8 | uncomp[1] & 0xFF);
        for (int i = 0; i < 2; ++i) {
            while (off < uncomp.length && uncomp[off] != 10) {
                ++off;
            }
            ++off;
        }
        byte[] data = new byte[(int)((long)(uncomp.length - off) - doff)];
        System.arraycopy(uncomp, off + (int)doff, data, 0, uncomp.length - off - (int)doff);
        return data;
    }

    public byte[] readCompData(long hoff, long doff) throws IOException {
        long pos = 0L;
        long len = this.raf.length();
        this.raf.seek(pos);
        int numin = (int)(len - hoff);
        byte[] b = new byte[(int)len];
        this.raf.readFully(b);
        Inflater inf = new Inflater(false);
        int result = 0;
        int uncompLen = 24500;
        byte[] uncomp = new byte[uncompLen];
        inf.setInput(b, (int)hoff, numin - 4);
        int limit = 20000;
        while (inf.getRemaining() > 0) {
            int resultLength;
            try {
                resultLength = inf.inflate(uncomp, result, 4000);
            }
            catch (DataFormatException ex) {
                System.out.println("ERROR on inflation " + ex.getMessage());
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
            if ((result += resultLength) > limit) {
                byte[] tmp = new byte[result];
                System.arraycopy(uncomp, 0, tmp, 0, result);
                uncomp = new byte[uncompLen += 10000];
                System.arraycopy(tmp, 0, uncomp, 0, result);
            }
            if (resultLength != 0) continue;
            int tt = inf.getRemaining();
            byte[] b2 = new byte[2];
            System.arraycopy(b, (int)hoff + numin - 4 - tt, b2, 0, 2);
            if (this.headerParser.isZlibHed(b2) == 0) {
                System.arraycopy(b, (int)hoff + numin - 4 - tt, uncomp, result, tt);
                result += tt;
                break;
            }
            inf.reset();
            inf.setInput(b, (int)hoff + numin - 4 - tt, tt);
        }
        inf.end();
        int off = 2 * ((uncomp[0] & 0x3F) << 8 | uncomp[1] & 0xFF);
        for (int i = 0; i < 2; ++i) {
            while (off < result && uncomp[off] != 10) {
                ++off;
            }
            ++off;
        }
        byte[] data = new byte[(int)((long)(result - off) - doff)];
        System.arraycopy(uncomp, off + (int)doff, data, 0, result - off - (int)doff);
        return data;
    }

    public byte[] readUCompData(long hoff, long doff) throws IOException {
        long pos = 0L;
        long len = this.raf.length();
        this.raf.seek(pos);
        int numin = (int)(len - hoff);
        byte[] b = new byte[(int)len];
        this.raf.readFully(b);
        byte[] ucomp = new byte[numin - 4];
        System.arraycopy(b, (int)hoff, ucomp, 0, numin - 4);
        byte[] data = new byte[(int)((long)ucomp.length - doff)];
        System.arraycopy(ucomp, (int)doff, data, 0, ucomp.length - (int)doff);
        return data;
    }

    int getUInt(byte[] b, int offset, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = DataType.unsignedByteToShort(b[offset + i]);
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    int getInt(byte[] b, int offset, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = DataType.unsignedByteToShort(b[offset + i]);
        }
        if (bv[0] > 127) {
            bv[0] = bv[0] - 128;
            base = -1;
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/NIDS/N0R_20041102_2111";
        NetcdfFile.registerIOProvider(Nidsiosp.class);
        NetcdfFile ncf = NetcdfFile.open(fileIn);
        Variable v = ncf.findVariable("BaseReflectivity");
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{300, 36};
        v.read(origin, shape);
        ncf.close();
    }

    private static class MyArrayStructureBBpos
    extends ArrayStructureBBpos {
        int[] size;

        MyArrayStructureBBpos(StructureMembers members, int[] shape, ByteBuffer bbuffer, int[] positions, int[] size) {
            super(members, shape, bbuffer, positions);
            this.size = size;
        }

        @Override
        public String getScalarString(int recnum, StructureMembers.Member m) {
            if (m.getDataType() == DataType.CHAR || m.getDataType() == DataType.STRING) {
                int i;
                int offset = this.calcOffsetSetOrder(recnum, m);
                int count = this.size[recnum];
                byte[] pa = new byte[count];
                for (i = 0; i < count; ++i) {
                    pa[i] = this.bbuffer.get(offset + i);
                    if (0 == pa[i]) break;
                }
                return new String(pa, 0, i, CDM.utf8Charset);
            }
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be String or char");
        }
    }
}

