/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.io.File;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import thredds.client.catalog.Catalog;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionAbstract;
import thredds.util.PathAliasReplacement;

public class FeatureCollectionConfigBuilder {
    Formatter errlog;
    public boolean fatalError;
    private static PathAliasReplacement replace;

    public FeatureCollectionConfigBuilder(Formatter errlog) {
        this.errlog = errlog;
    }

    public FeatureCollectionConfig readConfigFromFile(String filename) {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(filename);
        }
        catch (Exception e) {
            System.out.printf("Error parsing featureCollection %s err = %s", filename, e.getMessage());
            return null;
        }
        return this.readConfig(doc.getRootElement());
    }

    public FeatureCollectionConfig readConfigFromCatalog(String catalogAndPath) {
        Document doc;
        String catFilename;
        String fcName = null;
        int pos = catalogAndPath.indexOf("#");
        if (pos > 0) {
            catFilename = catalogAndPath.substring(0, pos);
            fcName = catalogAndPath.substring(pos + 1);
        } else {
            catFilename = catalogAndPath;
        }
        File cat = new File(catFilename);
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(cat);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            ArrayList<Element> fcElems = new ArrayList<Element>();
            this.findFeatureCollection(doc.getRootElement(), fcName, fcElems);
            if (fcElems.size() > 0) {
                return this.readConfig((Element)fcElems.get(0));
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void findFeatureCollection(Element parent, String name, List<Element> fcElems) {
        List elist = parent.getChildren("featureCollection", Catalog.defNS);
        if (name == null) {
            fcElems.addAll(elist);
        } else {
            for (Element elem : elist) {
                if (!name.equals(elem.getAttributeValue("name"))) continue;
                fcElems.add(elem);
            }
        }
        for (Element child : parent.getChildren("dataset", Catalog.defNS)) {
            this.findFeatureCollection(child, name, fcElems);
        }
    }

    public FeatureCollectionConfig readConfig(Element featureCollectionElement) {
        Element gribConfig;
        Element pointElem;
        String datasetTypes;
        Element fmrcElem;
        Element collElem;
        String name = featureCollectionElement.getAttributeValue("name");
        String path = featureCollectionElement.getAttributeValue("path");
        String fcTypeS = featureCollectionElement.getAttributeValue("featureType");
        FeatureCollectionType fcType = FeatureCollectionType.valueOf(fcTypeS);
        if (fcType == null) {
            this.errlog.format("featureCollection %s must have a valid FeatureCollectionType attribute, found '%s'%n", name, fcTypeS);
            this.fatalError = true;
        }
        if ((collElem = featureCollectionElement.getChild("collection", Catalog.defNS)) == null) {
            this.errlog.format("featureCollection %s must have a <collection> element%n", name);
            this.fatalError = true;
            return null;
        }
        String collectionName = collElem.getAttributeValue("name");
        collectionName = CollectionAbstract.cleanName(collectionName != null ? collectionName : name);
        String spec = collElem.getAttributeValue("spec");
        spec = this.expandAliasForCollectionSpec(spec);
        String timePartition = collElem.getAttributeValue("timePartition");
        String dateFormatMark = collElem.getAttributeValue("dateFormatMark");
        String olderThan = collElem.getAttributeValue("olderThan");
        if (spec == null) {
            this.errlog.format("featureCollection %s must have a spec attributet%n", name);
            this.fatalError = true;
            return null;
        }
        Element innerNcml = featureCollectionElement.getChild("netcdf", Catalog.ncmlNS);
        FeatureCollectionConfig config = new FeatureCollectionConfig(name, path, fcType, spec, collectionName, dateFormatMark, olderThan, timePartition, innerNcml);
        Element tdmElem = featureCollectionElement.getChild("tdm", Catalog.defNS);
        config.tdmConfig = this.readUpdateElement(tdmElem);
        Element updateElem = featureCollectionElement.getChild("update", Catalog.defNS);
        config.updateConfig = this.readUpdateElement(updateElem);
        Element protoElem = featureCollectionElement.getChild("protoDataset", Catalog.defNS);
        if (protoElem != null) {
            String choice = protoElem.getAttributeValue("choice");
            String change = protoElem.getAttributeValue("change");
            String param = protoElem.getAttributeValue("param");
            Element ncmlElem = protoElem.getChild("netcdf", Catalog.ncmlNS);
            config.protoConfig = new FeatureCollectionConfig.ProtoConfig(choice, change, param, ncmlElem);
        }
        if ((fmrcElem = featureCollectionElement.getChild("fmrcConfig", Catalog.defNS)) != null) {
            String regularize = fmrcElem.getAttributeValue("regularize");
            config.fmrcConfig = new FeatureCollectionConfig.FmrcConfig(regularize);
            datasetTypes = fmrcElem.getAttributeValue("datasetTypes");
            if (null != datasetTypes) {
                config.fmrcConfig.addDatasetType(datasetTypes);
            }
            List bestElems = fmrcElem.getChildren("dataset", Catalog.defNS);
            for (Element best : bestElems) {
                String bestName = best.getAttributeValue("name");
                String offs = best.getAttributeValue("offsetsGreaterEqual");
                double off = Double.parseDouble(offs);
                config.fmrcConfig.addBestDataset(bestName, off);
            }
        }
        if ((pointElem = featureCollectionElement.getChild("pointConfig", Catalog.defNS)) != null && null != (datasetTypes = pointElem.getAttributeValue("datasetTypes"))) {
            config.pointConfig.addDatasetType(datasetTypes);
        }
        if ((gribConfig = featureCollectionElement.getChild("gribConfig", Catalog.defNS)) != null) {
            config.gribConfig.configFromXml(gribConfig, Catalog.defNS);
        }
        config.finish();
        return config;
    }

    private FeatureCollectionConfig.UpdateConfig readUpdateElement(Element updateElem) {
        if (updateElem == null) {
            return new FeatureCollectionConfig.UpdateConfig();
        }
        String startup = updateElem.getAttributeValue("startup");
        String rewrite = updateElem.getAttributeValue("rewrite");
        String recheckAfter = updateElem.getAttributeValue("recheckAfter");
        String rescan = updateElem.getAttributeValue("rescan");
        String trigger = updateElem.getAttributeValue("trigger");
        String deleteAfter = updateElem.getAttributeValue("deleteAfter");
        return new FeatureCollectionConfig.UpdateConfig(startup, rewrite, recheckAfter, rescan, trigger, deleteAfter);
    }

    private String expandAliasForCollectionSpec(String location) {
        String result;
        if (replace != null && (result = replace.replaceIfMatch(location)) != null) {
            return result;
        }
        return location;
    }

    public static void setPathAliasReplacement(PathAliasReplacement _replace) {
        replace = _replace;
    }
}

