/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Parameter;

public class CFGridWriter2 {
    private static final Logger log = LoggerFactory.getLogger(CFGridWriter2.class);

    public static long makeSizeEstimate(GridDataset gds, List<String> gridList, LatLonRect llbb, ProjectionRect projRect, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon) throws IOException, InvalidRangeException {
        CFGridWriter2 writer2 = new CFGridWriter2();
        return writer2.writeOrTestSize(gds, gridList, llbb, projRect, horizStride, zRange, dateRange, stride_time, addLatLon, true, null);
    }

    public static long writeFile(GridDataset gds, List<String> gridList, LatLonRect llbb, ProjectionRect projRect, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        CFGridWriter2 writer2 = new CFGridWriter2();
        return writer2.writeOrTestSize(gds, gridList, llbb, projRect, horizStride, zRange, dateRange, stride_time, addLatLon, false, writer);
    }

    private long writeOrTestSize(GridDataset gds, List<String> gridList, LatLonRect llbb, ProjectionRect projRect, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon, boolean testSizeOnly, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        NetcdfDataset ncd = (NetcdfDataset)gds.getNetcdfFile();
        LatLonRect resultBB = null;
        ArrayList<Variable> varList = new ArrayList<Variable>();
        ArrayList<String> varNameList = new ArrayList<String>();
        ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
        if (gridList == null) {
            gridList = new ArrayList<String>();
            for (GridDatatype grid : gds.getGrids()) {
                gridList.add(grid.getName());
            }
        }
        long total_size = 0L;
        for (String gridName : gridList) {
            ProjectionImpl proj;
            if (varNameList.contains(gridName)) continue;
            GridDatatype grid = gds.findGridDatatype(gridName);
            if (grid == null) {
                System.out.printf("cant find %s%n", gridName);
                continue;
            }
            GridCoordSystem gcsOrg = grid.getCoordinateSystem();
            boolean isGlobal = gcsOrg.isGlobalLon();
            varNameList.add(gridName);
            Range timeRange = this.makeTimeRange(dateRange, gcsOrg.getTimeAxis1D(), stride_time);
            Range zRangeUse = this.makeVerticalRange(zRange, gcsOrg.getVerticalAxis());
            List<Range> yxRanges = new ArrayList<Range>(2);
            if (projRect != null) {
                this.makeHorizRange(gcsOrg, projRect, horizStride, yxRanges);
                grid = grid.makeSubset(null, null, timeRange, zRangeUse, yxRanges.get(0), yxRanges.get(1));
            } else {
                if (llbb == null) {
                    yxRanges.add(null);
                    yxRanges.add(null);
                } else {
                    yxRanges = grid.getCoordinateSystem().getRangesFromLatLonRect(llbb);
                }
                if (null != timeRange || zRangeUse != null || llbb != null || horizStride > 1) {
                    grid = grid.makeSubset(timeRange, zRangeUse, llbb, 1, horizStride, horizStride);
                }
            }
            LatLonRect gridBB = grid.getCoordinateSystem().getLatLonBoundingBox();
            if (resultBB == null) {
                resultBB = gridBB;
            } else {
                resultBB.extend(gridBB);
            }
            VariableDS gridV = grid.getVariable();
            varList.add(gridV);
            total_size += gridV.getSize() * (long)gridV.getElementSize();
            GridCoordSystem gcs = grid.getCoordinateSystem();
            this.addCoordinateAxis(gcs, varNameList, varList, axisList);
            this.addCoordinateTransform(gcs, ncd, varNameList, varList);
            total_size += this.processTransformationVars(varList, varNameList, ncd, gds, grid, timeRange, zRangeUse, yxRanges.get(0), yxRanges.get(1), horizStride, horizStride);
            if (!addLatLon || null == (proj = gcs.getProjection()) || proj instanceof LatLonProjection) continue;
            total_size += this.addLatLon2D(ncd, varList, proj, gcs.getXHorizAxis(), gcs.getYHorizAxis());
            addLatLon = false;
        }
        if (testSizeOnly) {
            return total_size;
        }
        boolean isLargeFile = this.isLargeFile(total_size);
        writer.setLargeFile(isLargeFile);
        this.addGlobalAttributes(writer, gds, resultBB);
        FileWriter2 fileWriter = new FileWriter2(writer);
        for (Variable v : varList) {
            fileWriter.addVariable(v);
        }
        this.addCFAnnotations(writer, gds, gridList, ncd, axisList, addLatLon);
        writer.create();
        fileWriter.copyVarData(varList, null, null);
        writer.close();
        return total_size;
    }

    private boolean isLargeFile(long total_size) {
        boolean isLargeFile = false;
        long maxSize = 2000000000L;
        if (total_size > maxSize) {
            log.debug("Request size = {} Mbytes", (Object)(total_size / 1000L / 1000L));
            isLargeFile = true;
        }
        return isLargeFile;
    }

    private void makeHorizRange(GridCoordSystem gcsOrg, ProjectionRect projRect, int horizStride, List<Range> yxRanges) throws InvalidRangeException {
        CoordinateAxis1D yAxis;
        double[] yCoords;
        if (gcsOrg.getXHorizAxis().getRank() > 1 || gcsOrg.getYHorizAxis().getRank() > 1) {
            throw new IllegalArgumentException("Coordinate systems with 2D horizontal axis are not supported");
        }
        CoordinateAxis1D xAxis = (CoordinateAxis1D)gcsOrg.getXHorizAxis();
        double[] xCoords = xAxis.getCoordValues();
        ProjectionRect fullBB = new ProjectionRect(xCoords[0], (yCoords = (yAxis = (CoordinateAxis1D)gcsOrg.getYHorizAxis()).getCoordValues())[0], xCoords[xCoords.length - 1], yCoords[yCoords.length - 1]);
        if (!projRect.intersects(fullBB)) {
            throw new InvalidRangeException("BBOX must intersect grid BBOX, minx=" + xCoords[0] + ", miny=" + yCoords[0] + ", maxx=" + xCoords[xCoords.length - 1] + ", maxy=" + yCoords[yCoords.length - 1]);
        }
        ProjectionRect.intersect(fullBB, projRect, projRect);
        ProjectionPoint lowerLeft = projRect.getLowerLeftPoint();
        ProjectionPoint upperRigth = projRect.getUpperRightPoint();
        double minx = lowerLeft.getX();
        double miny = lowerLeft.getY();
        double maxx = upperRigth.getX();
        double maxy = upperRigth.getY();
        int minyCoord = yAxis.findCoordElement(miny);
        int maxyCoord = yAxis.findCoordElement(maxy);
        int minxCoord = xAxis.findCoordElement(minx);
        int maxxCoord = xAxis.findCoordElement(maxx);
        yxRanges.add(0, new Range(minyCoord, maxyCoord, horizStride));
        yxRanges.add(1, new Range(minxCoord, maxxCoord, horizStride));
    }

    private void addGlobalAttributes(NetcdfFileWriter writer, GridDataset gds, LatLonRect llbb) {
        for (Attribute att : gds.getGlobalAttributes()) {
            if (att.getShortName().equals("file_format") || att.getShortName().equals("_CoordSysBuilder")) continue;
            writer.addGroupAttribute(null, att);
        }
        Attribute att = gds.findGlobalAttributeIgnoreCase("Conventions");
        if (att == null || !att.getStringValue().startsWith("CF-")) {
            writer.addGroupAttribute(null, new Attribute("Conventions", "CF-1.0"));
        }
        writer.addGroupAttribute(null, new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (CFGridWriter2)\nOriginal Dataset = " + gds.getLocationURI() + "; Translation Date = " + CalendarDate.present()));
        writer.addGroupAttribute(null, new Attribute("geospatial_lat_min", llbb.getLatMin()));
        writer.addGroupAttribute(null, new Attribute("geospatial_lat_max", llbb.getLatMax()));
        writer.addGroupAttribute(null, new Attribute("geospatial_lon_min", llbb.getLonMin()));
        writer.addGroupAttribute(null, new Attribute("geospatial_lon_max", llbb.getLonMax()));
    }

    private void addCFAnnotations(NetcdfFileWriter writer, GridDataset gds, List<String> gridList, NetcdfDataset ncd, List<CoordinateAxis> axisList, boolean addLatLon) {
        for (String gridName : gridList) {
            GridDatatype grid = gds.findGridDatatype(gridName);
            Variable newV = writer.findVariable(gridName);
            if (newV == null) {
                log.warn("NetcdfCFWriter cant find " + gridName + " in gds " + gds.getLocationURI());
                continue;
            }
            StringBuilder sbuff = new StringBuilder();
            GridCoordSystem gcs = grid.getCoordinateSystem();
            for (Variable variable : gcs.getCoordinateAxes()) {
                sbuff.append(variable.getFullName()).append(" ");
            }
            if (addLatLon) {
                sbuff.append("lat lon");
            }
            newV.addAttribute(new Attribute("coordinates", sbuff.toString()));
            for (CoordinateTransform coordinateTransform : gcs.getCoordinateTransforms()) {
                Variable v = ncd.findVariable(coordinateTransform.getName());
                if (coordinateTransform.getTransformType() != TransformType.Projection) continue;
                newV.addAttribute(new Attribute("grid_mapping", v.getFullName()));
            }
        }
        for (CoordinateAxis axis : axisList) {
            Variable newV = writer.findVariable(axis.getFullNameEscaped());
            if ((axis.getAxisType() == AxisType.Height || axis.getAxisType() == AxisType.Pressure || axis.getAxisType() == AxisType.GeoZ) && null != axis.getPositive()) {
                newV.addAttribute(new Attribute("positive", axis.getPositive()));
            }
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() == AxisType.Lon) {
                newV.addAttribute(new Attribute("units", "degrees_east"));
                newV.addAttribute(new Attribute("standard_name", "longitude"));
            }
            if (axis.getAxisType() == AxisType.GeoX) {
                newV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            }
            if (axis.getAxisType() != AxisType.GeoY) continue;
            newV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
        }
        ArrayList<Variable> ctvList = new ArrayList<Variable>();
        for (GridDataset.Gridset gridSet : gds.getGridsets()) {
            Variable v;
            GridCoordSystem gcs = gridSet.getGeoCoordSystem();
            ProjectionCT pct = gcs.getProjectionCT();
            if (pct == null || (v = writer.findVariable(pct.getName())) == null || ctvList.contains(v)) continue;
            this.convertProjectionCTV((NetcdfDataset)gds.getNetcdfFile(), v);
            ctvList.add(v);
        }
    }

    private void convertProjectionCTV(NetcdfDataset ds, Variable ctv) {
        Attribute att = ctv.findAttribute("_CoordinateTransformType");
        if (null != att && att.getStringValue().equals("Projection")) {
            double scalef;
            Attribute east = ctv.findAttribute("false_easting");
            Attribute north = ctv.findAttribute("false_northing");
            if ((null != east || null != north) && (scalef = AbstractCoordTransBuilder.getFalseEastingScaleFactor(ds, ctv)) != 1.0) {
                this.convertAttribute(ctv, east, scalef);
                this.convertAttribute(ctv, north, scalef);
            }
        }
    }

    private void convertAttribute(Variable ctv, Attribute att, double scalef) {
        if (att == null) {
            return;
        }
        double val = scalef * att.getNumericValue().doubleValue();
        ctv.addAttribute(new Attribute(att.getShortName(), val));
    }

    private long addLatLon2D(NetcdfFile ncfile, List<Variable> varList, Projection proj, CoordinateAxis xaxis, CoordinateAxis yaxis) throws IOException {
        double[] xData = (double[])xaxis.read().get1DJavaArray(Double.TYPE);
        double[] yData = (double[])yaxis.read().get1DJavaArray(Double.TYPE);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(yaxis.getDimension(0));
        dims.add(xaxis.getDimension(0));
        Variable latVar = new Variable(ncfile, null, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions(dims);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, null, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions(dims);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                proj.projToLatLon(projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        varList.add(latVar);
        varList.add(lonVar);
        long size = 0L;
        size += latVar.getSize() * (long)latVar.getElementSize();
        return size += lonVar.getSize() * (long)lonVar.getElementSize();
    }

    private Range makeVerticalRange(Range zRange, CoordinateAxis1D vertAxis) throws InvalidRangeException {
        return zRange != null && vertAxis != null && vertAxis.getSize() > 1L ? zRange : null;
    }

    private Range makeTimeRange(CalendarDateRange dateRange, CoordinateAxis1DTime timeAxis, int stride_time) throws InvalidRangeException {
        Range timeRange = null;
        if (dateRange != null && timeAxis != null) {
            int startIndex = timeAxis.findTimeIndexFromCalendarDate(dateRange.getStart());
            int endIndex = timeAxis.findTimeIndexFromCalendarDate(dateRange.getEnd());
            if (startIndex < 0) {
                throw new InvalidRangeException("start time=" + dateRange.getStart() + " must be >= " + timeAxis.getCalendarDate(0));
            }
            if (endIndex < 0) {
                throw new InvalidRangeException("end time=" + dateRange.getEnd() + " must be >= " + timeAxis.getCalendarDate(0));
            }
            if (stride_time <= 1) {
                stride_time = 1;
            }
            timeRange = new Range(startIndex, endIndex, stride_time);
        }
        return timeRange;
    }

    private void addCoordinateAxis(GridCoordSystem gcs, List<String> varNameList, List<Variable> varList, List<CoordinateAxis> axisList) {
        for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
            if (varNameList.contains(axis.getFullName())) continue;
            varNameList.add(axis.getFullName());
            varList.add(axis);
            axisList.add(axis);
        }
    }

    private void addCoordinateTransform(GridCoordSystem gcs, NetcdfFile ncd, List<String> varNameList, List<Variable> varList) {
        for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
            Variable v = ncd.findVariable(ct.getName());
            if (varNameList.contains(ct.getName()) || null == v) continue;
            varNameList.add(ct.getName());
            varList.add(v);
        }
    }

    private long processTransformationVars(List<Variable> varList, List<String> varNameList, NetcdfDataset ncd, GridDataset gds, GridDatatype grid, Range timeRange, Range zRangeUse, Range yRange, Range xRange, int y_stride, int x_stride) throws InvalidRangeException {
        long varsSize = 0L;
        List<CoordinateTransform> cctt = grid.getCoordinateSystem().getCoordinateTransforms();
        for (CoordinateTransform ct : cctt) {
            Parameter param = ct.findParameterIgnoreCase("formula_terms");
            if (param == null) continue;
            String[] varStrings = param.getStringValue().split(" ");
            for (int i = 1; i < varStrings.length; i += 2) {
                Variable paramVar = ncd.findVariable(varStrings[i].trim());
                if (varNameList.contains(varStrings[i]) || null == paramVar) continue;
                if (gds.findGridDatatype(paramVar.getFullName()) != null) {
                    if (null != timeRange || zRangeUse != null || x_stride > 1 && y_stride > 1 || yRange != null || xRange != null) {
                        GridDatatype complementaryGrid = gds.findGridDatatype(paramVar.getFullName());
                        complementaryGrid = complementaryGrid.makeSubset(null, null, timeRange, zRangeUse, yRange, xRange);
                        paramVar = complementaryGrid.getVariable();
                    }
                } else if (zRangeUse != null && paramVar.getRank() == 1) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    ranges.add(zRangeUse);
                    paramVar = paramVar.section(ranges);
                }
                varNameList.add(paramVar.getFullName());
                varsSize += paramVar.getSize() * (long)paramVar.getElementSize();
                varList.add(paramVar);
            }
        }
        return varsSize;
    }
}

