/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.UnsynchronizedBufferedWriter;
import ucar.unidata.io.RandomAccessFile;

public class IO {
    public static int default_file_buffersize = 9200;
    public static int default_socket_buffersize = 64000;
    private static boolean showStackTrace = false;
    private static boolean debug = false;
    private static boolean showResponse = false;
    private static boolean showHeaders = false;
    private static Class cl;

    public static InputStream getFileResource(String resourcePath) {
        InputStream is;
        block9: {
            if (cl == null) {
                cl = IO.class;
            }
            if ((is = cl.getResourceAsStream(resourcePath)) != null) {
                if (debug) {
                    System.out.println("Resource.getResourceAsStream ok on " + resourcePath);
                }
                return is;
            }
            if (debug) {
                System.out.println("Resource.getResourceAsStream failed on (" + resourcePath + ")");
            }
            try {
                is = new FileInputStream(resourcePath);
                if (debug) {
                    System.out.println("Resource.FileInputStream ok on " + resourcePath);
                }
            }
            catch (FileNotFoundException e) {
                if (debug) {
                    System.out.println("  FileNotFoundException: Resource.getFile failed on " + resourcePath);
                }
            }
            catch (AccessControlException e) {
                if (!debug) break block9;
                System.out.println("  AccessControlException: Resource.getFile failed on " + resourcePath);
            }
        }
        return is;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        long totalBytesRead = 0L;
        byte[] buffer = new byte[default_file_buffersize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
        }
        return totalBytesRead;
    }

    public static long copy2null(InputStream in, int buffersize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        if (buffersize <= 0) {
            buffersize = default_file_buffersize;
        }
        byte[] buffer = new byte[buffersize];
        while ((n = in.read(buffer)) != -1) {
            totalBytesRead += (long)n;
        }
        return totalBytesRead;
    }

    public static long touch(InputStream in, int buffersize) throws IOException {
        int n;
        long touch = 0L;
        if (buffersize <= 0) {
            buffersize = default_file_buffersize;
        }
        byte[] buffer = new byte[buffersize];
        while ((n = in.read(buffer)) != -1) {
            for (int i = 0; i < buffersize; ++i) {
                touch += (long)buffer[i];
            }
        }
        return touch;
    }

    public static long copy2null(FileChannel in, int buffersize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        if (buffersize <= 0) {
            buffersize = default_file_buffersize;
        }
        ByteBuffer buffer = ByteBuffer.allocate(buffersize);
        while ((n = in.read(buffer)) != -1) {
            totalBytesRead += (long)n;
            buffer.flip();
        }
        return totalBytesRead;
    }

    public static long touch(FileChannel in, int buffersize) throws IOException {
        int n;
        long touch = 0L;
        if (buffersize <= 0) {
            buffersize = default_file_buffersize;
        }
        ByteBuffer buffer = ByteBuffer.allocate(buffersize);
        while ((n = in.read(buffer)) != -1) {
            byte[] result = buffer.array();
            for (int i = 0; i < buffersize; ++i) {
                touch += (long)result[i];
            }
            buffer.flip();
        }
        return touch;
    }

    public static long copyB(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int n;
        long totalBytesRead = 0L;
        int done = 0;
        int next = 1;
        boolean show = false;
        byte[] buffer = new byte[bufferSize];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
            totalBytesRead += (long)n;
            if (!show || (done += n) <= 1000000 * next) continue;
            System.out.println(next + " Mb");
            ++next;
        }
        return totalBytesRead;
    }

    public static void copy(InputStream in, OutputStream out, int n) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[default_file_buffersize];
        int count = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            if ((count += bytesRead) <= n) continue;
            return;
        }
    }

    public static String readContents(InputStream is) throws IOException {
        return IO.readContents(is, "UTF-8");
    }

    public static String readContents(InputStream is, String charset) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10 * default_file_buffersize);
        IO.copy(is, bout);
        return bout.toString(charset);
    }

    public static byte[] readContentsToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10 * default_file_buffersize);
        IO.copy(is, bout);
        return bout.toByteArray();
    }

    public static void writeContents(String contents, OutputStream os) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(contents.getBytes(CDM.utf8Charset));
        IO.copy(bin, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fileInName, String fileOutName) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileInName));
            out = new BufferedOutputStream(new FileOutputStream(fileOutName));
            IO.copy(in, out);
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File fileIn, File fileOut) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileIn));
            out = new BufferedOutputStream(new FileOutputStream(fileOut));
            IO.copy(in, out);
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }

    public static void copyFile(String fileInName, OutputStream out) throws IOException {
        IO.copyFileB(new File(fileInName), out, default_file_buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileB(File fileIn, OutputStream out, int bufferSize) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileIn));
            IO.copyB(in, out, bufferSize);
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    public static long copyRafB(RandomAccessFile raf, long offset, long length, OutputStream out, byte[] buffer) throws IOException {
        int len;
        long want;
        int bytesRead;
        int bufferSize = buffer.length;
        raf.seek(offset);
        for (want = length; want > 0L && (bytesRead = raf.read(buffer, 0, len = (int)Math.min(want, (long)bufferSize))) > 0; want -= (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        return length - want;
    }

    public static void copyDirTree(String fromDirName, String toDirName) throws IOException {
        File fromDir = new File(fromDirName);
        File toDir = new File(toDirName);
        if (!fromDir.exists()) {
            return;
        }
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        for (File f : fromDir.listFiles()) {
            if (f.isDirectory()) {
                IO.copyDirTree(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
                continue;
            }
            IO.copyFile(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(String filename) throws IOException {
        try (InputStream in = null;){
            in = new BufferedInputStream(new FileInputStream(filename));
            byte[] byArray = IO.readContentsToByteArray(in);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filename) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filename), CDM.utf8Charset);){
            StringWriter swriter = new StringWriter(50000);
            UnsynchronizedBufferedWriter writer = new UnsynchronizedBufferedWriter(swriter);
            writer.write(reader);
            String string = swriter.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String contents, File file) throws IOException {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), CDM.utf8Charset);
        UnsynchronizedBufferedWriter writer = new UnsynchronizedBufferedWriter(fw);
        try {
            writer.write(contents);
            writer.flush();
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(byte[] contents, File file) throws IOException {
        FileOutputStream fw = new FileOutputStream(file);
        try {
            fw.write(contents);
            fw.flush();
        }
        finally {
            if (null != fw) {
                fw.close();
            }
        }
    }

    public static void writeToFile(String contents, String fileOutName) throws IOException {
        IO.writeToFile(contents, new File(fileOutName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeToFile(InputStream in, String fileOutName) throws IOException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileOutName));
            long l = IO.copy(in, out);
            return l;
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long appendToFile(InputStream in, String fileOutName) throws IOException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileOutName, true));
            long l = IO.copy(in, out);
            return l;
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                ((OutputStream)out).close();
            }
        }
    }

    public static long copyUrlB(String urlString, OutputStream out, int bufferSize) throws IOException {
        long count;
        URL url;
        InputStream is = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            int responseCode;
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConnection = null;
            if (connection instanceof HttpURLConnection) {
                httpConnection = (HttpURLConnection)connection;
                httpConnection.addRequestProperty("Accept-Encoding", "gzip");
            }
            if (showHeaders) {
                IO.showRequestHeaders(urlString, connection);
            }
            if (httpConnection != null && (responseCode = httpConnection.getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            if (showHeaders && httpConnection != null) {
                int code = httpConnection.getResponseCode();
                String response = httpConnection.getResponseMessage();
                System.out.println("\nRESPONSE for " + urlString + ": ");
                System.out.println(" HTTP/1.x " + code + " " + response);
                System.out.println("Headers: ");
                int j = 1;
                while (true) {
                    String header = connection.getHeaderField(j);
                    String key = connection.getHeaderFieldKey(j);
                    if (header == null || key == null) break;
                    System.out.println(" " + key + ": " + header);
                    ++j;
                }
            }
            is = connection.getInputStream();
            if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                is = new BufferedInputStream(new GZIPInputStream(is), 1000);
            }
            count = out == null ? IO.copy2null(is, bufferSize) : IO.copyB(is, out, bufferSize);
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (UnknownHostException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** UnknownHostException on URL: <" + urlString + ">\n");
        }
        catch (Exception e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** Exception on URL: <" + urlString + ">\n" + e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return count;
    }

    private static void showRequestHeaders(String urlString, URLConnection connection) {
        System.out.println("\nREQUEST Properties for " + urlString + ": ");
        Map<String, List<String>> reqs = connection.getRequestProperties();
        for (Map.Entry<String, List<String>> entry : reqs.entrySet()) {
            System.out.printf(" %s:", entry.getKey());
            for (String v : entry.getValue()) {
                System.out.printf("%s,", v);
            }
            System.out.printf("%n", new Object[0]);
        }
    }

    public static InputStream getInputStreamFromUrl(String urlString) throws IOException {
        URL url;
        InputStream is = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            int responseCode;
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConnection = null;
            if (connection instanceof HttpURLConnection) {
                httpConnection = (HttpURLConnection)connection;
                httpConnection.addRequestProperty("Accept-Encoding", "gzip");
            }
            if (showHeaders) {
                IO.showRequestHeaders(urlString, connection);
            }
            if (httpConnection != null && (responseCode = httpConnection.getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            if (showHeaders && httpConnection != null) {
                int code = httpConnection.getResponseCode();
                String response = httpConnection.getResponseMessage();
                System.out.println("\nRESPONSE for " + urlString + ": ");
                System.out.println(" HTTP/1.x " + code + " " + response);
                System.out.println("Headers: ");
                int j = 1;
                while (true) {
                    String header = connection.getHeaderField(j);
                    String key = connection.getHeaderFieldKey(j);
                    if (header == null || key == null) break;
                    System.out.println(" " + key + ": " + header);
                    ++j;
                }
            }
            is = connection.getInputStream();
            if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                is = new BufferedInputStream(new GZIPInputStream(is), 1000);
            }
            return is;
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (UnknownHostException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** UnknownHostException on URL: <" + urlString + ">\n");
        }
        catch (Exception e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** Exception on URL: <" + urlString + ">\n" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURLtoFile(String urlString, File file) {
        BufferedOutputStream out;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return "** IOException opening file: <" + file + ">\n" + e.getMessage() + "\n";
        }
        try {
            IO.copyUrlB(urlString, out, 20000);
            String e = "ok";
            return e;
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            String string = "** IOException reading URL: <" + urlString + ">\n" + e.getMessage() + "\n";
            return string;
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                return "** IOException closing file : <" + file + ">\n" + e.getMessage() + "\n";
            }
        }
    }

    public static byte[] readURLContentsToByteArray(String urlString) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
        IO.copyUrlB(urlString, bout, 200000);
        return bout.toByteArray();
    }

    public static String readURLtoFileWithExceptions(String urlString, File file) throws IOException {
        return IO.readURLtoFileWithExceptions(urlString, file, default_socket_buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURLtoFileWithExceptions(String urlString, File file, int buffer_size) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            IO.copyUrlB(urlString, out, buffer_size);
            String string = "ok";
            return string;
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                return "** IOException closing file : <" + file + ">\n" + e.getMessage() + "\n";
            }
        }
    }

    public static String readURLcontentsWithException(String urlString) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(20000);
        IO.copyUrlB(urlString, bout, 20000);
        return bout.toString("UTF-8");
    }

    public static String readURLcontents(String urlString) {
        try {
            return IO.readURLcontentsWithException(urlString);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static HttpResult putToURL(String urlString, String contents) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return new HttpResult(-1, "** MalformedURLException on URL (" + urlString + ")\n" + e.getMessage());
        }
        try {
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setRequestMethod("PUT");
            BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());
            IO.copy(new ByteArrayInputStream(contents.getBytes(CDM.utf8Charset)), out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            int code = c.getResponseCode();
            String mess = c.getResponseMessage();
            return new HttpResult(code, mess);
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return new HttpResult(-2, "** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return new HttpResult(-3, "** IOException on URL: (" + urlString + ")\n" + e.getMessage());
        }
    }

    public static class HttpResult {
        public int statusCode;
        public String message;

        HttpResult(int code, String message) {
            this.statusCode = code;
            this.message = message;
        }
    }
}

