/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.Station;

public class StandardStationCollectionImpl
extends StationTimeSeriesCollectionImpl {
    private NestedTable ft;

    StandardStationCollectionImpl(NestedTable ft, DateUnit timeUnit, String altUnits) throws IOException {
        super(ft.getName(), timeUnit, altUnits);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    public StationTimeSeriesFeature makeStation(StructureData stationData, int recnum) {
        StationFeature s = this.ft.makeStation(stationData);
        if (s == null) {
            return null;
        }
        return new StandardStationFeatureImpl(s, this.timeUnit, stationData, recnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StationHelper initStationHelper() {
        try {
            this.stationHelper = new StationHelper();
            StructureDataIterator siter = this.ft.getStationDataIterator(-1);
            try {
                while (siter.hasNext()) {
                    StructureData stationData = siter.next();
                    StationTimeSeriesFeature s = this.makeStation(stationData, siter.getCurrentRecno());
                    if (s == null) continue;
                    this.stationHelper.addStation(s);
                }
            }
            finally {
                siter.finish();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return this.stationHelper;
    }

    private class StandardStationFeatureImpl
    extends StationTimeSeriesFeatureImpl {
        int recnum;
        StructureData stationData;

        StandardStationFeatureImpl(Station s, DateUnit dateUnit, StructureData stationData, int recnum) {
            super(s, dateUnit, StandardStationCollectionImpl.this.getAltUnits(), -1);
            this.recnum = recnum;
            this.stationData = stationData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursor = new Cursor(StandardStationCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[1] = this.recnum;
            cursor.tableData[1] = this.stationData;
            cursor.currentIndex = 1;
            StandardStationCollectionImpl.this.ft.addParentJoin(cursor);
            StructureDataIterator obsIter = StandardStationCollectionImpl.this.ft.getLeafFeatureDataIterator(cursor, bufferSize);
            StandardPointFeatureIterator iter = new StandardPointFeatureIterator(StandardStationCollectionImpl.this.ft, this.timeUnit, obsIter, cursor);
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public StructureData getFeatureData() {
            return this.stationData;
        }
    }
}

