/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Date;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class StandardProfileCollectionImpl
extends OneNestedPointCollectionImpl
implements ProfileFeatureCollection {
    private NestedTable ft;
    private ProfileIterator localIterator = null;

    protected StandardProfileCollectionImpl(String name, DateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.PROFILE);
    }

    StandardProfileCollectionImpl(NestedTable ft, DateUnit timeUnit, String altUnits) {
        super(ft.getName(), timeUnit, altUnits, FeatureType.PROFILE);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new ProfileIterator(this.ft.getRootFeatureDataIterator(bufferSize));
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public ProfileFeature next() throws IOException {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = (ProfileIterator)this.getPointFeatureCollectionIterator(-1);
    }

    @Override
    public ProfileFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return new StandardProfileCollectionSubset(this, boundingBox);
    }

    private class StandardProfileCollectionSubset
    extends StandardProfileCollectionImpl {
        StandardProfileCollectionImpl from;
        LatLonRect boundingBox;

        StandardProfileCollectionSubset(StandardProfileCollectionImpl from, LatLonRect boundingBox) {
            super(from.getName() + "-subset", from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.boundingBox = boundingBox;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements PointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            @Override
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StandardProfileCollectionSubset.this.boundingBox.contains(profileFeature.getLatLon());
            }
        }
    }

    private class StandardProfileFeature
    extends ProfileFeatureImpl {
        Cursor cursor;
        StructureData profileData;

        StandardProfileFeature(Cursor cursor, double time, StructureData profileData) {
            super(StandardProfileCollectionImpl.this.ft.getFeatureName(cursor), StandardProfileCollectionImpl.this.getTimeUnit(), StandardProfileCollectionImpl.this.getAltUnits(), StandardProfileCollectionImpl.this.ft.getLatitude(cursor), StandardProfileCollectionImpl.this.ft.getLongitude(cursor), time, -1);
            this.cursor = cursor;
            this.profileData = profileData;
            if (this.name.equalsIgnoreCase("unknown")) {
                this.name = this.timeUnit.makeStandardDateString(time);
            }
            if (Double.isNaN(time)) {
                try {
                    PointFeatureIterator iter = this.getPointFeatureIterator(-1);
                    if (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        this.time = pf.getObservationTime();
                        if (this.name == null) {
                            this.name = this.timeUnit.makeStandardDateString(this.time);
                        }
                    } else if (this.name == null) {
                        this.name = "empty";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public StructureData getFeatureData() {
            return this.profileData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardProfileCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter, bufferSize);
            StandardProfileFeatureIterator iter = new StandardProfileFeatureIterator(StandardProfileCollectionImpl.this.ft, this.timeUnit, siter, cursorIter);
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public Date getTime() {
            return this.timeUnit.makeDate(this.time);
        }

        class StandardProfileFeatureIterator
        extends StandardPointFeatureIterator {
            StandardProfileFeatureIterator(NestedTable ft, DateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) throws IOException {
                super(ft, timeUnit, structIter, cursor);
            }

            @Override
            protected boolean isMissing() throws IOException {
                if (super.isMissing()) {
                    return true;
                }
                return this.ft.isAltMissing(this.cursor);
            }
        }
    }

    private class ProfileIterator
    implements PointFeatureCollectionIterator {
        StructureDataIterator structIter;
        StructureData nextProfileData;

        ProfileIterator(StructureDataIterator structIter) throws IOException {
            this.structIter = structIter;
        }

        @Override
        public boolean hasNext() throws IOException {
            do {
                if (!this.structIter.hasNext()) {
                    return false;
                }
                this.nextProfileData = this.structIter.next();
            } while (StandardProfileCollectionImpl.this.ft.isFeatureMissing(this.nextProfileData));
            return true;
        }

        @Override
        public ProfileFeature next() throws IOException {
            Cursor cursor = new Cursor(StandardProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.tableData[1] = this.nextProfileData;
            cursor.recnum[1] = this.structIter.getCurrentRecno();
            cursor.currentIndex = 1;
            StandardProfileCollectionImpl.this.ft.addParentJoin(cursor);
            return new StandardProfileFeature(cursor, StandardProfileCollectionImpl.this.ft.getObsTime(cursor), this.nextProfileData);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public void finish() {
            this.structIter.finish();
        }
    }
}

