/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ucar.ma2.StructureData;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorEmpty;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.remote.QueryMaker;
import ucar.nc2.ft.point.remote.RemotePointCollection;
import ucar.nc2.ft.point.remote.RemotePointFeatureIterator;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public class RemoteStationCollection
extends StationTimeSeriesCollectionImpl {
    private String uri;
    protected LatLonRect boundingBoxSubset;
    protected CalendarDateRange dateRangeSubset;
    private boolean restrictedList = false;

    public RemoteStationCollection(String uri, DateUnit timeUnit, String altUnits) {
        super(uri, timeUnit, altUnits);
        this.uri = uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected StationHelper initStationHelper() {
        this.stationHelper = new StationHelper();
        try (InputStream in = CdmRemote.sendQuery(this.uri, "req=stations");){
            PointStream.MessageType mtype = PointStream.readMagic(in);
            if (mtype != PointStream.MessageType.StationList) {
                throw new RuntimeException("Station Request: bad response");
            }
            int len = NcStream.readVInt(in);
            byte[] b = new byte[len];
            NcStream.readFully(in, b);
            PointStreamProto.StationList stationsp = PointStreamProto.StationList.parseFrom(b);
            for (PointStreamProto.Station sp : stationsp.getStationsList()) {
                StationImpl s = new StationImpl(sp.getId(), sp.getDesc(), sp.getWmoId(), sp.getLat(), sp.getLon(), sp.getAlt());
                this.stationHelper.addStation(new RemoteStationFeatureImpl(null, null));
            }
            StationHelper stationHelper = this.stationHelper;
            return stationHelper;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected RemoteStationCollection(String uri, DateUnit timeUnit, String altUnits, StationHelper sh) {
        super(uri, timeUnit, altUnits);
        this.uri = uri;
        this.stationHelper = sh;
        this.restrictedList = sh != null;
    }

    @Override
    public Station getStation(PointFeature feature) throws IOException {
        StationPointFeature stationFeature = (StationPointFeature)feature;
        return stationFeature.getStation();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        List<StationFeature> subset = this.stationHelper.getStationFeatures(stations);
        return new RemoteStationCollectionSubset(this, null, null, null);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        if (boundingBox == null) {
            return this;
        }
        return new RemoteStationCollectionSubset(this, null, boundingBox, null);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        QueryByStationList queryMaker = this.restrictedList ? new QueryByStationList() : null;
        RemotePointCollection pfc = new RemotePointCollection(this.uri, this.getTimeUnit(), this.getAltUnits(), queryMaker);
        return pfc.subset(boundingBox, dateRange);
    }

    private class RemoteStationFeatureImpl
    extends StationTimeSeriesFeatureImpl {
        StationTimeSeriesFeature stnFeature;
        RemotePointFeatureIterator riter;

        RemoteStationFeatureImpl(StationTimeSeriesFeature s, CalendarDateRange dateRange) {
            super(s, RemoteStationCollection.this.getTimeUnit(), RemoteStationCollection.this.getAltUnits(), -1);
            this.stnFeature = s;
            this.dateRange = dateRange;
        }

        @Override
        public StationTimeSeriesFeature subset(CalendarDateRange dateRange) throws IOException {
            if (dateRange == null) {
                return this;
            }
            return new RemoteStationFeatureImpl(this.stnFeature, dateRange);
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.stnFeature.getFeatureData();
        }

        @Override
        public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            String query = PointDatasetRemote.makeQuery("stn=" + this.s.getName(), null, this.dateRange);
            InputStream in = null;
            try {
                in = CdmRemote.sendQuery(RemoteStationCollection.this.uri, query);
                PointStream.MessageType mtype = PointStream.readMagic(in);
                if (mtype == PointStream.MessageType.End) {
                    in.close();
                    return new PointIteratorEmpty();
                }
                if (mtype != PointStream.MessageType.PointFeatureCollection) {
                    throw new RuntimeException("Station Request: bad response = " + (Object)((Object)mtype));
                }
                int len = NcStream.readVInt(in);
                byte[] b = new byte[len];
                NcStream.readFully(in, b);
                PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(b);
                this.riter = new RemotePointFeatureIterator(in, new PointStream.ProtobufPointFeatureMaker(pfc));
                this.riter.setCalculateBounds(this);
                return this.riter;
            }
            catch (Throwable t) {
                if (in != null) {
                    in.close();
                }
                throw new IOException(t.getMessage(), t);
            }
        }
    }

    private class RemoteStationCollectionSubset
    extends RemoteStationCollection {
        RemoteStationCollection from;

        RemoteStationCollectionSubset(RemoteStationCollection from, StationHelper sh, LatLonRect filter_bb, CalendarDateRange filter_date) throws IOException {
            super(from.uri, from.getTimeUnit(), from.getAltUnits(), sh);
            this.from = from;
            if (filter_bb == null) {
                this.boundingBoxSubset = from.getBoundingBox();
            } else {
                LatLonRect latLonRect = this.boundingBoxSubset = from.getBoundingBox() == null ? filter_bb : from.getBoundingBox().intersect(filter_bb);
            }
            this.dateRangeSubset = filter_date == null ? from.dateRangeSubset : (from.dateRangeSubset == null ? filter_date : from.dateRangeSubset.intersect(filter_date));
        }

        @Override
        protected StationHelper initStationHelper() {
            this.from.initStationHelper();
            this.stationHelper = new StationHelper();
            try {
                this.stationHelper.setStations(this.stationHelper.getStationFeatures(this.boundingBoxSubset));
                return this.stationHelper;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Station getStation(PointFeature feature) throws IOException {
            return this.from.getStation(feature);
        }
    }

    private class QueryByStationList
    implements QueryMaker {
        private QueryByStationList() {
        }

        @Override
        public String makeQuery() {
            StringBuilder query = new StringBuilder("stns=");
            for (Station s : RemoteStationCollection.this.stationHelper.getStations()) {
                query.append(s.getName());
                query.append(",");
            }
            return PointDatasetRemote.makeQuery(query.toString(), RemoteStationCollection.this.boundingBoxSubset, RemoteStationCollection.this.dateRangeSubset);
        }
    }
}

