/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.ADASConvention;
import ucar.nc2.dataset.conv.ATDRadarConvention;
import ucar.nc2.dataset.conv.AWIPSConvention;
import ucar.nc2.dataset.conv.AWIPSsatConvention;
import ucar.nc2.dataset.conv.AvhrrConvention;
import ucar.nc2.dataset.conv.CEDRICRadarConvention;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.dataset.conv.COARDSConvention;
import ucar.nc2.dataset.conv.CSMConvention;
import ucar.nc2.dataset.conv.Cosmic1Convention;
import ucar.nc2.dataset.conv.DefaultConvention;
import ucar.nc2.dataset.conv.EpicInsitu;
import ucar.nc2.dataset.conv.FslWindProfiler;
import ucar.nc2.dataset.conv.GDVConvention;
import ucar.nc2.dataset.conv.GIEFConvention;
import ucar.nc2.dataset.conv.HdfEosModisConvention;
import ucar.nc2.dataset.conv.HdfEosOmiConvention;
import ucar.nc2.dataset.conv.IFPSConvention;
import ucar.nc2.dataset.conv.IridlConvention;
import ucar.nc2.dataset.conv.Jason2Convention;
import ucar.nc2.dataset.conv.M3IOConvention;
import ucar.nc2.dataset.conv.MADISStation;
import ucar.nc2.dataset.conv.ModisSatellite;
import ucar.nc2.dataset.conv.NUWGConvention;
import ucar.nc2.dataset.conv.Nimbus;
import ucar.nc2.dataset.conv.NppConvention;
import ucar.nc2.dataset.conv.NsslRadarMosaicConvention;
import ucar.nc2.dataset.conv.Suomi;
import ucar.nc2.dataset.conv.UnidataObsConvention;
import ucar.nc2.dataset.conv.WRFConvention;
import ucar.nc2.dataset.conv.ZebraConvention;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;

public class CoordSysBuilder
implements CoordSysBuilderIF {
    public static final String resourcesDir = "resources/nj22/coords/";
    protected static Logger log = LoggerFactory.getLogger(CoordSysBuilder.class);
    private static List<Convention> conventionList = new ArrayList<Convention>();
    private static Map<String, String> ncmlHash = new HashMap<String, String>();
    private static boolean useMaximalCoordSys = true;
    private static boolean userMode = false;
    protected String conventionName = "_Coordinates";
    protected List<VarProcess> varList = new ArrayList<VarProcess>();
    protected Map<Dimension, List<VarProcess>> coordVarMap = new HashMap<Dimension, List<VarProcess>>();
    protected Formatter parseInfo = new Formatter();
    protected Formatter userAdvice = new Formatter();
    protected boolean debug = false;

    public static void registerNcML(String conventionName, String ncmlLocation) {
        ncmlHash.put(conventionName, ncmlLocation);
    }

    public static void registerConvention(String conventionName, Class c) {
        CoordSysBuilder.registerConvention(conventionName, c, null);
    }

    public static void registerConvention(String conventionName, Class c, ConventionNameOk match) {
        if (!CoordSysBuilderIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("CoordSysBuilderIF Class " + c.getName() + " must implement CoordSysBuilderIF");
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordSysBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordSysBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            conventionList.add(0, new Convention(conventionName, c, match));
        } else {
            conventionList.add(new Convention(conventionName, c, match));
        }
    }

    private static Class matchConvention(String convName) {
        for (Convention c : conventionList) {
            if (c.match == null && c.convName.equalsIgnoreCase(convName)) {
                return c.convClass;
            }
            if (c.match == null || !c.match.isMatch(convName, c.convName)) continue;
            return c.convClass;
        }
        return null;
    }

    public static void registerConvention(String conventionName, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        CoordSysBuilder.registerConvention(conventionName, c, null);
    }

    public static void setUseMaximalCoordSys(boolean b) {
        useMaximalCoordSys = b;
    }

    public static boolean getUseMaximalCoordSys() {
        return useMaximalCoordSys;
    }

    public static List<String> breakupConventionNames(String convAttValue) {
        ArrayList<String> names = new ArrayList<String>();
        if (convAttValue.indexOf(44) > 0 || convAttValue.indexOf(59) > 0) {
            StringTokenizer stoke = new StringTokenizer(convAttValue, ",;");
            while (stoke.hasMoreTokens()) {
                String name = stoke.nextToken();
                names.add(name.trim());
            }
        } else if (convAttValue.indexOf(47) > 0) {
            StringTokenizer stoke = new StringTokenizer(convAttValue, "/");
            while (stoke.hasMoreTokens()) {
                String name = stoke.nextToken();
                names.add(name.trim());
            }
        } else {
            StringTokenizer stoke = new StringTokenizer(convAttValue, " ");
            while (stoke.hasMoreTokens()) {
                String name = stoke.nextToken();
                names.add(name.trim());
            }
        }
        return names;
    }

    public static CoordSysBuilderIF factory(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        List<String> names;
        String convNcML;
        String convName = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (convName == null) {
            convName = ds.findAttValueIgnoreCase(null, "Convention", null);
        }
        if (convName != null) {
            convName = convName.trim();
        }
        if (convName != null && (convNcML = ncmlHash.get(convName)) != null) {
            CoordSysBuilder csb = new CoordSysBuilder();
            NcMLReader.wrapNcML(ds, convNcML, cancelTask);
            return csb;
        }
        Class<?> convClass = null;
        if (convName != null && (convClass = CoordSysBuilder.matchConvention(convName)) == null && (names = CoordSysBuilder.breakupConventionNames(convName)).size() > 0) {
            for (Convention conv : conventionList) {
                for (String name : names) {
                    if (!name.equalsIgnoreCase(conv.convName)) continue;
                    convClass = conv.convClass;
                    convName = name;
                }
                if (convClass == null) continue;
                break;
            }
        }
        if (convClass == null) {
            for (Convention conv : conventionList) {
                Method m;
                Class c = conv.convClass;
                try {
                    m = c.getMethod("isMine", NetcdfFile.class);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                try {
                    Boolean result = (Boolean)m.invoke(null, ds);
                    if (!result.booleanValue()) continue;
                    convClass = c;
                    break;
                }
                catch (Exception ex) {
                    log.error("ERROR: Class " + c.getName() + " Exception invoking isMine method\n" + ex);
                }
            }
        }
        CoordSysBuilderIF builder = null;
        if (convClass == null) {
            for (CoordSysBuilderIF csb : ServiceLoader.load(CoordSysBuilderIF.class)) {
                Method m;
                Class<?> c = csb.getClass();
                try {
                    m = c.getMethod("isMine", NetcdfFile.class);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                try {
                    Boolean result = (Boolean)m.invoke(null, ds);
                    if (!result.booleanValue()) continue;
                    builder = csb;
                    convClass = c;
                    break;
                }
                catch (Exception ex) {
                    log.error("ERROR: Class " + c.getName() + " Exception invoking isMine method%n" + ex);
                }
            }
        }
        if (convClass == null) {
            convClass = DefaultConvention.class;
        }
        if (builder == null) {
            try {
                builder = (CoordSysBuilderIF)convClass.newInstance();
            }
            catch (Exception e) {
                log.error("failed on CoordSysBuilderIF for " + convClass.getName(), (Throwable)e);
                return null;
            }
        }
        if (convName == null) {
            builder.addUserAdvice("No 'Conventions' global attribute.");
        } else if (convClass == DefaultConvention.class) {
            builder.addUserAdvice("No CoordSysBuilder is defined for Conventions= '" + convName + "'\n");
        } else {
            builder.setConventionUsed(convClass.getName());
        }
        ds.addAttribute(null, new Attribute("_CoordSysBuilder", convClass.getName()));
        return builder;
    }

    @Override
    public void setConventionUsed(String convName) {
        this.conventionName = convName;
    }

    @Override
    public String getConventionUsed() {
        return this.conventionName;
    }

    @Override
    public void addUserAdvice(String advice) {
        this.userAdvice.format("%s", advice);
    }

    @Override
    public String getParseInfo() {
        return this.parseInfo.toString();
    }

    @Override
    public String getUserAdvice() {
        return this.userAdvice.toString();
    }

    @Override
    public void augmentDataset(NetcdfDataset ncDataset, CancelTask cancelTask) throws IOException {
    }

    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        return null;
    }

    @Override
    public void buildCoordinateSystems(NetcdfDataset ncDataset) {
        this.parseInfo.format("Parsing with Convention = %s%n", this.conventionName);
        this.addVariables(ncDataset, ncDataset.getVariables(), this.varList);
        this.findCoordinateAxes(ncDataset);
        this.findCoordinateSystems(ncDataset);
        this.findCoordinateTransforms(ncDataset);
        this.makeCoordinateAxes(ncDataset);
        this.makeCoordinateSystems(ncDataset);
        this.assignCoordinateSystemsExplicit(ncDataset);
        this.makeCoordinateSystemsImplicit(ncDataset);
        if (useMaximalCoordSys) {
            this.makeCoordinateSystemsMaximal(ncDataset);
        }
        this.makeCoordinateTransforms(ncDataset);
        this.assignCoordinateTransforms(ncDataset);
        if (this.debug) {
            System.out.println("parseInfo = \n" + this.parseInfo.toString());
        }
    }

    private void addVariables(NetcdfDataset ncDataset, List<Variable> varList, List<VarProcess> varProcessList) {
        for (Variable v : varList) {
            varProcessList.add(new VarProcess(ncDataset, v));
            if (!(v instanceof Structure)) continue;
            List<Variable> nested = ((Structure)v).getVariables();
            this.addVariables(ncDataset, nested, varProcessList);
        }
    }

    protected void findCoordinateAxes(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordAxes != null) {
                this.findCoordinateAxes(vp, vp.coordAxes);
            }
            if (vp.coordinates == null) continue;
            this.findCoordinateAxes(vp, vp.coordinates);
        }
    }

    private void findCoordinateAxes(VarProcess vp, String coordinates) {
        StringTokenizer stoker = new StringTokenizer(coordinates);
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            VarProcess ap = this.findVarProcess(vname, vp);
            if (ap == null) {
                Group g = vp.v.getParentGroup();
                Variable v = g.findVariableOrInParent(vname);
                if (v != null) {
                    ap = this.findVarProcess(v.getFullName(), vp);
                } else {
                    this.parseInfo.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp.v.getFullName());
                    this.userAdvice.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp.v.getFullName());
                }
            }
            if (ap != null) {
                if (!ap.isCoordinateAxis) {
                    this.parseInfo.format(" CoordinateAxis = %s added; referenced from var= %s%n", vname, vp.v.getFullName());
                }
                ap.isCoordinateAxis = true;
                continue;
            }
            this.parseInfo.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp.v.getFullName());
            this.userAdvice.format("***Cant find coordAxis %s referenced from var= %s%n", vname, vp.v.getFullName());
        }
    }

    protected void findCoordinateSystems(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordSys == null) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordSys);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap != null) {
                    if (!ap.isCoordinateSystem) {
                        this.parseInfo.format(" CoordinateSystem = %s added; referenced from var= %s%n", vname, vp.v.getFullName());
                    }
                    ap.isCoordinateSystem = true;
                    continue;
                }
                this.parseInfo.format("***Cant find coordSystem %s referenced from var= %s%n", vname, vp.v.getFullName());
                this.userAdvice.format("***Cant find coordSystem %s referenced from var= %s%n", vname, vp.v.getFullName());
            }
        }
    }

    protected void findCoordinateTransforms(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordTransforms == null) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordTransforms);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap != null) {
                    if (!ap.isCoordinateTransform) {
                        this.parseInfo.format(" CoordinateTransform = %s added; referenced from var= %s%n", vname, vp.v.getFullName());
                    }
                    ap.isCoordinateTransform = true;
                    continue;
                }
                this.parseInfo.format("***Cant find CoordinateTransform %s referenced from var= %s%n", vname, vp.v.getFullName());
                this.userAdvice.format("***Cant find CoordinateTransform %s referenced from var= %s%n", vname, vp.v.getFullName());
            }
        }
    }

    protected void makeCoordinateAxes(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateAxis && !vp.isCoordinateVariable) continue;
            if (vp.axisType == null) {
                vp.axisType = this.getAxisType(ncDataset, (VariableEnhanced)((Object)vp.v));
            }
            if (vp.axisType == null) {
                this.userAdvice.format("Coordinate Axis %s does not have an assigned AxisType%n", vp.v.getFullName());
            }
            vp.makeIntoCoordinateAxis();
        }
    }

    protected void makeCoordinateSystems(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem) continue;
            vp.makeCoordinateSystem();
        }
    }

    protected void assignCoordinateSystemsExplicit(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (vp.coordSys == null || vp.isCoordinateTransform) continue;
            StringTokenizer stoker = new StringTokenizer(vp.coordSys);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap == null) {
                    this.parseInfo.format("***Cant find Coordinate System variable %s referenced from var= %s%n", vname, vp.v.getFullName());
                    this.userAdvice.format("***Cant find Coordinate System variable %s referenced from var= %s%n", vname, vp.v.getFullName());
                    continue;
                }
                if (ap.cs == null) {
                    this.parseInfo.format("***Not a Coordinate System variable %s referenced from var= %s%n", vname, vp.v.getFullName());
                    this.userAdvice.format("***Not a Coordinate System variable %s referenced from var= %s%n", vname, vp.v.getFullName());
                    continue;
                }
                VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
                ve.addCoordinateSystem(ap.cs);
            }
        }
        for (VarProcess csVar : this.varList) {
            if (!csVar.isCoordinateSystem || csVar.coordSysFor == null) continue;
            ArrayList<Dimension> dimList = new ArrayList<Dimension>(6);
            StringTokenizer stoker = new StringTokenizer(csVar.coordSysFor);
            while (stoker.hasMoreTokens()) {
                String dname = stoker.nextToken();
                Dimension dim = ncDataset.getRootGroup().findDimension(dname);
                if (dim == null) {
                    this.parseInfo.format("***Cant find Dimension %s referenced from CoordSys var= %s%n", dname, csVar.v.getFullName());
                    this.userAdvice.format("***Cant find Dimension %s referenced from CoordSys var= %s%n", dname, csVar.v.getFullName());
                    continue;
                }
                dimList.add(dim);
            }
            for (VarProcess vp : this.varList) {
                if (vp.hasCoordinateSystem() || !vp.isData() || csVar.cs == null) continue;
                VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
                if (!CoordinateSystem.isSubset(dimList, vp.v.getDimensionsAll()) || !CoordinateSystem.isSubset(vp.v.getDimensionsAll(), dimList)) continue;
                ve.addCoordinateSystem(csVar.cs);
            }
        }
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis> dataAxesList;
            VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
            if (vp.hasCoordinateSystem() || vp.coordAxes == null || !vp.isData() || (dataAxesList = this.getAxes(vp, vp.coordAxes, vp.v.getFullName())).size() <= 1) continue;
            String coordSysName = CoordinateSystem.makeName(dataAxesList);
            CoordinateSystem cs = ncDataset.findCoordinateSystem(coordSysName);
            if (cs != null) {
                ve.addCoordinateSystem(cs);
                this.parseInfo.format(" assigned explicit CoordSystem '%s' for var= %s%n", cs.getName(), vp.v.getFullName());
                continue;
            }
            CoordinateSystem csnew = new CoordinateSystem(ncDataset, dataAxesList, null);
            ve.addCoordinateSystem(csnew);
            ncDataset.addCoordinateSystem(csnew);
            this.parseInfo.format(" created explicit CoordSystem '%s' for var= %s%n", csnew.getName(), vp.v.getFullName());
        }
    }

    private List<CoordinateAxis> getAxes(VarProcess vp, String names, String varName) {
        ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
        StringTokenizer stoker = new StringTokenizer(names);
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            VarProcess ap = this.findVarProcess(vname, vp);
            if (ap != null) {
                CoordinateAxis axis = ap.makeIntoCoordinateAxis();
                if (axesList.contains(axis)) continue;
                axesList.add(axis);
                continue;
            }
            this.parseInfo.format("***Cant find Coordinate Axis %s referenced from var= %s%n", vname, varName);
            this.userAdvice.format("***Cant find Coordinate Axis %s referenced from var= %s%n", vname, varName);
        }
        return axesList;
    }

    protected void makeCoordinateSystemsImplicit(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis> dataAxesList;
            if (vp.hasCoordinateSystem() || !vp.maybeData() || (dataAxesList = vp.findCoordinateAxes(true)).size() < 2) continue;
            VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
            String csName = CoordinateSystem.makeName(dataAxesList);
            CoordinateSystem cs = ncDataset.findCoordinateSystem(csName);
            if (cs != null && cs.isComplete(vp.v)) {
                ve.addCoordinateSystem(cs);
                this.parseInfo.format(" assigned implicit CoordSystem '%s' for var= %s%n", cs.getName(), vp.v.getFullName());
                continue;
            }
            CoordinateSystem csnew = new CoordinateSystem(ncDataset, dataAxesList, null);
            csnew.setImplicit(true);
            if (!csnew.isComplete(vp.v)) continue;
            ve.addCoordinateSystem(csnew);
            ncDataset.addCoordinateSystem(csnew);
            this.parseInfo.format(" created implicit CoordSystem '%s' for var= %s%n", csnew.getName(), vp.v.getFullName());
        }
    }

    protected void makeCoordinateSystemsMaximal(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            VariableEnhanced ve = (VariableEnhanced)((Object)vp.v);
            CoordinateSystem implicit = null;
            if (vp.hasCoordinateSystem() || !vp.isData()) continue;
            CoordinateSystem existing = null;
            if (ve.getCoordinateSystems().size() == 1) {
                existing = ve.getCoordinateSystems().get(0);
                if (!existing.isImplicit() || existing.getRankRange() >= ve.getRank()) continue;
                implicit = existing;
            }
            ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
            List<CoordinateAxis> axes = ncDataset.getCoordinateAxes();
            for (CoordinateAxis axis : axes) {
                if (!this.isCoordinateAxisForVariable(axis, ve)) continue;
                axisList.add(axis);
            }
            if (existing != null && axisList.size() <= existing.getRankRange() || axisList.size() < 2) continue;
            String csName = CoordinateSystem.makeName(axisList);
            CoordinateSystem cs = ncDataset.findCoordinateSystem(csName);
            if (cs != null) {
                if (null != implicit) {
                    ve.removeCoordinateSystem(implicit);
                }
                ve.addCoordinateSystem(cs);
                this.parseInfo.format(" assigned maximal CoordSystem '%s' for var= %s%n", cs.getName(), ve.getFullName());
                continue;
            }
            CoordinateSystem csnew = new CoordinateSystem(ncDataset, axisList, null);
            csnew.setImplicit(true);
            if (null != implicit) {
                ve.removeCoordinateSystem(implicit);
            }
            ve.addCoordinateSystem(csnew);
            ncDataset.addCoordinateSystem(csnew);
            this.parseInfo.format(" created maximal CoordSystem '%s' for var= %s%n", csnew.getName(), ve.getFullName());
        }
    }

    protected boolean isCoordinateAxisForVariable(Variable axis, VariableEnhanced v) {
        List<Dimension> varDims = v.getDimensionsAll();
        int checkDims = axis.getRank();
        if (axis.getDataType() == DataType.CHAR) {
            --checkDims;
        }
        for (int i = 0; i < checkDims; ++i) {
            Dimension axisDim = axis.getDimension(i);
            if (varDims.contains(axisDim)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasXY(List<CoordinateAxis> coordAxes) {
        boolean hasX = false;
        boolean hasY = false;
        boolean hasLat = false;
        boolean hasLon = false;
        for (CoordinateAxis axis : coordAxes) {
            AxisType axisType = axis.getAxisType();
            if (axisType == AxisType.GeoX) {
                hasX = true;
            }
            if (axisType == AxisType.GeoY) {
                hasY = true;
            }
            if (axisType == AxisType.Lat) {
                hasLat = true;
            }
            if (axisType != AxisType.Lon) continue;
            hasLon = true;
        }
        return hasLat && hasLon || hasX && hasY;
    }

    protected void makeCoordinateTransforms(NetcdfDataset ncDataset) {
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct != null) continue;
            vp.ct = CoordTransBuilder.makeCoordinateTransform(vp.ds, vp.v, this.parseInfo, this.userAdvice);
        }
    }

    protected CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        return CoordTransBuilder.makeCoordinateTransform(ds, ctv, this.parseInfo, this.userAdvice);
    }

    protected void assignCoordinateTransforms(NetcdfDataset ncDataset) {
        String vname;
        StringTokenizer stoker;
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateSystem || vp.coordTransforms == null) continue;
            stoker = new StringTokenizer(vp.coordTransforms);
            while (stoker.hasMoreTokens()) {
                vname = stoker.nextToken();
                VarProcess ap = this.findVarProcess(vname, vp);
                if (ap != null) {
                    if (ap.ct != null) {
                        vp.addCoordinateTransform(ap.ct);
                        this.parseInfo.format(" assign explicit coordTransform %s to CoordSys= %s%n", ap.ct, vp.cs);
                        continue;
                    }
                    this.parseInfo.format("***Cant find coordTransform in %s referenced from var= %s%n", vname, vp.v.getFullName());
                    this.userAdvice.format("***Cant find coordTransform in %s referenced from var= %s%n", vname, vp.v.getFullName());
                    continue;
                }
                this.parseInfo.format("***Cant find coordTransform variable= %s referenced from var= %s%n", vname, vp.v.getFullName());
                this.userAdvice.format("***Cant find coordTransform variable= %s referenced from var= %s%n", vname, vp.v.getFullName());
            }
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordSys == null) continue;
            stoker = new StringTokenizer(vp.coordSys);
            while (stoker.hasMoreTokens()) {
                vname = stoker.nextToken();
                VarProcess vcs = this.findVarProcess(vname, vp);
                if (vcs == null) {
                    this.parseInfo.format("***Cant find coordSystem variable= %s referenced from var= %s%n", vname, vp.v.getFullName());
                    this.userAdvice.format("***Cant find coordSystem variable= %s referenced from var= %s%n", vname, vp.v.getFullName());
                    continue;
                }
                vcs.addCoordinateTransform(vp.ct);
                this.parseInfo.format("***assign explicit coordTransform %s to CoordSys=  %s%n", vp.ct, vp.cs);
            }
        }
        for (VarProcess vp : this.varList) {
            List<CoordinateAxis> dataAxesList;
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordAxes == null || (dataAxesList = vp.findCoordinateAxes(false)).size() <= 0) continue;
            for (CoordinateSystem cs : ncDataset.getCoordinateSystems()) {
                if (!cs.containsAxes(dataAxesList)) continue;
                cs.addCoordinateTransform(vp.ct);
                this.parseInfo.format("***assign (implicit coordAxes) coordTransform %s to CoordSys=  %s%n", vp.ct, cs);
            }
        }
        for (VarProcess vp : this.varList) {
            if (!vp.isCoordinateTransform || vp.ct == null || vp.coordAxisTypes == null) continue;
            ArrayList<AxisType> axisTypesList = new ArrayList<AxisType>();
            StringTokenizer stoker2 = new StringTokenizer(vp.coordAxisTypes);
            while (stoker2.hasMoreTokens()) {
                String name = stoker2.nextToken();
                AxisType atype = AxisType.getType(name);
                if (null == atype) continue;
                axisTypesList.add(atype);
            }
            if (axisTypesList.size() <= 0) continue;
            for (CoordinateSystem cs : ncDataset.getCoordinateSystems()) {
                if (!cs.containsAxisTypes(axisTypesList)) continue;
                cs.addCoordinateTransform(vp.ct);
                this.parseInfo.format("***assign (implicit coordAxisType) coordTransform %s to CoordSys=  %s%n", vp.ct, cs);
            }
        }
    }

    protected VarProcess findVarProcess(String name, VarProcess from) {
        if (name == null) {
            return null;
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.v.getFullName())) continue;
            return vp;
        }
        if (from != null) {
            for (VarProcess vp : this.varList) {
                if (!name.equals(vp.v.getShortName()) || !vp.v.getGroup().equals(from.v.getGroup())) continue;
                return vp;
            }
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.v.getShortName())) continue;
            return vp;
        }
        return null;
    }

    protected VarProcess findCoordinateAxis(String name) {
        if (name == null) {
            return null;
        }
        for (VarProcess vp : this.varList) {
            if (!name.equals(vp.v.getFullName()) || !vp.isCoordinateVariable && !vp.isCoordinateAxis) continue;
            return vp;
        }
        return null;
    }

    protected void addCoordinateVariable(Dimension dim, VarProcess vp) {
        List<VarProcess> list = this.coordVarMap.get(dim);
        if (list == null) {
            list = new ArrayList<VarProcess>();
            this.coordVarMap.put(dim, list);
        }
        if (!list.contains(vp)) {
            list.add(vp);
        }
    }

    protected VariableDS makeCoordinateTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        VariableDS v = CoordTransBuilder.makeDummyTransformVariable(ds, ct);
        this.parseInfo.format("  made CoordinateTransformVariable: %s%n", ct.getName());
        return v;
    }

    public static VariableDS makeDummyTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        return CoordTransBuilder.makeDummyTransformVariable(ds, ct);
    }

    static {
        CoordSysBuilder.registerConvention("_Coordinates", CoordSysBuilder.class, null);
        CoordSysBuilder.registerConvention("CF-1.", CF1Convention.class, new ConventionNameOk(){

            @Override
            public boolean isMatch(String convName, String wantName) {
                if (convName.startsWith(wantName)) {
                    return true;
                }
                List<String> names = CoordSysBuilder.breakupConventionNames(convName);
                for (String name : names) {
                    if (!name.startsWith(wantName)) continue;
                    return true;
                }
                return false;
            }
        });
        CoordSysBuilder.registerConvention("CDM-Extended-CF", CF1Convention.class);
        CoordSysBuilder.registerConvention("COARDS", COARDSConvention.class, null);
        CoordSysBuilder.registerConvention("NCAR-CSM", CSMConvention.class, null);
        CoordSysBuilder.registerConvention("Unidata Observation Dataset v1.0", UnidataObsConvention.class, null);
        CoordSysBuilder.registerConvention("GDV", GDVConvention.class, null);
        CoordSysBuilder.registerConvention("ATDRadar", ATDRadarConvention.class, null);
        CoordSysBuilder.registerConvention("CEDRICRadar", CEDRICRadarConvention.class, null);
        CoordSysBuilder.registerConvention("Zebra", ZebraConvention.class, null);
        CoordSysBuilder.registerConvention("GIEF/GIEF-F", GIEFConvention.class, null);
        CoordSysBuilder.registerConvention("IRIDL", IridlConvention.class, null);
        CoordSysBuilder.registerConvention("NUWG", NUWGConvention.class, null);
        CoordSysBuilder.registerConvention("AWIPS", AWIPSConvention.class, null);
        CoordSysBuilder.registerConvention("AWIPS-Sat", AWIPSsatConvention.class, null);
        CoordSysBuilder.registerConvention("WRF", WRFConvention.class, null);
        CoordSysBuilder.registerConvention("M3IO", M3IOConvention.class, null);
        CoordSysBuilder.registerConvention("IFPS", IFPSConvention.class, null);
        CoordSysBuilder.registerConvention("ARPS/ADAS", ADASConvention.class, null);
        CoordSysBuilder.registerConvention("MADIS surface observations, v1.0", MADISStation.class, null);
        CoordSysBuilder.registerConvention("epic-insitu-1.0", EpicInsitu.class, null);
        CoordSysBuilder.registerConvention("NCAR-RAF/nimbus", Nimbus.class, null);
        CoordSysBuilder.registerConvention("Cosmic1Convention", Cosmic1Convention.class, null);
        CoordSysBuilder.registerConvention("Jason2Convention", Jason2Convention.class, null);
        CoordSysBuilder.registerConvention("Suomi", Suomi.class, null);
        CoordSysBuilder.registerConvention("NSSL National Reflectivity Mosaic", NsslRadarMosaicConvention.class, null);
        CoordSysBuilder.registerConvention("FslWindProfiler", FslWindProfiler.class, null);
        CoordSysBuilder.registerConvention("ModisSatellite", ModisSatellite.class, null);
        CoordSysBuilder.registerConvention("AvhrrSatellite", AvhrrConvention.class, null);
        CoordSysBuilder.registerConvention("NPP/NPOESS", NppConvention.class, null);
        CoordSysBuilder.registerConvention("HDF5-EOS-OMI", HdfEosOmiConvention.class, null);
        CoordSysBuilder.registerConvention("HDF4-EOS-MODIS", HdfEosModisConvention.class, null);
        userMode = true;
    }

    public class VarProcess {
        public NetcdfDataset ds;
        public Variable v;
        public boolean isCoordinateVariable;
        public boolean isCoordinateAxis;
        public AxisType axisType;
        public String coordAxes;
        public String coordSys;
        public String coordSysFor;
        public String coordVarAlias;
        public String positive;
        public String coordAxisTypes;
        public String coordinates;
        public CoordinateAxis axis;
        public boolean isCoordinateSystem;
        public String coordTransforms;
        public CoordinateSystem cs;
        public boolean isCoordinateTransform;
        public String coordTransformType;
        public CoordinateTransform ct;

        private VarProcess(NetcdfDataset ds, Variable v) {
            Attribute att;
            this.ds = ds;
            this.v = v;
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            this.isCoordinateVariable = v.isCoordinateVariable();
            if (this.isCoordinateVariable) {
                v.isCoordinateVariable();
                CoordSysBuilder.this.addCoordinateVariable(v.getDimension(0), this);
                CoordSysBuilder.this.parseInfo.format(" Coordinate Variable added = %s for dimension %s%n", v.getFullName(), v.getDimension(0));
            }
            if ((att = v.findAttributeIgnoreCase("_CoordinateAxisType")) != null) {
                String axisName = att.getStringValue();
                this.axisType = AxisType.getType(axisName);
                this.isCoordinateAxis = true;
                CoordSysBuilder.this.parseInfo.format(" Coordinate Axis added = %s type= %s%n", v.getFullName(), axisName);
            }
            this.coordVarAlias = ds.findAttValueIgnoreCase(v, "_CoordinateAliasForDimension", null);
            if (this.coordVarAlias != null) {
                this.coordVarAlias = this.coordVarAlias.trim();
                if (v.getRank() != 1) {
                    CoordSysBuilder.this.parseInfo.format("**ERROR Coordinate Variable Alias %s has rank %d%n", v.getFullName(), v.getRank());
                    CoordSysBuilder.this.userAdvice.format("**ERROR Coordinate Variable Alias %s has rank %d%n", v.getFullName(), v.getRank());
                } else {
                    Dimension vDim;
                    Dimension coordDim = v.getGroup().findDimension(this.coordVarAlias);
                    if (!coordDim.equals(vDim = v.getDimension(0))) {
                        CoordSysBuilder.this.parseInfo.format("**ERROR Coordinate Variable Alias %s names wrong dimension %s%n", v.getFullName(), this.coordVarAlias);
                        CoordSysBuilder.this.userAdvice.format("**ERROR Coordinate Variable Alias %s names wrong dimension %s%n", v.getFullName(), this.coordVarAlias);
                    } else {
                        this.isCoordinateAxis = true;
                        CoordSysBuilder.this.addCoordinateVariable(coordDim, this);
                        CoordSysBuilder.this.parseInfo.format(" Coordinate Variable Alias added = %s for dimension= %s%n", v.getFullName(), this.coordVarAlias);
                    }
                }
            }
            this.positive = ds.findAttValueIgnoreCase(v, "_CoordinateZisPositive", null);
            if (this.positive == null) {
                this.positive = ds.findAttValueIgnoreCase(v, "positive", null);
            } else {
                this.isCoordinateAxis = true;
                this.positive = this.positive.trim();
                CoordSysBuilder.this.parseInfo.format(" Coordinate Axis added(from positive attribute ) = %s for dimension= %s%n", v.getFullName(), this.coordVarAlias);
            }
            this.coordAxes = ds.findAttValueIgnoreCase(v, "_CoordinateAxes", null);
            this.coordSys = ds.findAttValueIgnoreCase(v, "_CoordinateSystems", null);
            this.coordSysFor = ds.findAttValueIgnoreCase(v, "_CoordinateSystemFor", null);
            this.coordTransforms = ds.findAttValueIgnoreCase(v, "_CoordinateTransforms", null);
            this.isCoordinateSystem = this.coordTransforms != null || this.coordSysFor != null;
            this.coordAxisTypes = ds.findAttValueIgnoreCase(v, "_CoordinateAxisTypes", null);
            this.coordTransformType = ds.findAttValueIgnoreCase(v, "_CoordinateTransformType", null);
            boolean bl = this.isCoordinateTransform = this.coordTransformType != null || this.coordAxisTypes != null;
            if (!(this.isCoordinateSystem || this.isCoordinateTransform || this.isCoordinateAxis || this.coordAxes == null)) {
                StringTokenizer stoker = new StringTokenizer(this.coordAxes);
                while (stoker.hasMoreTokens()) {
                    String vname = stoker.nextToken();
                    Variable axis = ds.findVariable(vname);
                    if (axis == null || CoordSysBuilder.this.isCoordinateAxisForVariable(axis, ve)) continue;
                    this.isCoordinateSystem = true;
                }
            }
        }

        public VarProcess(NetcdfDataset ds) {
            this.ds = ds;
        }

        public boolean isData() {
            return !this.isCoordinateVariable && !this.isCoordinateAxis && !this.isCoordinateSystem && !this.isCoordinateTransform;
        }

        public boolean maybeData() {
            return !this.isCoordinateVariable && !this.isCoordinateSystem && !this.isCoordinateTransform;
        }

        public boolean hasCoordinateSystem() {
            return ((VariableEnhanced)((Object)this.v)).getCoordinateSystems().size() > 0;
        }

        public String toString() {
            return this.v.getShortName();
        }

        public CoordinateAxis makeIntoCoordinateAxis() {
            if (this.axis != null) {
                return this.axis;
            }
            this.axis = this.ds.addCoordinateAxis((VariableDS)this.v);
            this.v = this.axis;
            if (this.axisType != null) {
                this.axis.setAxisType(this.axisType);
                this.axis.addAttribute(new Attribute("_CoordinateAxisType", this.axisType.toString()));
                if ((this.axisType == AxisType.Height || this.axisType == AxisType.Pressure || this.axisType == AxisType.GeoZ) && this.positive != null) {
                    this.axis.setPositive(this.positive);
                    this.axis.addAttribute(new Attribute("_CoordinateZisPositive", this.positive));
                }
            }
            return this.axis;
        }

        public void makeCoordinateSystem() {
            ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
            if (this.coordAxes != null) {
                StringTokenizer stoker = new StringTokenizer(this.coordAxes);
                while (stoker.hasMoreTokens()) {
                    String vname = stoker.nextToken();
                    VarProcess ap = CoordSysBuilder.this.findVarProcess(vname, this);
                    if (ap != null) {
                        CoordinateAxis axis = ap.makeIntoCoordinateAxis();
                        if (axesList.contains(axis)) continue;
                        axesList.add(axis);
                        continue;
                    }
                    CoordSysBuilder.this.parseInfo.format(" Cant find axes %s for Coordinate System %s%n", vname, this.v.getFullName());
                    CoordSysBuilder.this.userAdvice.format(" Cant find axes %s for Coordinate System %s%n", vname, this.v.getFullName());
                }
            }
            if (axesList.size() == 0) {
                CoordSysBuilder.this.parseInfo.format(" No axes found for Coordinate System %s%n", this.v.getFullName());
                CoordSysBuilder.this.userAdvice.format(" No axes found for Coordinate System %s%n", this.v.getFullName());
                return;
            }
            this.cs = new CoordinateSystem(this.ds, axesList, null);
            this.ds.addCoordinateSystem(this.cs);
            CoordSysBuilder.this.parseInfo.format(" Made Coordinate System %s for ", this.cs.getName());
            this.v.getNameAndDimensions(CoordSysBuilder.this.parseInfo, true, false);
            CoordSysBuilder.this.parseInfo.format(" from %s%n", this.coordAxes);
        }

        public List<CoordinateAxis> findCoordinateAxes(boolean addCoordVariables) {
            CoordinateAxis axis;
            VarProcess ap;
            String vname;
            StringTokenizer stoker;
            ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
            if (this.coordAxes != null) {
                stoker = new StringTokenizer(this.coordAxes);
                while (stoker.hasMoreTokens()) {
                    vname = stoker.nextToken();
                    ap = CoordSysBuilder.this.findVarProcess(vname, this);
                    if (ap == null || axesList.contains(axis = ap.makeIntoCoordinateAxis())) continue;
                    axesList.add(axis);
                }
            } else if (this.coordinates != null) {
                stoker = new StringTokenizer(this.coordinates);
                while (stoker.hasMoreTokens()) {
                    vname = stoker.nextToken();
                    ap = CoordSysBuilder.this.findVarProcess(vname, this);
                    if (ap == null || axesList.contains(axis = ap.makeIntoCoordinateAxis())) continue;
                    axesList.add(axis);
                }
            }
            if (addCoordVariables) {
                for (Dimension d : this.v.getDimensions()) {
                    List<VarProcess> coordVars = CoordSysBuilder.this.coordVarMap.get(d);
                    if (coordVars == null) continue;
                    for (VarProcess vp : coordVars) {
                        CoordinateAxis axis2 = vp.makeIntoCoordinateAxis();
                        if (axesList.contains(axis2)) continue;
                        axesList.add(axis2);
                    }
                }
            }
            return axesList;
        }

        void addCoordinateTransform(CoordinateTransform ct) {
            if (this.cs == null) {
                CoordSysBuilder.this.parseInfo.format("  %s: no CoordinateSystem for CoordinateTransformVariable: %s%n", this.v.getFullName(), ct.getName());
                return;
            }
            this.cs.addCoordinateTransform(ct);
        }
    }

    private class VarProcessSorter
    implements Comparator<VarProcess> {
        private VarProcessSorter() {
        }

        @Override
        public int compare(VarProcess o1, VarProcess o2) {
            return o2.v.getRank() - o1.v.getRank();
        }
    }

    private static class Convention {
        String convName;
        Class convClass;
        ConventionNameOk match;

        Convention(String convName, Class convClass, ConventionNameOk match) {
            this.convName = convName;
            this.convClass = convClass;
            this.match = match;
        }
    }

    public static interface ConventionNameOk {
        public boolean isMatch(String var1, String var2);
    }
}

