/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Iterator;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionConfig;
import thredds.inventory.MController;
import thredds.inventory.MFile;

@ThreadSafe
public class ControllerOS7
implements MController {
    private static Logger logger = LoggerFactory.getLogger(ControllerOS7.class);
    private int countFiles;
    private int countDirs;
    private int countOther;
    private int countSyms;
    long start = System.currentTimeMillis();

    @Override
    public Iterator<MFile> getInventoryAll(CollectionConfig mc, boolean recheck) {
        return null;
    }

    @Override
    public Iterator<MFile> getInventoryTop(CollectionConfig mc, boolean recheck) throws IOException {
        Path cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!Files.exists(cd = Paths.get(path, new String[0]), new LinkOption[0])) {
            return null;
        }
        return new MFileIterator(cd, new CollectionFilter(mc));
    }

    @Override
    public Iterator<MFile> getSubdirs(CollectionConfig mc, boolean recheck) {
        return null;
    }

    @Override
    public void close() {
    }

    private static void walkFileTree() throws IOException {
        Path dir = Paths.get("B:/ndfd/", new String[0]);
        long start = System.currentTimeMillis();
        PrintFiles pf = new PrintFiles();
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(dir, pf);
        long took = (System.currentTimeMillis() - start) / 1000L;
        System.out.printf("took %s secs%n", took);
        System.out.printf("%s%n", pf);
    }

    private void show(Path p, BasicFileAttributes attr) {
        System.out.printf("File: %s%n", p);
        System.out.println("    creationTime: " + attr.creationTime());
        System.out.println("  lastAccessTime: " + attr.lastAccessTime());
        System.out.println("lastModifiedTime: " + attr.lastModifiedTime());
        System.out.println("   isDirectory: " + attr.isDirectory());
        System.out.println("       isOther: " + attr.isOther());
        System.out.println(" isRegularFile: " + attr.isRegularFile());
        System.out.println("isSymbolicLink: " + attr.isSymbolicLink());
        System.out.println("size: " + attr.size());
        System.out.println("--------------------");
    }

    private void visitFile(Path file, BasicFileAttributes attr) {
        if (attr.isSymbolicLink()) {
            ++this.countSyms;
        } else if (attr.isRegularFile()) {
            ++this.countFiles;
        } else {
            ++this.countOther;
        }
        if (this.countFiles % 10000 == 0) {
            double took = System.currentTimeMillis() - this.start;
            double rate = (double)this.countFiles / took;
            double drate = (double)this.countDirs / took;
            System.out.printf("%s file rate=%f/msec drate=%f/msec%n", this.countFiles, rate, drate);
        }
    }

    private void dirStream(Path dir) throws IOException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir, new MyFilter());){
            for (Path p : ds) {
                BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                this.visitFile(p, attr);
                if (!attr.isDirectory()) continue;
                ++this.countDirs;
                this.dirStream(p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void dirStream() throws IOException {
        Path dir = Paths.get("B:/ndfd/", new String[0]);
        long start = System.currentTimeMillis();
        ControllerOS7 c = new ControllerOS7();
        c.dirStream(dir);
        long took = (System.currentTimeMillis() - start) / 1000L;
        System.out.printf("took %s secs%n", took);
    }

    public static void main(String[] args) throws IOException {
        Path firstPath = Paths.get("/200901/20090101/LEHZ97_KNHC_200901011102", new String[0]).getParent();
        for (int i = 0; i < firstPath.getNameCount(); ++i) {
            System.out.printf("  %s%n", firstPath.getName(i));
        }
        Path currentBasePath = Paths.get("B:/ndfd/ncdc1Year-20090101.ncx", new String[0]).getParent();
        for (int i = 0; i < currentBasePath.getNameCount(); ++i) {
            System.out.printf("  %s%n", currentBasePath.getName(i));
        }
        Path res = currentBasePath.resolve(firstPath);
        System.out.printf("res=%s%n", res);
    }

    private class MyFilter2
    implements DirectoryStream.Filter<Path> {
        PathFilter pathFilter;

        private MyFilter2(PathFilter pathFilter) {
            this.pathFilter = pathFilter;
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            if (this.pathFilter != null && !this.pathFilter.accept(entry)) {
                return false;
            }
            String last = entry.getName(entry.getNameCount() - 1).toString();
            return !last.endsWith(".gbx9") && !last.endsWith(".ncx");
        }
    }

    public static interface PathFilter {
        public boolean accept(Path var1);
    }

    public static interface Visitor {
        public void consume(MFile var1);
    }

    private class MyFilter
    implements DirectoryStream.Filter<Path> {
        private MyFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return !entry.endsWith(".gbx9") && !entry.endsWith(".ncx");
        }
    }

    public static class PrintFiles
    extends SimpleFileVisitor<Path> {
        private int countFiles;
        private int countDirs;
        private int countOther;
        private int countSyms;
        long start = System.currentTimeMillis();

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (attr.isSymbolicLink()) {
                ++this.countSyms;
            } else if (attr.isRegularFile()) {
                ++this.countFiles;
            } else {
                ++this.countOther;
            }
            if (this.countFiles % 10000 == 0) {
                double took = System.currentTimeMillis() - this.start;
                double rate = (double)this.countFiles / took;
                double drate = (double)this.countDirs / took;
                System.out.printf("%s file rate=%f/msec drate=%f/msec%n", this.countFiles, rate, drate);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            System.out.format("Directory: %s%n", dir);
            ++this.countDirs;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            System.err.println(exc);
            return FileVisitResult.CONTINUE;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PrintFiles{");
            sb.append("countFiles=").append(this.countFiles);
            sb.append(", countDirs=").append(this.countDirs);
            sb.append(", countOther=").append(this.countOther);
            sb.append(", countSyms=").append(this.countSyms);
            sb.append('}');
            return sb.toString();
        }
    }

    private class MFileIterator
    implements Iterator<MFile> {
        Iterator<Path> dirStream;

        MFileIterator(Path dir, DirectoryStream.Filter<Path> filter) throws IOException {
            this.dirStream = filter != null ? Files.newDirectoryStream(dir, filter).iterator() : Files.newDirectoryStream(dir).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.dirStream.hasNext();
        }

        @Override
        public MFile next() {
            try {
                return new MFileOS7(this.dirStream.next());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CollectionFilter
    implements DirectoryStream.Filter<Path> {
        CollectionConfig mc;

        private CollectionFilter(CollectionConfig mc) {
            this.mc = mc;
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return !entry.endsWith(".gbx9") && !entry.endsWith(".ncx");
        }
    }
}

