/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;

public class VariableSimpleImpl
implements VariableSimpleIF {
    private final String name;
    private final String desc;
    private final String units;
    private final DataType dt;
    private final List<Attribute> atts = new ArrayList<Attribute>();

    public static VariableSimpleImpl make(String name, String desc, String units, DataType dt) {
        return new VariableSimpleImpl(name, desc, units, dt);
    }

    VariableSimpleImpl(String name, String desc, String units, DataType dt) {
        this.name = name;
        this.desc = desc;
        this.units = units;
        this.dt = dt;
        this.atts.add(new Attribute("units", units));
        this.atts.add(new Attribute("long_name", desc));
    }

    public VariableSimpleImpl add(Attribute att) {
        this.atts.add(att);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getUnitsString() {
        return this.units;
    }

    @Override
    public int getRank() {
        return 0;
    }

    @Override
    public int[] getShape() {
        return new int[0];
    }

    @Override
    public List<Dimension> getDimensions() {
        return null;
    }

    @Override
    public DataType getDataType() {
        return this.dt;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.atts;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute att : this.atts) {
            if (!att.getShortName().equalsIgnoreCase(name)) continue;
            return att;
        }
        return null;
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.name.compareTo(o.getShortName());
    }
}

